/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.41.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.DowPatternGroupSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import travel.wink.sdk.extranet.model.TransactionalTravelInventorySupplier;
import travel.wink.sdk.extranet.model.TravelInventoryRecognitionSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Spa data
 */
@JsonPropertyOrder({
  SpaSupplier.JSON_PROPERTY_IDENTIFIER,
  SpaSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  SpaSupplier.JSON_PROPERTY_FEATURED_IND,
  SpaSupplier.JSON_PROPERTY_LIFESTYLE_TYPE,
  SpaSupplier.JSON_PROPERTY_LOCATION,
  SpaSupplier.JSON_PROPERTY_DESCRIPTIONS,
  SpaSupplier.JSON_PROPERTY_MULTIMEDIAS,
  SpaSupplier.JSON_PROPERTY_CONTACT,
  SpaSupplier.JSON_PROPERTY_ADDRESS,
  SpaSupplier.JSON_PROPERTY_COMMISSIONABLE,
  SpaSupplier.JSON_PROPERTY_NAME,
  SpaSupplier.JSON_PROPERTY_PROXIMITY_CODE,
  SpaSupplier.JSON_PROPERTY_SORT,
  SpaSupplier.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  SpaSupplier.JSON_PROPERTY_BOOKABLE,
  SpaSupplier.JSON_PROPERTY_ACTIVE,
  SpaSupplier.JSON_PROPERTY_DISABILITY_FEATURES,
  SpaSupplier.JSON_PROPERTY_SECURITY_FEATURES,
  SpaSupplier.JSON_PROPERTY_SOCIALS,
  SpaSupplier.JSON_PROPERTY_PRICE_POINT,
  SpaSupplier.JSON_PROPERTY_RECOGNITION_LIST,
  SpaSupplier.JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST,
  SpaSupplier.JSON_PROPERTY_APPLICABLE_START,
  SpaSupplier.JSON_PROPERTY_APPLICABLE_END,
  SpaSupplier.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  SpaSupplier.JSON_PROPERTY_OPENS,
  SpaSupplier.JSON_PROPERTY_CLOSES,
  SpaSupplier.JSON_PROPERTY_DAYS_OF_WEEK,
  SpaSupplier.JSON_PROPERTY_AMENITIES
})
@JsonTypeName("Spa_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T13:12:29.043847278+07:00[Asia/Bangkok]")
public class SpaSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionSupplier> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaSupplier> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactSupplier contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionSupplier> recognitionList;

  public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
  private List<TransactionalTravelInventorySupplier> transactionalInventoryList;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupSupplier daysOfWeek;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities;

  public SpaSupplier() {
  }

  public SpaSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SpaSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public SpaSupplier featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public SpaSupplier lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public SpaSupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public SpaSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SpaSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionSupplier> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
    this.descriptions = descriptions;
  }


  public SpaSupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public SpaSupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaSupplier> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
    this.multimedias = multimedias;
  }


  public SpaSupplier contact(ContactSupplier contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactSupplier getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactSupplier contact) {
    this.contact = contact;
  }


  public SpaSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public SpaSupplier commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public SpaSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SpaSupplier proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public SpaSupplier sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SpaSupplier minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public SpaSupplier bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public SpaSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public SpaSupplier disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public SpaSupplier addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public SpaSupplier securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public SpaSupplier addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public SpaSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public SpaSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public SpaSupplier pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public SpaSupplier recognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public SpaSupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionSupplier> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public SpaSupplier transactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    
    this.transactionalInventoryList = transactionalInventoryList;
    return this;
  }

  public SpaSupplier addTransactionalInventoryListItem(TransactionalTravelInventorySupplier transactionalInventoryListItem) {
    if (this.transactionalInventoryList == null) {
      this.transactionalInventoryList = new ArrayList<>();
    }
    this.transactionalInventoryList.add(transactionalInventoryListItem);
    return this;
  }

   /**
   * Purchasable items for this inventory.
   * @return transactionalInventoryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionalTravelInventorySupplier> getTransactionalInventoryList() {
    return transactionalInventoryList;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    this.transactionalInventoryList = transactionalInventoryList;
  }


  public SpaSupplier applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public SpaSupplier applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public SpaSupplier reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public SpaSupplier opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public SpaSupplier closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public SpaSupplier daysOfWeek(DowPatternGroupSupplier daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupSupplier daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public SpaSupplier amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public SpaSupplier addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * UnSupported OTA specification &#x60;SPA&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpaSupplier spaSupplier = (SpaSupplier) o;
    return Objects.equals(this.identifier, spaSupplier.identifier) &&
        Objects.equals(this.hotelIdentifier, spaSupplier.hotelIdentifier) &&
        Objects.equals(this.featuredInd, spaSupplier.featuredInd) &&
        Objects.equals(this.lifestyleType, spaSupplier.lifestyleType) &&
        Objects.equals(this.location, spaSupplier.location) &&
        Objects.equals(this.descriptions, spaSupplier.descriptions) &&
        Objects.equals(this.multimedias, spaSupplier.multimedias) &&
        Objects.equals(this.contact, spaSupplier.contact) &&
        Objects.equals(this.address, spaSupplier.address) &&
        Objects.equals(this.commissionable, spaSupplier.commissionable) &&
        Objects.equals(this.name, spaSupplier.name) &&
        Objects.equals(this.proximityCode, spaSupplier.proximityCode) &&
        Objects.equals(this.sort, spaSupplier.sort) &&
        Objects.equals(this.minAgeAppropriateCode, spaSupplier.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, spaSupplier.bookable) &&
        Objects.equals(this.active, spaSupplier.active) &&
        Objects.equals(this.disabilityFeatures, spaSupplier.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, spaSupplier.securityFeatures) &&
        Objects.equals(this.socials, spaSupplier.socials) &&
        Objects.equals(this.pricePoint, spaSupplier.pricePoint) &&
        Objects.equals(this.recognitionList, spaSupplier.recognitionList) &&
        Objects.equals(this.transactionalInventoryList, spaSupplier.transactionalInventoryList) &&
        Objects.equals(this.applicableStart, spaSupplier.applicableStart) &&
        Objects.equals(this.applicableEnd, spaSupplier.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, spaSupplier.reservationRequiredInd) &&
        Objects.equals(this.opens, spaSupplier.opens) &&
        Objects.equals(this.closes, spaSupplier.closes) &&
        Objects.equals(this.daysOfWeek, spaSupplier.daysOfWeek) &&
        Objects.equals(this.amenities, spaSupplier.amenities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, transactionalInventoryList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, amenities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpaSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    transactionalInventoryList: ").append(toIndentedString(transactionalInventoryList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

