package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CreateScheduleItemRequestSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import java.time.OffsetDateTime;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ScheduleItemViewSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateScheduleItemRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:44:41.039749947+07:00[Asia/Bangkok]")
public class SchedulerApi {
    private ApiClient apiClient;

    public SchedulerApi() {
        this(new ApiClient());
    }

    @Autowired
    public SchedulerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequestSupplier The createScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ScheduleItemViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = createScheduleItemRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createScheduleItemRequestSupplier' is set
        if (createScheduleItemRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'createScheduleItemRequestSupplier' when calling createScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequestSupplier The createScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ScheduleItemViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ScheduleItemViewSupplier> createScheduleItem(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequestSupplier The createScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ScheduleItemViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ScheduleItemViewSupplier>> createScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Scheduler Item
     * Create a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Create a calendar item for travel inventory with this identifier
     * @param createScheduleItemRequestSupplier The createScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createScheduleItemWithResponseSpec(String hotelIdentifier, String inventoryIdentifier, CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, createScheduleItemRequestSupplier, winkVersion);
    }
    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling removeScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Scheduler Item
     * Delete a calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Remove a calendar item for travel inventory with this identifier
     * @param identifier Remove a calendar item with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeScheduleItemWithResponseSpec(String hotelIdentifier, String inventoryIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        return removeScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, winkVersion);
    }
    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ScheduleItemViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showScheduleItemsRequestCreation(String hotelIdentifier, String inventoryIdentifier, java.time.LocalDateTime start, java.time.LocalDateTime end, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'start' is set
        if (start == null) {
            throw new WebClientResponseException("Missing the required parameter 'start' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'end' is set
        if (end == null) {
            throw new WebClientResponseException("Missing the required parameter 'end' when calling showScheduleItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "start", start));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "end", end));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ScheduleItemViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ScheduleItemViewSupplier> showScheduleItems(String hotelIdentifier, String inventoryIdentifier, java.time.LocalDateTime start, java.time.LocalDateTime end, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;ScheduleItemViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ScheduleItemViewSupplier>>> showScheduleItemsWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, java.time.LocalDateTime start, java.time.LocalDateTime end, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Scheduler Items
     * Retrieve list of calendar items for a meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show calendar items for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Show calendar items for travel inventory with this identifier
     * @param start Specify start date range
     * @param end Specify end date range
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showScheduleItemsWithResponseSpec(String hotelIdentifier, String inventoryIdentifier, java.time.LocalDateTime start, java.time.LocalDateTime end, String winkVersion) throws WebClientResponseException {
        return showScheduleItemsRequestCreation(hotelIdentifier, inventoryIdentifier, start, end, winkVersion);
    }
    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequestSupplier The updateScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ScheduleItemViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateScheduleItemRequestCreation(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updateScheduleItemRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateScheduleItemRequestSupplier' is set
        if (updateScheduleItemRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateScheduleItemRequestSupplier' when calling updateScheduleItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/schedule/{inventoryIdentifier}/item/{identifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequestSupplier The updateScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ScheduleItemViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ScheduleItemViewSupplier> updateScheduleItem(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequestSupplier The updateScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ScheduleItemViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ScheduleItemViewSupplier>> updateScheduleItemWithHttpInfo(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ScheduleItemViewSupplier> localVarReturnType = new ParameterizedTypeReference<ScheduleItemViewSupplier>() {};
        return updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Scheduler Item
     * Update an existing calendar item for any travel inventory such as meeting room, restaurant, spa, activity, attraction or place.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a calendar item for travel inventory owned by this hotel identifier
     * @param inventoryIdentifier Update a calendar item for travel inventory with this identifier
     * @param identifier Update a calendar item with this identifier
     * @param updateScheduleItemRequestSupplier The updateScheduleItemRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateScheduleItemWithResponseSpec(String hotelIdentifier, String inventoryIdentifier, String identifier, UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateScheduleItemRequestCreation(hotelIdentifier, inventoryIdentifier, identifier, updateScheduleItemRequestSupplier, winkVersion);
    }
}
