/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.42.12
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.ChannelNameSupplierDetails;
import travel.wink.sdk.extranet.model.GeoNameCountrySupplierDetails;
import travel.wink.sdk.extranet.model.GeoNameSupplierDetails;
import travel.wink.sdk.extranet.model.RoomConfigurationSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * VerifyRatesRequestSupplierDetails
 */
@JsonPropertyOrder({
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_CHANNEL,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_STAY_START_DATE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_STAY_END_DATE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_CURRENCY,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_BOOKING_DATE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_SELL_START_DATE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_SELL_END_DATE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_PROMOTION,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_CITY,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_COUNTRY,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_CONTINENT,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_IP_NUMBER,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_TIMEZONE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_LATITUDE,
  VerifyRatesRequestSupplierDetails.JSON_PROPERTY_LONGITUDE
})
@JsonTypeName("VerifyRatesRequest_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:44:41.039749947+07:00[Asia/Bangkok]")
public class VerifyRatesRequestSupplierDetails {
  public static final String JSON_PROPERTY_CHANNEL = "channel";
  private ChannelNameSupplierDetails channel;

  public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
  private LocalDate stayStartDate;

  public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
  private LocalDate stayEndDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfigurationSupplierDetails> roomConfigurations = new ArrayList<>();

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_BOOKING_DATE = "bookingDate";
  private LocalDate bookingDate;

  public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
  private LocalDate sellStartDate;

  public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
  private LocalDate sellEndDate;

  public static final String JSON_PROPERTY_PROMOTION = "promotion";
  private String promotion;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoNameSupplierDetails city;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private GeoNameCountrySupplierDetails country;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
  private String ipNumber;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_LATITUDE = "latitude";
  private java.math.BigDecimal latitude;

  public static final String JSON_PROPERTY_LONGITUDE = "longitude";
  private java.math.BigDecimal longitude;

  public VerifyRatesRequestSupplierDetails() {
  }

  public VerifyRatesRequestSupplierDetails channel(ChannelNameSupplierDetails channel) {
    
    this.channel = channel;
    return this;
  }

   /**
   * Get channel
   * @return channel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelNameSupplierDetails getChannel() {
    return channel;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannel(ChannelNameSupplierDetails channel) {
    this.channel = channel;
  }


  public VerifyRatesRequestSupplierDetails stayStartDate(LocalDate stayStartDate) {
    
    this.stayStartDate = stayStartDate;
    return this;
  }

   /**
   * Arrival date
   * @return stayStartDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStayStartDate() {
    return stayStartDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStayStartDate(LocalDate stayStartDate) {
    this.stayStartDate = stayStartDate;
  }


  public VerifyRatesRequestSupplierDetails stayEndDate(LocalDate stayEndDate) {
    
    this.stayEndDate = stayEndDate;
    return this;
  }

   /**
   * Departure date
   * @return stayEndDate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStayEndDate() {
    return stayEndDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStayEndDate(LocalDate stayEndDate) {
    this.stayEndDate = stayEndDate;
  }


  public VerifyRatesRequestSupplierDetails roomConfigurations(List<RoomConfigurationSupplierDetails> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public VerifyRatesRequestSupplierDetails addRoomConfigurationsItem(RoomConfigurationSupplierDetails roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Get roomConfigurations
   * @return roomConfigurations
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomConfigurationSupplierDetails> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomConfigurations(List<RoomConfigurationSupplierDetails> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public VerifyRatesRequestSupplierDetails currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Display currency
   * @return currency
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public VerifyRatesRequestSupplierDetails bookingDate(LocalDate bookingDate) {
    
    this.bookingDate = bookingDate;
    return this;
  }

   /**
   * The booking start date
   * @return bookingDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBookingDate() {
    return bookingDate;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingDate(LocalDate bookingDate) {
    this.bookingDate = bookingDate;
  }


  public VerifyRatesRequestSupplierDetails sellStartDate(LocalDate sellStartDate) {
    
    this.sellStartDate = sellStartDate;
    return this;
  }

   /**
   * The sell start date
   * @return sellStartDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellStartDate() {
    return sellStartDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellStartDate(LocalDate sellStartDate) {
    this.sellStartDate = sellStartDate;
  }


  public VerifyRatesRequestSupplierDetails sellEndDate(LocalDate sellEndDate) {
    
    this.sellEndDate = sellEndDate;
    return this;
  }

   /**
   * The sell end date
   * @return sellEndDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellEndDate() {
    return sellEndDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellEndDate(LocalDate sellEndDate) {
    this.sellEndDate = sellEndDate;
  }


  public VerifyRatesRequestSupplierDetails promotion(String promotion) {
    
    this.promotion = promotion;
    return this;
  }

   /**
   * A promo code
   * @return promotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPromotion() {
    return promotion;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotion(String promotion) {
    this.promotion = promotion;
  }


  public VerifyRatesRequestSupplierDetails city(GeoNameSupplierDetails city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameSupplierDetails getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoNameSupplierDetails city) {
    this.city = city;
  }


  public VerifyRatesRequestSupplierDetails country(GeoNameCountrySupplierDetails country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameCountrySupplierDetails getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(GeoNameCountrySupplierDetails country) {
    this.country = country;
  }


  public VerifyRatesRequestSupplierDetails continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * A booker coming from a specific continent
   * @return continent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public VerifyRatesRequestSupplierDetails ipNumber(String ipNumber) {
    
    this.ipNumber = ipNumber;
    return this;
  }

   /**
   * A booker coming from a specific IP number
   * @return ipNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpNumber() {
    return ipNumber;
  }


  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpNumber(String ipNumber) {
    this.ipNumber = ipNumber;
  }


  public VerifyRatesRequestSupplierDetails timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * A booker coming from a specific timezone
   * @return timezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public VerifyRatesRequestSupplierDetails latitude(java.math.BigDecimal latitude) {
    
    this.latitude = latitude;
    return this;
  }

   /**
   * A booker coming from a specific latitude
   * @return latitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getLatitude() {
    return latitude;
  }


  @JsonProperty(JSON_PROPERTY_LATITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLatitude(java.math.BigDecimal latitude) {
    this.latitude = latitude;
  }


  public VerifyRatesRequestSupplierDetails longitude(java.math.BigDecimal longitude) {
    
    this.longitude = longitude;
    return this;
  }

   /**
   * A booker coming from a specific longitude
   * @return longitude
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getLongitude() {
    return longitude;
  }


  @JsonProperty(JSON_PROPERTY_LONGITUDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongitude(java.math.BigDecimal longitude) {
    this.longitude = longitude;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerifyRatesRequestSupplierDetails verifyRatesRequestSupplierDetails = (VerifyRatesRequestSupplierDetails) o;
    return Objects.equals(this.channel, verifyRatesRequestSupplierDetails.channel) &&
        Objects.equals(this.stayStartDate, verifyRatesRequestSupplierDetails.stayStartDate) &&
        Objects.equals(this.stayEndDate, verifyRatesRequestSupplierDetails.stayEndDate) &&
        Objects.equals(this.roomConfigurations, verifyRatesRequestSupplierDetails.roomConfigurations) &&
        Objects.equals(this.currency, verifyRatesRequestSupplierDetails.currency) &&
        Objects.equals(this.bookingDate, verifyRatesRequestSupplierDetails.bookingDate) &&
        Objects.equals(this.sellStartDate, verifyRatesRequestSupplierDetails.sellStartDate) &&
        Objects.equals(this.sellEndDate, verifyRatesRequestSupplierDetails.sellEndDate) &&
        Objects.equals(this.promotion, verifyRatesRequestSupplierDetails.promotion) &&
        Objects.equals(this.city, verifyRatesRequestSupplierDetails.city) &&
        Objects.equals(this.country, verifyRatesRequestSupplierDetails.country) &&
        Objects.equals(this.continent, verifyRatesRequestSupplierDetails.continent) &&
        Objects.equals(this.ipNumber, verifyRatesRequestSupplierDetails.ipNumber) &&
        Objects.equals(this.timezone, verifyRatesRequestSupplierDetails.timezone) &&
        Objects.equals(this.latitude, verifyRatesRequestSupplierDetails.latitude) &&
        Objects.equals(this.longitude, verifyRatesRequestSupplierDetails.longitude);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channel, stayStartDate, stayEndDate, roomConfigurations, currency, bookingDate, sellStartDate, sellEndDate, promotion, city, country, continent, ipNumber, timezone, latitude, longitude);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerifyRatesRequestSupplierDetails {\n");
    sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
    sb.append("    stayStartDate: ").append(toIndentedString(stayStartDate)).append("\n");
    sb.append("    stayEndDate: ").append(toIndentedString(stayEndDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    bookingDate: ").append(toIndentedString(bookingDate)).append("\n");
    sb.append("    sellStartDate: ").append(toIndentedString(sellStartDate)).append("\n");
    sb.append("    sellEndDate: ").append(toIndentedString(sellEndDate)).append("\n");
    sb.append("    promotion: ").append(toIndentedString(promotion)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    ipNumber: ").append(toIndentedString(ipNumber)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

