package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CalDavResponseSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-15T11:55:15.242722091+07:00[Asia/Bangkok]")
public class CalDavApi {
    private ApiClient apiClient;

    public CalDavApi() {
        this(new ApiClient());
    }

    @Autowired
    public CalDavApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Connect CalDAV
     * Generates new CalDav passkey the property can use to authenticate the CalDAV url.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CalDavResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec generateCalDavAuthRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling generateCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/caldav/auth/regen", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Connect CalDAV
     * Generates new CalDav passkey the property can use to authenticate the CalDAV url.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CalDavResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CalDavResponseSupplier> generateCalDavAuth(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Connect CalDAV
     * Generates new CalDav passkey the property can use to authenticate the CalDAV url.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CalDavResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CalDavResponseSupplier>> generateCalDavAuthWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Connect CalDAV
     * Generates new CalDav passkey the property can use to authenticate the CalDAV url.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec generateCalDavAuthWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return generateCalDavAuthRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show CalDAV authentication
     * Retrieve CalDAV authentication of a hotel
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CalDavResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec retrieveCalDavAuthRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling retrieveCalDavAuth", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/caldav/auth", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show CalDAV authentication
     * Retrieve CalDAV authentication of a hotel
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CalDavResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CalDavResponseSupplier> retrieveCalDavAuth(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show CalDAV authentication
     * Retrieve CalDAV authentication of a hotel
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CalDavResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CalDavResponseSupplier>> retrieveCalDavAuthWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CalDavResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CalDavResponseSupplier>() {};
        return retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show CalDAV authentication
     * Retrieve CalDAV authentication of a hotel
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec retrieveCalDavAuthWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return retrieveCalDavAuthRequestCreation(hotelIdentifier, winkVersion);
    }
}
