package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.SalesChannelRelationshipRequestViewSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertSalesChannelRelationshipRequestRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-15T11:55:15.242722091+07:00[Asia/Bangkok]")
public class SalesChannelRelationshipRequestsApi {
    private ApiClient apiClient;

    public SalesChannelRelationshipRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelRelationshipRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create sales channel request
     * Create a new sales channel request.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel request and associate it with this hotel identifier
     * @param upsertSalesChannelRelationshipRequestRequestSupplier The upsertSalesChannelRelationshipRequestRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSalesChannelRequestRequestCreation(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSalesChannelRelationshipRequestRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSalesChannelRelationshipRequestRequestSupplier' is set
        if (upsertSalesChannelRelationshipRequestRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRelationshipRequestRequestSupplier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create sales channel request
     * Create a new sales channel request.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel request and associate it with this hotel identifier
     * @param upsertSalesChannelRelationshipRequestRequestSupplier The upsertSalesChannelRelationshipRequestRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelRelationshipRequestViewSupplier> createSalesChannelRequest(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create sales channel request
     * Create a new sales channel request.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel request and associate it with this hotel identifier
     * @param upsertSalesChannelRelationshipRequestRequestSupplier The upsertSalesChannelRelationshipRequestRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelRelationshipRequestViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelRelationshipRequestViewSupplier>> createSalesChannelRequestWithHttpInfo(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create sales channel request
     * Create a new sales channel request.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create sales channel request and associate it with this hotel identifier
     * @param upsertSalesChannelRelationshipRequestRequestSupplier The upsertSalesChannelRelationshipRequestRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSalesChannelRequestWithResponseSpec(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion);
    }
    /**
     * Reject sales channel request
     * Delete a sales channel request
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel request owned by this hotel identifier
     * @param salesChannelRequestIdentifier Remove sales channel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSalesChannelRequestRequestCreation(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelRequestIdentifier' is set
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Reject sales channel request
     * Delete a sales channel request
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel request owned by this hotel identifier
     * @param salesChannelRequestIdentifier Remove sales channel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return SalesChannelRelationshipRequestViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SalesChannelRelationshipRequestViewSupplier> removeSalesChannelRequest(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Reject sales channel request
     * Delete a sales channel request
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel request owned by this hotel identifier
     * @param salesChannelRequestIdentifier Remove sales channel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SalesChannelRelationshipRequestViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SalesChannelRelationshipRequestViewSupplier>> removeSalesChannelRequestWithHttpInfo(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Reject sales channel request
     * Delete a sales channel request
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove sales channel request owned by this hotel identifier
     * @param salesChannelRequestIdentifier Remove sales channel request with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSalesChannelRequestWithResponseSpec(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion);
    }
    /**
     * Show sales channel requests
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel requests for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelRelationshipRequestViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSalesChannelRequestsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show sales channel requests
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel requests for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SalesChannelRelationshipRequestViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SalesChannelRelationshipRequestViewSupplier> showSalesChannelRequests(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show sales channel requests
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel requests for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SalesChannelRelationshipRequestViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SalesChannelRelationshipRequestViewSupplier>>> showSalesChannelRequestsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>() {};
        return showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show sales channel requests
     * Retrieve list of all sales channels for this property. You can decide to retrieve all specific sales channel relationships or only generic ones using the &#39;owner&#39; request parameter.
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>503</b> - Service Unavailable
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all sales channel requests for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSalesChannelRequestsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion);
    }
}
