/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.53.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.AdvanceBookingRateQualifierSupplier;
import travel.wink.sdk.extranet.model.ArrivalDaysOfWeekRateQualifierSupplier;
import travel.wink.sdk.extranet.model.AvailableDaysOfWeekRateQualifierSupplier;
import travel.wink.sdk.extranet.model.BlackoutDateSupplier;
import travel.wink.sdk.extranet.model.CityRateQualifierSupplier;
import travel.wink.sdk.extranet.model.ContinentRateQualifierSupplier;
import travel.wink.sdk.extranet.model.CountryRateQualifierSupplier;
import travel.wink.sdk.extranet.model.DepartureDaysOfWeekRateQualifierSupplier;
import travel.wink.sdk.extranet.model.IPRangeRateQualifierSupplier;
import travel.wink.sdk.extranet.model.LengthOfStayRateQualifierSupplier;
import travel.wink.sdk.extranet.model.LocalizedDescriptionSupplier;
import travel.wink.sdk.extranet.model.MinutesBeforeBookingStartDateRateQualifierSupplier;
import travel.wink.sdk.extranet.model.PrepayRateQualifierSupplier;
import travel.wink.sdk.extranet.model.PromotionRateQualifierSupplier;
import travel.wink.sdk.extranet.model.RefundableRateQualifierSupplier;
import travel.wink.sdk.extranet.model.RequiredDaysOfWeekRateQualifierSupplier;
import travel.wink.sdk.extranet.model.RoomRangeRateQualifierSupplier;
import travel.wink.sdk.extranet.model.SellDateRateQualifierSupplier;
import travel.wink.sdk.extranet.model.StayDateRateQualifierSupplier;
import travel.wink.sdk.extranet.model.TimezoneRateQualifierSupplier;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertRateModifierRequestSupplier
 */
@JsonPropertyOrder({
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_NAME,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_TYPE,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_MODIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_ENABLED,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_PRICING_TYPE,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_DESCRIPTIONS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  UpsertRateModifierRequestSupplier.JSON_PROPERTY_BLACKOUT_DATES
})
@JsonTypeName("UpsertRateModifierRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-15T11:55:15.242722091+07:00[Asia/Bangkok]")
public class UpsertRateModifierRequestSupplier {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  private VariableChargeSupplier modifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<LocalizedDescriptionSupplier> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  private List<CityRateQualifierSupplier> cityRateQualifiers;

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  private List<ContinentRateQualifierSupplier> continentRateQualifiers;

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  private List<CountryRateQualifierSupplier> countryRateQualifiers;

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  private List<PromotionRateQualifierSupplier> promotionRateQualifiers;

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  private List<IPRangeRateQualifierSupplier> ipRangeRateQualifiers;

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  private RoomRangeRateQualifierSupplier roomRangeRateQualifier;

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  private PrepayRateQualifierSupplier prepayRateQualifier;

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  private RefundableRateQualifierSupplier refundableRateQualifier;

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  private List<TimezoneRateQualifierSupplier> timezoneRateQualifiers;

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  private MinutesBeforeBookingStartDateRateQualifierSupplier lastMinuteRateQualifier;

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  private LengthOfStayRateQualifierSupplier lengthOfStayRateQualifier;

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  private AdvanceBookingRateQualifierSupplier advanceBookingRateQualifier;

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  private List<StayDateRateQualifierSupplier> stayDateRateQualifiers;

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  private List<SellDateRateQualifierSupplier> sellDateRateQualifiers;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  private AvailableDaysOfWeekRateQualifierSupplier availableDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  private ArrivalDaysOfWeekRateQualifierSupplier arrivalDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  private DepartureDaysOfWeekRateQualifierSupplier departureDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  private RequiredDaysOfWeekRateQualifierSupplier requiredDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  private List<String> masterRateIdentifiers;

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  private List<String> addOnIdentifiers;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  private List<String> ratePlanIdentifiers;

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  private List<BlackoutDateSupplier> blackoutDates;

  public UpsertRateModifierRequestSupplier() {
  }

  public UpsertRateModifierRequestSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertRateModifierRequestSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertRateModifierRequestSupplier modifier(VariableChargeSupplier modifier) {
    
    this.modifier = modifier;
    return this;
  }

   /**
   * Get modifier
   * @return modifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public VariableChargeSupplier getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(VariableChargeSupplier modifier) {
    this.modifier = modifier;
  }


  public UpsertRateModifierRequestSupplier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion is enabled or not.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public UpsertRateModifierRequestSupplier pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public UpsertRateModifierRequestSupplier descriptions(List<LocalizedDescriptionSupplier> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertRateModifierRequestSupplier addDescriptionsItem(LocalizedDescriptionSupplier descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<LocalizedDescriptionSupplier> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<LocalizedDescriptionSupplier> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertRateModifierRequestSupplier cityRateQualifiers(List<CityRateQualifierSupplier> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addCityRateQualifiersItem(CityRateQualifierSupplier cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)
   * @return cityRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CityRateQualifierSupplier> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(List<CityRateQualifierSupplier> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier continentRateQualifiers(List<ContinentRateQualifierSupplier> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addContinentRateQualifiersItem(ContinentRateQualifierSupplier continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)
   * @return continentRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContinentRateQualifierSupplier> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(List<ContinentRateQualifierSupplier> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier countryRateQualifiers(List<CountryRateQualifierSupplier> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addCountryRateQualifiersItem(CountryRateQualifierSupplier countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)
   * @return countryRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CountryRateQualifierSupplier> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(List<CountryRateQualifierSupplier> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier promotionRateQualifiers(List<PromotionRateQualifierSupplier> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addPromotionRateQualifiersItem(PromotionRateQualifierSupplier promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PromotionRateQualifierSupplier> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(List<PromotionRateQualifierSupplier> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier ipRangeRateQualifiers(List<IPRangeRateQualifierSupplier> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addIpRangeRateQualifiersItem(IPRangeRateQualifierSupplier ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IPRangeRateQualifierSupplier> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(List<IPRangeRateQualifierSupplier> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier roomRangeRateQualifier(RoomRangeRateQualifierSupplier roomRangeRateQualifier) {
    
    this.roomRangeRateQualifier = roomRangeRateQualifier;
    return this;
  }

   /**
   * Get roomRangeRateQualifier
   * @return roomRangeRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomRangeRateQualifierSupplier getRoomRangeRateQualifier() {
    return roomRangeRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRangeRateQualifier(RoomRangeRateQualifierSupplier roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }


  public UpsertRateModifierRequestSupplier prepayRateQualifier(PrepayRateQualifierSupplier prepayRateQualifier) {
    
    this.prepayRateQualifier = prepayRateQualifier;
    return this;
  }

   /**
   * Get prepayRateQualifier
   * @return prepayRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PrepayRateQualifierSupplier getPrepayRateQualifier() {
    return prepayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepayRateQualifier(PrepayRateQualifierSupplier prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }


  public UpsertRateModifierRequestSupplier refundableRateQualifier(RefundableRateQualifierSupplier refundableRateQualifier) {
    
    this.refundableRateQualifier = refundableRateQualifier;
    return this;
  }

   /**
   * Get refundableRateQualifier
   * @return refundableRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableRateQualifierSupplier getRefundableRateQualifier() {
    return refundableRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableRateQualifier(RefundableRateQualifierSupplier refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }


  public UpsertRateModifierRequestSupplier timezoneRateQualifiers(List<TimezoneRateQualifierSupplier> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addTimezoneRateQualifiersItem(TimezoneRateQualifierSupplier timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)
   * @return timezoneRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TimezoneRateQualifierSupplier> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(List<TimezoneRateQualifierSupplier> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier lastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierSupplier lastMinuteRateQualifier) {
    
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
    return this;
  }

   /**
   * Get lastMinuteRateQualifier
   * @return lastMinuteRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MinutesBeforeBookingStartDateRateQualifierSupplier getLastMinuteRateQualifier() {
    return lastMinuteRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastMinuteRateQualifier(MinutesBeforeBookingStartDateRateQualifierSupplier lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }


  public UpsertRateModifierRequestSupplier lengthOfStayRateQualifier(LengthOfStayRateQualifierSupplier lengthOfStayRateQualifier) {
    
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
    return this;
  }

   /**
   * Get lengthOfStayRateQualifier
   * @return lengthOfStayRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LengthOfStayRateQualifierSupplier getLengthOfStayRateQualifier() {
    return lengthOfStayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLengthOfStayRateQualifier(LengthOfStayRateQualifierSupplier lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }


  public UpsertRateModifierRequestSupplier advanceBookingRateQualifier(AdvanceBookingRateQualifierSupplier advanceBookingRateQualifier) {
    
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
    return this;
  }

   /**
   * Get advanceBookingRateQualifier
   * @return advanceBookingRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceBookingRateQualifierSupplier getAdvanceBookingRateQualifier() {
    return advanceBookingRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceBookingRateQualifier(AdvanceBookingRateQualifierSupplier advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }


  public UpsertRateModifierRequestSupplier stayDateRateQualifiers(List<StayDateRateQualifierSupplier> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addStayDateRateQualifiersItem(StayDateRateQualifierSupplier stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<StayDateRateQualifierSupplier> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(List<StayDateRateQualifierSupplier> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier sellDateRateQualifiers(List<SellDateRateQualifierSupplier> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addSellDateRateQualifiersItem(SellDateRateQualifierSupplier sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SellDateRateQualifierSupplier> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(List<SellDateRateQualifierSupplier> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }


  public UpsertRateModifierRequestSupplier availableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierSupplier availableDaysOfWeekRateQualifier) {
    
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get availableDaysOfWeekRateQualifier
   * @return availableDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AvailableDaysOfWeekRateQualifierSupplier getAvailableDaysOfWeekRateQualifier() {
    return availableDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeekRateQualifier(AvailableDaysOfWeekRateQualifierSupplier availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }


  public UpsertRateModifierRequestSupplier arrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierSupplier arrivalDaysOfWeekRateQualifier) {
    
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get arrivalDaysOfWeekRateQualifier
   * @return arrivalDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ArrivalDaysOfWeekRateQualifierSupplier getArrivalDaysOfWeekRateQualifier() {
    return arrivalDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeekRateQualifier(ArrivalDaysOfWeekRateQualifierSupplier arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }


  public UpsertRateModifierRequestSupplier departureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierSupplier departureDaysOfWeekRateQualifier) {
    
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get departureDaysOfWeekRateQualifier
   * @return departureDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DepartureDaysOfWeekRateQualifierSupplier getDepartureDaysOfWeekRateQualifier() {
    return departureDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeekRateQualifier(DepartureDaysOfWeekRateQualifierSupplier departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }


  public UpsertRateModifierRequestSupplier requiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierSupplier requiredDaysOfWeekRateQualifier) {
    
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Get requiredDaysOfWeekRateQualifier
   * @return requiredDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RequiredDaysOfWeekRateQualifierSupplier getRequiredDaysOfWeekRateQualifier() {
    return requiredDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeekRateQualifier(RequiredDaysOfWeekRateQualifierSupplier requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }


  public UpsertRateModifierRequestSupplier masterRateIdentifiers(List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }


  public UpsertRateModifierRequestSupplier addOnIdentifiers(List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }


  public UpsertRateModifierRequestSupplier ratePlanIdentifiers(List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public UpsertRateModifierRequestSupplier addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }


  public UpsertRateModifierRequestSupplier blackoutDates(List<BlackoutDateSupplier> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public UpsertRateModifierRequestSupplier addBlackoutDatesItem(BlackoutDateSupplier blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

   /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BlackoutDateSupplier> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(List<BlackoutDateSupplier> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertRateModifierRequestSupplier upsertRateModifierRequestSupplier = (UpsertRateModifierRequestSupplier) o;
    return Objects.equals(this.name, upsertRateModifierRequestSupplier.name) &&
        Objects.equals(this.type, upsertRateModifierRequestSupplier.type) &&
        Objects.equals(this.modifier, upsertRateModifierRequestSupplier.modifier) &&
        Objects.equals(this.enabled, upsertRateModifierRequestSupplier.enabled) &&
        Objects.equals(this.pricingType, upsertRateModifierRequestSupplier.pricingType) &&
        Objects.equals(this.descriptions, upsertRateModifierRequestSupplier.descriptions) &&
        Objects.equals(this.cityRateQualifiers, upsertRateModifierRequestSupplier.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, upsertRateModifierRequestSupplier.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, upsertRateModifierRequestSupplier.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, upsertRateModifierRequestSupplier.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, upsertRateModifierRequestSupplier.ipRangeRateQualifiers) &&
        Objects.equals(this.roomRangeRateQualifier, upsertRateModifierRequestSupplier.roomRangeRateQualifier) &&
        Objects.equals(this.prepayRateQualifier, upsertRateModifierRequestSupplier.prepayRateQualifier) &&
        Objects.equals(this.refundableRateQualifier, upsertRateModifierRequestSupplier.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, upsertRateModifierRequestSupplier.timezoneRateQualifiers) &&
        Objects.equals(this.lastMinuteRateQualifier, upsertRateModifierRequestSupplier.lastMinuteRateQualifier) &&
        Objects.equals(this.lengthOfStayRateQualifier, upsertRateModifierRequestSupplier.lengthOfStayRateQualifier) &&
        Objects.equals(this.advanceBookingRateQualifier, upsertRateModifierRequestSupplier.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, upsertRateModifierRequestSupplier.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, upsertRateModifierRequestSupplier.sellDateRateQualifiers) &&
        Objects.equals(this.availableDaysOfWeekRateQualifier, upsertRateModifierRequestSupplier.availableDaysOfWeekRateQualifier) &&
        Objects.equals(this.arrivalDaysOfWeekRateQualifier, upsertRateModifierRequestSupplier.arrivalDaysOfWeekRateQualifier) &&
        Objects.equals(this.departureDaysOfWeekRateQualifier, upsertRateModifierRequestSupplier.departureDaysOfWeekRateQualifier) &&
        Objects.equals(this.requiredDaysOfWeekRateQualifier, upsertRateModifierRequestSupplier.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, upsertRateModifierRequestSupplier.masterRateIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, upsertRateModifierRequestSupplier.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, upsertRateModifierRequestSupplier.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, upsertRateModifierRequestSupplier.blackoutDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, roomRangeRateQualifier, prepayRateQualifier, refundableRateQualifier, timezoneRateQualifiers, lastMinuteRateQualifier, lengthOfStayRateQualifier, advanceBookingRateQualifier, stayDateRateQualifiers, sellDateRateQualifiers, availableDaysOfWeekRateQualifier, arrivalDaysOfWeekRateQualifier, departureDaysOfWeekRateQualifier, requiredDaysOfWeekRateQualifier, masterRateIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertRateModifierRequestSupplier {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

