/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.53.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.DowPatternGroupSupplier;
import travel.wink.sdk.extranet.model.RatePlanLevelFeeSupplier;
import travel.wink.sdk.extranet.model.UpsertCancellationPolicyExceptionsSupplier;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertRatePlanRequestSupplier
 */
@JsonPropertyOrder({
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_NAME,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_PREPAID,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_ENABLED,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_BREAKFAST,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_BRUNCH,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_LUNCH,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_DINNER,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_ALL_INCLUSIVE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_SELL_START_DATE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_SELL_END_DATE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_STAY_START_DATE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_STAY_END_DATE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_LOYALTY_POINTS_ACCRUE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MIN_TOTAL_OCCUPANCY,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MAX_TOTAL_OCCUPANCY,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MIN_L_O_S,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MAX_L_O_S,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MIN_AGE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_MAX_AGE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_RATE_PLAN_LEVEL_FEES,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  UpsertRatePlanRequestSupplier.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER
})
@JsonTypeName("UpsertRatePlanRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-15T11:55:15.242722091+07:00[Asia/Bangkok]")
public class UpsertRatePlanRequestSupplier {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PREPAID = "prepaid";
  private Boolean prepaid = false;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = false;

  public static final String JSON_PROPERTY_BREAKFAST = "breakfast";
  private Boolean breakfast = false;

  public static final String JSON_PROPERTY_BRUNCH = "brunch";
  private Boolean brunch = false;

  public static final String JSON_PROPERTY_LUNCH = "lunch";
  private Boolean lunch = false;

  public static final String JSON_PROPERTY_DINNER = "dinner";
  private Boolean dinner = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE = "allInclusive";
  private Boolean allInclusive = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL = "allInclusivePlusAlcohol";
  private Boolean allInclusivePlusAlcohol = false;

  public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
  private LocalDate sellStartDate;

  public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
  private LocalDate sellEndDate;

  public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
  private LocalDate stayStartDate;

  public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
  private LocalDate stayEndDate;

  public static final String JSON_PROPERTY_LOYALTY_POINTS_ACCRUE = "loyaltyPointsAccrue";
  private Boolean loyaltyPointsAccrue = false;

  public static final String JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET = "maxAdvanceBookingOffset";
  private Integer maxAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET = "minAdvanceBookingOffset";
  private Integer minAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_TOTAL_OCCUPANCY = "minTotalOccupancy";
  private Integer minTotalOccupancy;

  public static final String JSON_PROPERTY_MAX_TOTAL_OCCUPANCY = "maxTotalOccupancy";
  private Integer maxTotalOccupancy;

  public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
  private Integer minLOS;

  public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
  private Integer maxLOS;

  public static final String JSON_PROPERTY_MIN_AGE = "minAge";
  private Integer minAge;

  public static final String JSON_PROPERTY_MAX_AGE = "maxAge";
  private Integer maxAge;

  public static final String JSON_PROPERTY_RATE_PLAN_LEVEL_FEES = "ratePlanLevelFees";
  private List<RatePlanLevelFeeSupplier> ratePlanLevelFees;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK = "availableDaysOfWeek";
  private DowPatternGroupSupplier availableDaysOfWeek;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK = "arrivalDaysOfWeek";
  private DowPatternGroupSupplier arrivalDaysOfWeek;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK = "departureDaysOfWeek";
  private DowPatternGroupSupplier departureDaysOfWeek;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK = "requiredDaysOfWeek";
  private DowPatternGroupSupplier requiredDaysOfWeek;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private VariableChargeSupplier earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private VariableChargeSupplier lateCheckOutCharge;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
  private String cancellationPolicyIdentifier;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS = "cancellationPolicyExceptions";
  private UpsertCancellationPolicyExceptionsSupplier cancellationPolicyExceptions;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  private VariableChargeSupplier singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  private VariableChargeSupplier extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  private VariableChargeSupplier extraChildRateModifier;

  public UpsertRatePlanRequestSupplier() {
  }

  public UpsertRatePlanRequestSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Provides the name of the rate plan.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertRatePlanRequestSupplier prepaid(Boolean prepaid) {
    
    this.prepaid = prepaid;
    return this;
  }

   /**
   * When true, indicates if the rate is a prepaid rate.
   * @return prepaid
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPrepaid() {
    return prepaid;
  }


  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrepaid(Boolean prepaid) {
    this.prepaid = prepaid;
  }


  public UpsertRatePlanRequestSupplier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether rate plan is active or not.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public UpsertRatePlanRequestSupplier breakfast(Boolean breakfast) {
    
    this.breakfast = breakfast;
    return this;
  }

   /**
   * When true, indicates breakfast is included.
   * @return breakfast
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBreakfast() {
    return breakfast;
  }


  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBreakfast(Boolean breakfast) {
    this.breakfast = breakfast;
  }


  public UpsertRatePlanRequestSupplier brunch(Boolean brunch) {
    
    this.brunch = brunch;
    return this;
  }

   /**
   * When true, indicates brunch is included.
   * @return brunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBrunch() {
    return brunch;
  }


  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrunch(Boolean brunch) {
    this.brunch = brunch;
  }


  public UpsertRatePlanRequestSupplier lunch(Boolean lunch) {
    
    this.lunch = lunch;
    return this;
  }

   /**
   * When true, indicates lunch is included.
   * @return lunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLunch() {
    return lunch;
  }


  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLunch(Boolean lunch) {
    this.lunch = lunch;
  }


  public UpsertRatePlanRequestSupplier dinner(Boolean dinner) {
    
    this.dinner = dinner;
    return this;
  }

   /**
   * When true, indicates dinner is included.
   * @return dinner
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDinner() {
    return dinner;
  }


  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDinner(Boolean dinner) {
    this.dinner = dinner;
  }


  public UpsertRatePlanRequestSupplier allInclusive(Boolean allInclusive) {
    
    this.allInclusive = allInclusive;
    return this;
  }

   /**
   * Everything included except alcohol
   * @return allInclusive
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusive() {
    return allInclusive;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusive(Boolean allInclusive) {
    this.allInclusive = allInclusive;
  }


  public UpsertRatePlanRequestSupplier allInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
    return this;
  }

   /**
   * Everything included with alcohol
   * @return allInclusivePlusAlcohol
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusivePlusAlcohol() {
    return allInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
  }


  public UpsertRatePlanRequestSupplier sellStartDate(LocalDate sellStartDate) {
    
    this.sellStartDate = sellStartDate;
    return this;
  }

   /**
   * Set a start date for when to start selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellStartDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellStartDate() {
    return sellStartDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellStartDate(LocalDate sellStartDate) {
    this.sellStartDate = sellStartDate;
  }


  public UpsertRatePlanRequestSupplier sellEndDate(LocalDate sellEndDate) {
    
    this.sellEndDate = sellEndDate;
    return this;
  }

   /**
   * Set an end date for when to finish selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellEndDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellEndDate() {
    return sellEndDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellEndDate(LocalDate sellEndDate) {
    this.sellEndDate = sellEndDate;
  }


  public UpsertRatePlanRequestSupplier stayStartDate(LocalDate stayStartDate) {
    
    this.stayStartDate = stayStartDate;
    return this;
  }

   /**
   * Set a start date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayStartDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayStartDate() {
    return stayStartDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayStartDate(LocalDate stayStartDate) {
    this.stayStartDate = stayStartDate;
  }


  public UpsertRatePlanRequestSupplier stayEndDate(LocalDate stayEndDate) {
    
    this.stayEndDate = stayEndDate;
    return this;
  }

   /**
   * Set an end date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayEndDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayEndDate() {
    return stayEndDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayEndDate(LocalDate stayEndDate) {
    this.stayEndDate = stayEndDate;
  }


  public UpsertRatePlanRequestSupplier loyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
    return this;
  }

   /**
   * Property honors loyalty points with this rate plan.
   * @return loyaltyPointsAccrue
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLoyaltyPointsAccrue() {
    return loyaltyPointsAccrue;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLoyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
  }


  public UpsertRatePlanRequestSupplier maxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
    return this;
  }

   /**
   * Maximum days before the arrival date for which this rate plan may be booked.
   * @return maxAdvanceBookingOffset
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAdvanceBookingOffset() {
    return maxAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
  }


  public UpsertRatePlanRequestSupplier minAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
    return this;
  }

   /**
   * Minimum days before the arrival date for which this rate plan may be booked.
   * @return minAdvanceBookingOffset
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAdvanceBookingOffset() {
    return minAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
  }


  public UpsertRatePlanRequestSupplier minTotalOccupancy(Integer minTotalOccupancy) {
    
    this.minTotalOccupancy = minTotalOccupancy;
    return this;
  }

   /**
   * Defines the minimum number of total occupants required for this rate plan.
   * @return minTotalOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinTotalOccupancy() {
    return minTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinTotalOccupancy(Integer minTotalOccupancy) {
    this.minTotalOccupancy = minTotalOccupancy;
  }


  public UpsertRatePlanRequestSupplier maxTotalOccupancy(Integer maxTotalOccupancy) {
    
    this.maxTotalOccupancy = maxTotalOccupancy;
    return this;
  }

   /**
   * Defines the maximum number of total occupants required for this rate plan.
   * @return maxTotalOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxTotalOccupancy() {
    return maxTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxTotalOccupancy(Integer maxTotalOccupancy) {
    this.maxTotalOccupancy = maxTotalOccupancy;
  }


  public UpsertRatePlanRequestSupplier minLOS(Integer minLOS) {
    
    this.minLOS = minLOS;
    return this;
  }

   /**
   * Indicates the minimum length of stay required for this rate plan.
   * @return minLOS
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLOS() {
    return minLOS;
  }


  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLOS(Integer minLOS) {
    this.minLOS = minLOS;
  }


  public UpsertRatePlanRequestSupplier maxLOS(Integer maxLOS) {
    
    this.maxLOS = maxLOS;
    return this;
  }

   /**
   * Indicates the maximum length of stay.
   * @return maxLOS
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLOS() {
    return maxLOS;
  }


  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLOS(Integer maxLOS) {
    this.maxLOS = maxLOS;
  }


  public UpsertRatePlanRequestSupplier minAge(Integer minAge) {
    
    this.minAge = minAge;
    return this;
  }

   /**
   * The minimum age to qualify for this rate plan.
   * @return minAge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAge() {
    return minAge;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAge(Integer minAge) {
    this.minAge = minAge;
  }


  public UpsertRatePlanRequestSupplier maxAge(Integer maxAge) {
    
    this.maxAge = maxAge;
    return this;
  }

   /**
   * The maximum age to qualify for this rate plan.
   * @return maxAge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAge() {
    return maxAge;
  }


  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAge(Integer maxAge) {
    this.maxAge = maxAge;
  }


  public UpsertRatePlanRequestSupplier ratePlanLevelFees(List<RatePlanLevelFeeSupplier> ratePlanLevelFees) {
    
    this.ratePlanLevelFees = ratePlanLevelFees;
    return this;
  }

  public UpsertRatePlanRequestSupplier addRatePlanLevelFeesItem(RatePlanLevelFeeSupplier ratePlanLevelFeesItem) {
    if (this.ratePlanLevelFees == null) {
      this.ratePlanLevelFees = new ArrayList<>();
    }
    this.ratePlanLevelFees.add(ratePlanLevelFeesItem);
    return this;
  }

   /**
   * This can be a one-time fee such as a cleaning fee
   * @return ratePlanLevelFees
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RatePlanLevelFeeSupplier> getRatePlanLevelFees() {
    return ratePlanLevelFees;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_LEVEL_FEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanLevelFees(List<RatePlanLevelFeeSupplier> ratePlanLevelFees) {
    this.ratePlanLevelFees = ratePlanLevelFees;
  }


  public UpsertRatePlanRequestSupplier availableDaysOfWeek(DowPatternGroupSupplier availableDaysOfWeek) {
    
    this.availableDaysOfWeek = availableDaysOfWeek;
    return this;
  }

   /**
   * Get availableDaysOfWeek
   * @return availableDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getAvailableDaysOfWeek() {
    return availableDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeek(DowPatternGroupSupplier availableDaysOfWeek) {
    this.availableDaysOfWeek = availableDaysOfWeek;
  }


  public UpsertRatePlanRequestSupplier arrivalDaysOfWeek(DowPatternGroupSupplier arrivalDaysOfWeek) {
    
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
    return this;
  }

   /**
   * Get arrivalDaysOfWeek
   * @return arrivalDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getArrivalDaysOfWeek() {
    return arrivalDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeek(DowPatternGroupSupplier arrivalDaysOfWeek) {
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
  }


  public UpsertRatePlanRequestSupplier departureDaysOfWeek(DowPatternGroupSupplier departureDaysOfWeek) {
    
    this.departureDaysOfWeek = departureDaysOfWeek;
    return this;
  }

   /**
   * Get departureDaysOfWeek
   * @return departureDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getDepartureDaysOfWeek() {
    return departureDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeek(DowPatternGroupSupplier departureDaysOfWeek) {
    this.departureDaysOfWeek = departureDaysOfWeek;
  }


  public UpsertRatePlanRequestSupplier requiredDaysOfWeek(DowPatternGroupSupplier requiredDaysOfWeek) {
    
    this.requiredDaysOfWeek = requiredDaysOfWeek;
    return this;
  }

   /**
   * Get requiredDaysOfWeek
   * @return requiredDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupSupplier getRequiredDaysOfWeek() {
    return requiredDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeek(DowPatternGroupSupplier requiredDaysOfWeek) {
    this.requiredDaysOfWeek = requiredDaysOfWeek;
  }


  public UpsertRatePlanRequestSupplier earlyCheckInCharge(VariableChargeSupplier earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(VariableChargeSupplier earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public UpsertRatePlanRequestSupplier lateCheckOutCharge(VariableChargeSupplier lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(VariableChargeSupplier lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public UpsertRatePlanRequestSupplier cancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    return this;
  }

   /**
   * The cancellation policy for this rate plan.
   * @return cancellationPolicyIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCancellationPolicyIdentifier() {
    return cancellationPolicyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
  }


  public UpsertRatePlanRequestSupplier cancellationPolicyExceptions(UpsertCancellationPolicyExceptionsSupplier cancellationPolicyExceptions) {
    
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
    return this;
  }

   /**
   * Get cancellationPolicyExceptions
   * @return cancellationPolicyExceptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UpsertCancellationPolicyExceptionsSupplier getCancellationPolicyExceptions() {
    return cancellationPolicyExceptions;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyExceptions(UpsertCancellationPolicyExceptionsSupplier cancellationPolicyExceptions) {
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
  }


  public UpsertRatePlanRequestSupplier singleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

   /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSingleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }


  public UpsertRatePlanRequestSupplier extraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

   /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }


  public UpsertRatePlanRequestSupplier extraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

   /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertRatePlanRequestSupplier upsertRatePlanRequestSupplier = (UpsertRatePlanRequestSupplier) o;
    return Objects.equals(this.name, upsertRatePlanRequestSupplier.name) &&
        Objects.equals(this.prepaid, upsertRatePlanRequestSupplier.prepaid) &&
        Objects.equals(this.enabled, upsertRatePlanRequestSupplier.enabled) &&
        Objects.equals(this.breakfast, upsertRatePlanRequestSupplier.breakfast) &&
        Objects.equals(this.brunch, upsertRatePlanRequestSupplier.brunch) &&
        Objects.equals(this.lunch, upsertRatePlanRequestSupplier.lunch) &&
        Objects.equals(this.dinner, upsertRatePlanRequestSupplier.dinner) &&
        Objects.equals(this.allInclusive, upsertRatePlanRequestSupplier.allInclusive) &&
        Objects.equals(this.allInclusivePlusAlcohol, upsertRatePlanRequestSupplier.allInclusivePlusAlcohol) &&
        Objects.equals(this.sellStartDate, upsertRatePlanRequestSupplier.sellStartDate) &&
        Objects.equals(this.sellEndDate, upsertRatePlanRequestSupplier.sellEndDate) &&
        Objects.equals(this.stayStartDate, upsertRatePlanRequestSupplier.stayStartDate) &&
        Objects.equals(this.stayEndDate, upsertRatePlanRequestSupplier.stayEndDate) &&
        Objects.equals(this.loyaltyPointsAccrue, upsertRatePlanRequestSupplier.loyaltyPointsAccrue) &&
        Objects.equals(this.maxAdvanceBookingOffset, upsertRatePlanRequestSupplier.maxAdvanceBookingOffset) &&
        Objects.equals(this.minAdvanceBookingOffset, upsertRatePlanRequestSupplier.minAdvanceBookingOffset) &&
        Objects.equals(this.minTotalOccupancy, upsertRatePlanRequestSupplier.minTotalOccupancy) &&
        Objects.equals(this.maxTotalOccupancy, upsertRatePlanRequestSupplier.maxTotalOccupancy) &&
        Objects.equals(this.minLOS, upsertRatePlanRequestSupplier.minLOS) &&
        Objects.equals(this.maxLOS, upsertRatePlanRequestSupplier.maxLOS) &&
        Objects.equals(this.minAge, upsertRatePlanRequestSupplier.minAge) &&
        Objects.equals(this.maxAge, upsertRatePlanRequestSupplier.maxAge) &&
        Objects.equals(this.ratePlanLevelFees, upsertRatePlanRequestSupplier.ratePlanLevelFees) &&
        Objects.equals(this.availableDaysOfWeek, upsertRatePlanRequestSupplier.availableDaysOfWeek) &&
        Objects.equals(this.arrivalDaysOfWeek, upsertRatePlanRequestSupplier.arrivalDaysOfWeek) &&
        Objects.equals(this.departureDaysOfWeek, upsertRatePlanRequestSupplier.departureDaysOfWeek) &&
        Objects.equals(this.requiredDaysOfWeek, upsertRatePlanRequestSupplier.requiredDaysOfWeek) &&
        Objects.equals(this.earlyCheckInCharge, upsertRatePlanRequestSupplier.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, upsertRatePlanRequestSupplier.lateCheckOutCharge) &&
        Objects.equals(this.cancellationPolicyIdentifier, upsertRatePlanRequestSupplier.cancellationPolicyIdentifier) &&
        Objects.equals(this.cancellationPolicyExceptions, upsertRatePlanRequestSupplier.cancellationPolicyExceptions) &&
        Objects.equals(this.singleOccupancyRateModifier, upsertRatePlanRequestSupplier.singleOccupancyRateModifier) &&
        Objects.equals(this.extraPaxRateModifier, upsertRatePlanRequestSupplier.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, upsertRatePlanRequestSupplier.extraChildRateModifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, prepaid, enabled, breakfast, brunch, lunch, dinner, allInclusive, allInclusivePlusAlcohol, sellStartDate, sellEndDate, stayStartDate, stayEndDate, loyaltyPointsAccrue, maxAdvanceBookingOffset, minAdvanceBookingOffset, minTotalOccupancy, maxTotalOccupancy, minLOS, maxLOS, minAge, maxAge, ratePlanLevelFees, availableDaysOfWeek, arrivalDaysOfWeek, departureDaysOfWeek, requiredDaysOfWeek, earlyCheckInCharge, lateCheckOutCharge, cancellationPolicyIdentifier, cancellationPolicyExceptions, singleOccupancyRateModifier, extraPaxRateModifier, extraChildRateModifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertRatePlanRequestSupplier {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prepaid: ").append(toIndentedString(prepaid)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    breakfast: ").append(toIndentedString(breakfast)).append("\n");
    sb.append("    brunch: ").append(toIndentedString(brunch)).append("\n");
    sb.append("    lunch: ").append(toIndentedString(lunch)).append("\n");
    sb.append("    dinner: ").append(toIndentedString(dinner)).append("\n");
    sb.append("    allInclusive: ").append(toIndentedString(allInclusive)).append("\n");
    sb.append("    allInclusivePlusAlcohol: ").append(toIndentedString(allInclusivePlusAlcohol)).append("\n");
    sb.append("    sellStartDate: ").append(toIndentedString(sellStartDate)).append("\n");
    sb.append("    sellEndDate: ").append(toIndentedString(sellEndDate)).append("\n");
    sb.append("    stayStartDate: ").append(toIndentedString(stayStartDate)).append("\n");
    sb.append("    stayEndDate: ").append(toIndentedString(stayEndDate)).append("\n");
    sb.append("    loyaltyPointsAccrue: ").append(toIndentedString(loyaltyPointsAccrue)).append("\n");
    sb.append("    maxAdvanceBookingOffset: ").append(toIndentedString(maxAdvanceBookingOffset)).append("\n");
    sb.append("    minAdvanceBookingOffset: ").append(toIndentedString(minAdvanceBookingOffset)).append("\n");
    sb.append("    minTotalOccupancy: ").append(toIndentedString(minTotalOccupancy)).append("\n");
    sb.append("    maxTotalOccupancy: ").append(toIndentedString(maxTotalOccupancy)).append("\n");
    sb.append("    minLOS: ").append(toIndentedString(minLOS)).append("\n");
    sb.append("    maxLOS: ").append(toIndentedString(maxLOS)).append("\n");
    sb.append("    minAge: ").append(toIndentedString(minAge)).append("\n");
    sb.append("    maxAge: ").append(toIndentedString(maxAge)).append("\n");
    sb.append("    ratePlanLevelFees: ").append(toIndentedString(ratePlanLevelFees)).append("\n");
    sb.append("    availableDaysOfWeek: ").append(toIndentedString(availableDaysOfWeek)).append("\n");
    sb.append("    arrivalDaysOfWeek: ").append(toIndentedString(arrivalDaysOfWeek)).append("\n");
    sb.append("    departureDaysOfWeek: ").append(toIndentedString(departureDaysOfWeek)).append("\n");
    sb.append("    requiredDaysOfWeek: ").append(toIndentedString(requiredDaysOfWeek)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    cancellationPolicyIdentifier: ").append(toIndentedString(cancellationPolicyIdentifier)).append("\n");
    sb.append("    cancellationPolicyExceptions: ").append(toIndentedString(cancellationPolicyExceptions)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

