package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.LifestylesResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateLifestylesRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:50.356743433+07:00[Asia/Bangkok]")
public class LifestyleApi {
    private ApiClient apiClient;

    public LifestyleApi() {
        this(new ApiClient());
    }

    @Autowired
    public LifestyleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return LifestylesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLifestylesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return LifestylesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LifestylesResponseSupplier> showLifestyles(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return showLifestylesRequestCreation(hotelIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;LifestylesResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<LifestylesResponseSupplier>> showLifestylesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return showLifestylesRequestCreation(hotelIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Lifestyles
     * Retrieve list of property lifestyles
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show Lifestyles for this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLifestylesWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showLifestylesRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle geoname data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequestSupplier The updateLifestylesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return LifestylesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateLifestylesRequestCreation(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updateLifestylesRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateLifestylesRequestSupplier' is set
        if (updateLifestylesRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateLifestylesRequestSupplier' when calling updateLifestyles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/lifestyles", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle geoname data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequestSupplier The updateLifestylesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return LifestylesResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<LifestylesResponseSupplier> updateLifestyles(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle geoname data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequestSupplier The updateLifestylesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;LifestylesResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<LifestylesResponseSupplier>> updateLifestylesWithHttpInfo(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<LifestylesResponseSupplier> localVarReturnType = new ParameterizedTypeReference<LifestylesResponseSupplier>() {};
        return updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Lifestyles
     * Update selected lifestyles. See [Lifestyle geoname data](#operation/showLifestyles) for supported lifestyles.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update lifestyles for this hotel identifier
     * @param updateLifestylesRequestSupplier The updateLifestylesRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateLifestylesWithResponseSpec(String hotelIdentifier, UpdateLifestylesRequestSupplier updateLifestylesRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateLifestylesRequestCreation(hotelIdentifier, updateLifestylesRequestSupplier, winkVersion);
    }
}
