package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.MasterRateViewSupplier;
import travel.wink.sdk.extranet.model.SetMasterRatePerkRequestSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.ToggleMasterRateRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:50.356743433+07:00[Asia/Bangkok]")
public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec setPerksRequestCreation(String hotelIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = setMasterRatePerkRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'setMasterRatePerkRequestSupplier' is set
        if (setMasterRatePerkRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'setMasterRatePerkRequestSupplier' when calling setPerks", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/perks", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> setPerks(String hotelIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return setPerksRequestCreation(hotelIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> setPerksWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return setPerksRequestCreation(hotelIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Set Master Rate Perks
     * Manage perks for this master rate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param setMasterRatePerkRequestSupplier The setMasterRatePerkRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec setPerksWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, SetMasterRatePerkRequestSupplier setMasterRatePerkRequestSupplier, String winkVersion) throws WebClientResponseException {
        return setPerksRequestCreation(hotelIdentifier, masterRateIdentifier, setMasterRatePerkRequestSupplier, winkVersion);
    }
    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> showMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> showMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }
    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRates1RequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MasterRateViewSupplier> showMasterRates1(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;MasterRateViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MasterRateViewSupplier>>> showMasterRates1WithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRates1WithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec toggleMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = toggleMasterRateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'toggleMasterRateRequestSupplier' is set
        if (toggleMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'toggleMasterRateRequestSupplier' when calling toggleMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/toggle", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> toggleMasterRate(String hotelIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return toggleMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> toggleMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return toggleMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Toggle Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param toggleMasterRateRequestSupplier The toggleMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec toggleMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, ToggleMasterRateRequestSupplier toggleMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return toggleMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, toggleMasterRateRequestSupplier, winkVersion);
    }
}
