/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.56.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * How user likes to have results displayed
 */
@JsonPropertyOrder({
  SearchFiltersSupplier.JSON_PROPERTY_MAX_DISTANCE,
  SearchFiltersSupplier.JSON_PROPERTY_LIFESTYLE,
  SearchFiltersSupplier.JSON_PROPERTY_STAR_RATING,
  SearchFiltersSupplier.JSON_PROPERTY_PERKS,
  SearchFiltersSupplier.JSON_PROPERTY_DISPLAY_BY
})
@JsonTypeName("SearchFilters_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:50.356743433+07:00[Asia/Bangkok]")
public class SearchFiltersSupplier {
  public static final String JSON_PROPERTY_MAX_DISTANCE = "maxDistance";
  private java.math.BigDecimal maxDistance;

  /**
   * A user can filter inventory on a lifestyle
   */
  public enum LifestyleEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleEnum fromValue(String value) {
      for (LifestyleEnum b : LifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
  private LifestyleEnum lifestyle;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public static final String JSON_PROPERTY_PERKS = "perks";
  private List<String> perks;

  public static final String JSON_PROPERTY_DISPLAY_BY = "displayBy";
  private String displayBy;

  public SearchFiltersSupplier() {
  }

  public SearchFiltersSupplier maxDistance(java.math.BigDecimal maxDistance) {
    
    this.maxDistance = maxDistance;
    return this;
  }

   /**
   * A user can query for hotels that are close to UserSession.location
   * @return maxDistance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getMaxDistance() {
    return maxDistance;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDistance(java.math.BigDecimal maxDistance) {
    this.maxDistance = maxDistance;
  }


  public SearchFiltersSupplier lifestyle(LifestyleEnum lifestyle) {
    
    this.lifestyle = lifestyle;
    return this;
  }

   /**
   * A user can filter inventory on a lifestyle
   * @return lifestyle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleEnum getLifestyle() {
    return lifestyle;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyle(LifestyleEnum lifestyle) {
    this.lifestyle = lifestyle;
  }


  public SearchFiltersSupplier starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * A user can filter on number of hotel stars
   * @return starRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  public SearchFiltersSupplier perks(List<String> perks) {
    
    this.perks = perks;
    return this;
  }

  public SearchFiltersSupplier addPerksItem(String perksItem) {
    if (this.perks == null) {
      this.perks = new ArrayList<>();
    }
    this.perks.add(perksItem);
    return this;
  }

   /**
   * Get perks
   * @return perks
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPerks() {
    return perks;
  }


  @JsonProperty(JSON_PROPERTY_PERKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerks(List<String> perks) {
    this.perks = perks;
  }


  public SearchFiltersSupplier displayBy(String displayBy) {
    
    this.displayBy = displayBy;
    return this;
  }

   /**
   * Get displayBy
   * @return displayBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayBy() {
    return displayBy;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayBy(String displayBy) {
    this.displayBy = displayBy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchFiltersSupplier searchFiltersSupplier = (SearchFiltersSupplier) o;
    return Objects.equals(this.maxDistance, searchFiltersSupplier.maxDistance) &&
        Objects.equals(this.lifestyle, searchFiltersSupplier.lifestyle) &&
        Objects.equals(this.starRating, searchFiltersSupplier.starRating) &&
        Objects.equals(this.perks, searchFiltersSupplier.perks) &&
        Objects.equals(this.displayBy, searchFiltersSupplier.displayBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxDistance, lifestyle, starRating, perks, displayBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchFiltersSupplier {\n");
    sb.append("    maxDistance: ").append(toIndentedString(maxDistance)).append("\n");
    sb.append("    lifestyle: ").append(toIndentedString(lifestyle)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("    perks: ").append(toIndentedString(perks)).append("\n");
    sb.append("    displayBy: ").append(toIndentedString(displayBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

