/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.56.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SuggestProfileResponseSupplier
 */
@JsonPropertyOrder({
  SuggestProfileResponseSupplier.JSON_PROPERTY_WEBSITE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_AMBIANCE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_ADDRESS1,
  SuggestProfileResponseSupplier.JSON_PROPERTY_ADDRESS2,
  SuggestProfileResponseSupplier.JSON_PROPERTY_ADDRESS3,
  SuggestProfileResponseSupplier.JSON_PROPERTY_CITY,
  SuggestProfileResponseSupplier.JSON_PROPERTY_PROVINCE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_POSTAL_CODE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_COUNTRY,
  SuggestProfileResponseSupplier.JSON_PROPERTY_PHONE_NUMBER,
  SuggestProfileResponseSupplier.JSON_PROPERTY_EMAIL_ADDRESS,
  SuggestProfileResponseSupplier.JSON_PROPERTY_ARCHITECTURE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_DESIGN_ELEMENTS,
  SuggestProfileResponseSupplier.JSON_PROPERTY_HISTORIC,
  SuggestProfileResponseSupplier.JSON_PROPERTY_NUMBER_OF_ROOMS,
  SuggestProfileResponseSupplier.JSON_PROPERTY_HOTEL_STARS,
  SuggestProfileResponseSupplier.JSON_PROPERTY_LOCATION_CATEGORY,
  SuggestProfileResponseSupplier.JSON_PROPERTY_SEGMENT,
  SuggestProfileResponseSupplier.JSON_PROPERTY_PROPERTY_CLASS,
  SuggestProfileResponseSupplier.JSON_PROPERTY_STYLE,
  SuggestProfileResponseSupplier.JSON_PROPERTY_CHAIN,
  SuggestProfileResponseSupplier.JSON_PROPERTY_BRAND,
  SuggestProfileResponseSupplier.JSON_PROPERTY_YEAR_BUILT
})
@JsonTypeName("SuggestProfileResponse_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:03:50.356743433+07:00[Asia/Bangkok]")
public class SuggestProfileResponseSupplier {
  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public static final String JSON_PROPERTY_AMBIANCE = "ambiance";
  private String ambiance;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_ADDRESS3 = "address3";
  private String address3;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_PROVINCE = "province";
  private String province;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
  private String phoneNumber;

  public static final String JSON_PROPERTY_EMAIL_ADDRESS = "emailAddress";
  private String emailAddress;

  public static final String JSON_PROPERTY_ARCHITECTURE = "architecture";
  private String architecture;

  public static final String JSON_PROPERTY_DESIGN_ELEMENTS = "designElements";
  private String designElements;

  public static final String JSON_PROPERTY_HISTORIC = "historic";
  private String historic;

  public static final String JSON_PROPERTY_NUMBER_OF_ROOMS = "numberOfRooms";
  private String numberOfRooms;

  public static final String JSON_PROPERTY_HOTEL_STARS = "hotelStars";
  private String hotelStars;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT = "segment";
  private String segment;

  public static final String JSON_PROPERTY_PROPERTY_CLASS = "propertyClass";
  private String propertyClass;

  public static final String JSON_PROPERTY_STYLE = "style";
  private String style;

  public static final String JSON_PROPERTY_CHAIN = "chain";
  private String chain;

  public static final String JSON_PROPERTY_BRAND = "brand";
  private String brand;

  public static final String JSON_PROPERTY_YEAR_BUILT = "yearBuilt";
  private String yearBuilt;

  public SuggestProfileResponseSupplier() {
  }

  public SuggestProfileResponseSupplier website(String website) {
    
    this.website = website;
    return this;
  }

   /**
   * Website
   * @return website
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWebsite(String website) {
    this.website = website;
  }


  public SuggestProfileResponseSupplier ambiance(String ambiance) {
    
    this.ambiance = ambiance;
    return this;
  }

   /**
   * Property ambiance
   * @return ambiance
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_AMBIANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAmbiance() {
    return ambiance;
  }


  @JsonProperty(JSON_PROPERTY_AMBIANCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmbiance(String ambiance) {
    this.ambiance = ambiance;
  }


  public SuggestProfileResponseSupplier address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Get address1
   * @return address1
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public SuggestProfileResponseSupplier address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Get address2
   * @return address2
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public SuggestProfileResponseSupplier address3(String address3) {
    
    this.address3 = address3;
    return this;
  }

   /**
   * Get address3
   * @return address3
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress3() {
    return address3;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS3)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress3(String address3) {
    this.address3 = address3;
  }


  public SuggestProfileResponseSupplier city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public SuggestProfileResponseSupplier province(String province) {
    
    this.province = province;
    return this;
  }

   /**
   * Get province
   * @return province
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProvince() {
    return province;
  }


  @JsonProperty(JSON_PROPERTY_PROVINCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvince(String province) {
    this.province = province;
  }


  public SuggestProfileResponseSupplier postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Get postalCode
   * @return postalCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public SuggestProfileResponseSupplier country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public SuggestProfileResponseSupplier phoneNumber(String phoneNumber) {
    
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * Get phoneNumber
   * @return phoneNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhoneNumber() {
    return phoneNumber;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  public SuggestProfileResponseSupplier emailAddress(String emailAddress) {
    
    this.emailAddress = emailAddress;
    return this;
  }

   /**
   * Get emailAddress
   * @return emailAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailAddress() {
    return emailAddress;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }


  public SuggestProfileResponseSupplier architecture(String architecture) {
    
    this.architecture = architecture;
    return this;
  }

   /**
   * Get architecture
   * @return architecture
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getArchitecture() {
    return architecture;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecture(String architecture) {
    this.architecture = architecture;
  }


  public SuggestProfileResponseSupplier designElements(String designElements) {
    
    this.designElements = designElements;
    return this;
  }

   /**
   * Get designElements
   * @return designElements
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESIGN_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDesignElements() {
    return designElements;
  }


  @JsonProperty(JSON_PROPERTY_DESIGN_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDesignElements(String designElements) {
    this.designElements = designElements;
  }


  public SuggestProfileResponseSupplier historic(String historic) {
    
    this.historic = historic;
    return this;
  }

   /**
   * Get historic
   * @return historic
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HISTORIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHistoric() {
    return historic;
  }


  @JsonProperty(JSON_PROPERTY_HISTORIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHistoric(String historic) {
    this.historic = historic;
  }


  public SuggestProfileResponseSupplier numberOfRooms(String numberOfRooms) {
    
    this.numberOfRooms = numberOfRooms;
    return this;
  }

   /**
   * Get numberOfRooms
   * @return numberOfRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNumberOfRooms() {
    return numberOfRooms;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRooms(String numberOfRooms) {
    this.numberOfRooms = numberOfRooms;
  }


  public SuggestProfileResponseSupplier hotelStars(String hotelStars) {
    
    this.hotelStars = hotelStars;
    return this;
  }

   /**
   * Get hotelStars
   * @return hotelStars
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelStars() {
    return hotelStars;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelStars(String hotelStars) {
    this.hotelStars = hotelStars;
  }


  public SuggestProfileResponseSupplier locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Get locationCategory
   * @return locationCategory
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public SuggestProfileResponseSupplier segment(String segment) {
    
    this.segment = segment;
    return this;
  }

   /**
   * Get segment
   * @return segment
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSegment() {
    return segment;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegment(String segment) {
    this.segment = segment;
  }


  public SuggestProfileResponseSupplier propertyClass(String propertyClass) {
    
    this.propertyClass = propertyClass;
    return this;
  }

   /**
   * Get propertyClass
   * @return propertyClass
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyClass() {
    return propertyClass;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyClass(String propertyClass) {
    this.propertyClass = propertyClass;
  }


  public SuggestProfileResponseSupplier style(String style) {
    
    this.style = style;
    return this;
  }

   /**
   * Get style
   * @return style
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStyle() {
    return style;
  }


  @JsonProperty(JSON_PROPERTY_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStyle(String style) {
    this.style = style;
  }


  public SuggestProfileResponseSupplier chain(String chain) {
    
    this.chain = chain;
    return this;
  }

   /**
   * Get chain
   * @return chain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getChain() {
    return chain;
  }


  @JsonProperty(JSON_PROPERTY_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChain(String chain) {
    this.chain = chain;
  }


  public SuggestProfileResponseSupplier brand(String brand) {
    
    this.brand = brand;
    return this;
  }

   /**
   * Get brand
   * @return brand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrand() {
    return brand;
  }


  @JsonProperty(JSON_PROPERTY_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrand(String brand) {
    this.brand = brand;
  }


  public SuggestProfileResponseSupplier yearBuilt(String yearBuilt) {
    
    this.yearBuilt = yearBuilt;
    return this;
  }

   /**
   * Get yearBuilt
   * @return yearBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_YEAR_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getYearBuilt() {
    return yearBuilt;
  }


  @JsonProperty(JSON_PROPERTY_YEAR_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setYearBuilt(String yearBuilt) {
    this.yearBuilt = yearBuilt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SuggestProfileResponseSupplier suggestProfileResponseSupplier = (SuggestProfileResponseSupplier) o;
    return Objects.equals(this.website, suggestProfileResponseSupplier.website) &&
        Objects.equals(this.ambiance, suggestProfileResponseSupplier.ambiance) &&
        Objects.equals(this.address1, suggestProfileResponseSupplier.address1) &&
        Objects.equals(this.address2, suggestProfileResponseSupplier.address2) &&
        Objects.equals(this.address3, suggestProfileResponseSupplier.address3) &&
        Objects.equals(this.city, suggestProfileResponseSupplier.city) &&
        Objects.equals(this.province, suggestProfileResponseSupplier.province) &&
        Objects.equals(this.postalCode, suggestProfileResponseSupplier.postalCode) &&
        Objects.equals(this.country, suggestProfileResponseSupplier.country) &&
        Objects.equals(this.phoneNumber, suggestProfileResponseSupplier.phoneNumber) &&
        Objects.equals(this.emailAddress, suggestProfileResponseSupplier.emailAddress) &&
        Objects.equals(this.architecture, suggestProfileResponseSupplier.architecture) &&
        Objects.equals(this.designElements, suggestProfileResponseSupplier.designElements) &&
        Objects.equals(this.historic, suggestProfileResponseSupplier.historic) &&
        Objects.equals(this.numberOfRooms, suggestProfileResponseSupplier.numberOfRooms) &&
        Objects.equals(this.hotelStars, suggestProfileResponseSupplier.hotelStars) &&
        Objects.equals(this.locationCategory, suggestProfileResponseSupplier.locationCategory) &&
        Objects.equals(this.segment, suggestProfileResponseSupplier.segment) &&
        Objects.equals(this.propertyClass, suggestProfileResponseSupplier.propertyClass) &&
        Objects.equals(this.style, suggestProfileResponseSupplier.style) &&
        Objects.equals(this.chain, suggestProfileResponseSupplier.chain) &&
        Objects.equals(this.brand, suggestProfileResponseSupplier.brand) &&
        Objects.equals(this.yearBuilt, suggestProfileResponseSupplier.yearBuilt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(website, ambiance, address1, address2, address3, city, province, postalCode, country, phoneNumber, emailAddress, architecture, designElements, historic, numberOfRooms, hotelStars, locationCategory, segment, propertyClass, style, chain, brand, yearBuilt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SuggestProfileResponseSupplier {\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    ambiance: ").append(toIndentedString(ambiance)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    address3: ").append(toIndentedString(address3)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    province: ").append(toIndentedString(province)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    emailAddress: ").append(toIndentedString(emailAddress)).append("\n");
    sb.append("    architecture: ").append(toIndentedString(architecture)).append("\n");
    sb.append("    designElements: ").append(toIndentedString(designElements)).append("\n");
    sb.append("    historic: ").append(toIndentedString(historic)).append("\n");
    sb.append("    numberOfRooms: ").append(toIndentedString(numberOfRooms)).append("\n");
    sb.append("    hotelStars: ").append(toIndentedString(hotelStars)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segment: ").append(toIndentedString(segment)).append("\n");
    sb.append("    propertyClass: ").append(toIndentedString(propertyClass)).append("\n");
    sb.append("    style: ").append(toIndentedString(style)).append("\n");
    sb.append("    chain: ").append(toIndentedString(chain)).append("\n");
    sb.append("    brand: ").append(toIndentedString(brand)).append("\n");
    sb.append("    yearBuilt: ").append(toIndentedString(yearBuilt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

