/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.59.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.extranet.model.BeneficiarySupplier;
import travel.wink.sdk.extranet.model.DailyRateSupplier;
import travel.wink.sdk.extranet.model.GuestUserSupplier;
import travel.wink.sdk.extranet.model.ItinerarySupplier;
import travel.wink.sdk.extranet.model.SupplierContractItemPolicySupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Returns the lodging item only.
 */
@JsonPropertyOrder({
  BookingContractItemSupplier.JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE,
  BookingContractItemSupplier.JSON_PROPERTY_USER,
  BookingContractItemSupplier.JSON_PROPERTY_NAME_IN_ENGLISH,
  BookingContractItemSupplier.JSON_PROPERTY_DESCRIPTION_IN_ENGLISH,
  BookingContractItemSupplier.JSON_PROPERTY_ITINERARY,
  BookingContractItemSupplier.JSON_PROPERTY_PRICING_TYPE,
  BookingContractItemSupplier.JSON_PROPERTY_TYPE,
  BookingContractItemSupplier.JSON_PROPERTY_BENEFICIARY_LIST,
  BookingContractItemSupplier.JSON_PROPERTY_PAYABLE,
  BookingContractItemSupplier.JSON_PROPERTY_POLICY,
  BookingContractItemSupplier.JSON_PROPERTY_EXTERNAL_IDENTIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_TOKENS_EARNED,
  BookingContractItemSupplier.JSON_PROPERTY_DAILY_RATE_LIST,
  BookingContractItemSupplier.JSON_PROPERTY_CANCELLED,
  BookingContractItemSupplier.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractItemSupplier.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractItemSupplier.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractItemSupplier.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractItemSupplier.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractItemSupplier.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractItemSupplier.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractItemSupplier.JSON_PROPERTY_METADATA,
  BookingContractItemSupplier.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractItemSupplier.JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractItemSupplier.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER,
  BookingContractItemSupplier.JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER,
  BookingContractItemSupplier.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER
})
@JsonTypeName("BookingContractItem_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-03T09:32:29.460106668+07:00[Asia/Bangkok]")
public class BookingContractItemSupplier {
  public static final String JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE = "supplierItemBookingCode";
  private String supplierItemBookingCode;

  public static final String JSON_PROPERTY_USER = "user";
  private GuestUserSupplier user;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_DESCRIPTION_IN_ENGLISH = "descriptionInEnglish";
  private String descriptionInEnglish;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItinerarySupplier itinerary;

  /**
   * How to calculate the total amount.
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  /**
   * Type of item this is.
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_BENEFICIARY_LIST = "beneficiaryList";
  private List<BeneficiarySupplier> beneficiaryList;

  /**
   * When to charge for this item.
   */
  public enum PayableEnum {
    IMMEDIATE("IMMEDIATE"),
    
    ARRIVAL("ARRIVAL"),
    
    DEPARTURE("DEPARTURE"),
    
    AGENT("AGENT");

    private String value;

    PayableEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayableEnum fromValue(String value) {
      for (PayableEnum b : PayableEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYABLE = "payable";
  private PayableEnum payable;

  public static final String JSON_PROPERTY_POLICY = "policy";
  private SupplierContractItemPolicySupplier policy;

  public static final String JSON_PROPERTY_EXTERNAL_IDENTIFIER = "externalIdentifier";
  private String externalIdentifier;

  public static final String JSON_PROPERTY_TOKENS_EARNED = "tokensEarned";
  private Long tokensEarned;

  public static final String JSON_PROPERTY_DAILY_RATE_LIST = "dailyRateList";
  private List<DailyRateSupplier> dailyRateList;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES = "cancellableWithPotentialCharges";
  private Boolean cancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER = "isCancellableBySupplier";
  private Boolean isCancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public BookingContractItemSupplier() {
  }

  public BookingContractItemSupplier supplierItemBookingCode(String supplierItemBookingCode) {
    
    this.supplierItemBookingCode = supplierItemBookingCode;
    return this;
  }

   /**
   * Booking code identifying the supplier line item.
   * @return supplierItemBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierItemBookingCode() {
    return supplierItemBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_ITEM_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierItemBookingCode(String supplierItemBookingCode) {
    this.supplierItemBookingCode = supplierItemBookingCode;
  }


  public BookingContractItemSupplier user(GuestUserSupplier user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GuestUserSupplier getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(GuestUserSupplier user) {
    this.user = user;
  }


  public BookingContractItemSupplier nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of item in English included in booking.
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public BookingContractItemSupplier descriptionInEnglish(String descriptionInEnglish) {
    
    this.descriptionInEnglish = descriptionInEnglish;
    return this;
  }

   /**
   * Short description in English of item included in booking.
   * @return descriptionInEnglish
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescriptionInEnglish() {
    return descriptionInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescriptionInEnglish(String descriptionInEnglish) {
    this.descriptionInEnglish = descriptionInEnglish;
  }


  public BookingContractItemSupplier itinerary(ItinerarySupplier itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ItinerarySupplier getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItinerary(ItinerarySupplier itinerary) {
    this.itinerary = itinerary;
  }


  public BookingContractItemSupplier pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * How to calculate the total amount.
   * @return pricingType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public BookingContractItemSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of item this is.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public BookingContractItemSupplier beneficiaryList(List<BeneficiarySupplier> beneficiaryList) {
    
    this.beneficiaryList = beneficiaryList;
    return this;
  }

  public BookingContractItemSupplier addBeneficiaryListItem(BeneficiarySupplier beneficiaryListItem) {
    if (this.beneficiaryList == null) {
      this.beneficiaryList = new ArrayList<>();
    }
    this.beneficiaryList.add(beneficiaryListItem);
    return this;
  }

   /**
   * Get beneficiaryList
   * @return beneficiaryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BeneficiarySupplier> getBeneficiaryList() {
    return beneficiaryList;
  }


  @JsonProperty(JSON_PROPERTY_BENEFICIARY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBeneficiaryList(List<BeneficiarySupplier> beneficiaryList) {
    this.beneficiaryList = beneficiaryList;
  }


  public BookingContractItemSupplier payable(PayableEnum payable) {
    
    this.payable = payable;
    return this;
  }

   /**
   * When to charge for this item.
   * @return payable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayableEnum getPayable() {
    return payable;
  }


  @JsonProperty(JSON_PROPERTY_PAYABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayable(PayableEnum payable) {
    this.payable = payable;
  }


  public BookingContractItemSupplier policy(SupplierContractItemPolicySupplier policy) {
    
    this.policy = policy;
    return this;
  }

   /**
   * Get policy
   * @return policy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SupplierContractItemPolicySupplier getPolicy() {
    return policy;
  }


  @JsonProperty(JSON_PROPERTY_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicy(SupplierContractItemPolicySupplier policy) {
    this.policy = policy;
  }


  public BookingContractItemSupplier externalIdentifier(String externalIdentifier) {
    
    this.externalIdentifier = externalIdentifier;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return externalIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalIdentifier() {
    return externalIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalIdentifier(String externalIdentifier) {
    this.externalIdentifier = externalIdentifier;
  }


  public BookingContractItemSupplier tokensEarned(Long tokensEarned) {
    
    this.tokensEarned = tokensEarned;
    return this;
  }

   /**
   * Tokens earned for this item
   * @return tokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTokensEarned() {
    return tokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokensEarned(Long tokensEarned) {
    this.tokensEarned = tokensEarned;
  }


  public BookingContractItemSupplier dailyRateList(List<DailyRateSupplier> dailyRateList) {
    
    this.dailyRateList = dailyRateList;
    return this;
  }

  public BookingContractItemSupplier addDailyRateListItem(DailyRateSupplier dailyRateListItem) {
    if (this.dailyRateList == null) {
      this.dailyRateList = new ArrayList<>();
    }
    this.dailyRateList.add(dailyRateListItem);
    return this;
  }

   /**
   * Get dailyRateList
   * @return dailyRateList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRateSupplier> getDailyRateList() {
    return dailyRateList;
  }


  @JsonProperty(JSON_PROPERTY_DAILY_RATE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDailyRateList(List<DailyRateSupplier> dailyRateList) {
    this.dailyRateList = dailyRateList;
  }


  public BookingContractItemSupplier cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractItemSupplier sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BookingContractItemSupplier displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BookingContractItemSupplier supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BookingContractItemSupplier internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BookingContractItemSupplier captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BookingContractItemSupplier sourceAmount(BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * @return sourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmount(BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BookingContractItemSupplier displayAmount(BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * @return displayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmount(BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BookingContractItemSupplier supplierAmount(BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * @return supplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmount(BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BookingContractItemSupplier internalAmount(BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BookingContractItemSupplier captureAmount(BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * @return captureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmount(BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BookingContractItemSupplier sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BookingContractItemSupplier displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BookingContractItemSupplier supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BookingContractItemSupplier internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BookingContractItemSupplier captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BookingContractItemSupplier netSourceAmount(BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSourceAmount(BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BookingContractItemSupplier netDisplayAmount(BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * The total display price.
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BookingContractItemSupplier netSupplierAmount(BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BookingContractItemSupplier netInternalAmount(BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Get netInternalAmount
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BookingContractItemSupplier netCaptureAmount(BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * The total capture price.
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  public BookingContractItemSupplier metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractItemSupplier putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Place to add more data related to the booking contract item.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public BookingContractItemSupplier cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractItemSupplier cancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether the booking can still be cancelled and whether cancellation charges might still occur.
   * @return cancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithPotentialCharges() {
    return cancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithPotentialCharges(Boolean cancellableWithPotentialCharges) {
    this.cancellableWithPotentialCharges = cancellableWithPotentialCharges;
  }


  public BookingContractItemSupplier cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }


  public BookingContractItemSupplier isCancellableBySupplier(Boolean isCancellableBySupplier) {
    
    this.isCancellableBySupplier = isCancellableBySupplier;
    return this;
  }

   /**
   * Get isCancellableBySupplier
   * @return isCancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableBySupplier() {
    return isCancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableBySupplier(Boolean isCancellableBySupplier) {
    this.isCancellableBySupplier = isCancellableBySupplier;
  }


  public BookingContractItemSupplier cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled by the supplier. A supplier cancellation overrides the refundable
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractItemSupplier bookingContractItemSupplier = (BookingContractItemSupplier) o;
    return Objects.equals(this.supplierItemBookingCode, bookingContractItemSupplier.supplierItemBookingCode) &&
        Objects.equals(this.user, bookingContractItemSupplier.user) &&
        Objects.equals(this.nameInEnglish, bookingContractItemSupplier.nameInEnglish) &&
        Objects.equals(this.descriptionInEnglish, bookingContractItemSupplier.descriptionInEnglish) &&
        Objects.equals(this.itinerary, bookingContractItemSupplier.itinerary) &&
        Objects.equals(this.pricingType, bookingContractItemSupplier.pricingType) &&
        Objects.equals(this.type, bookingContractItemSupplier.type) &&
        Objects.equals(this.beneficiaryList, bookingContractItemSupplier.beneficiaryList) &&
        Objects.equals(this.payable, bookingContractItemSupplier.payable) &&
        Objects.equals(this.policy, bookingContractItemSupplier.policy) &&
        Objects.equals(this.externalIdentifier, bookingContractItemSupplier.externalIdentifier) &&
        Objects.equals(this.tokensEarned, bookingContractItemSupplier.tokensEarned) &&
        Objects.equals(this.dailyRateList, bookingContractItemSupplier.dailyRateList) &&
        Objects.equals(this.cancelled, bookingContractItemSupplier.cancelled) &&
        Objects.equals(this.sourceCurrency, bookingContractItemSupplier.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractItemSupplier.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractItemSupplier.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractItemSupplier.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractItemSupplier.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractItemSupplier.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractItemSupplier.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractItemSupplier.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractItemSupplier.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractItemSupplier.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractItemSupplier.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractItemSupplier.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractItemSupplier.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractItemSupplier.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractItemSupplier.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractItemSupplier.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractItemSupplier.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractItemSupplier.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractItemSupplier.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractItemSupplier.netCaptureAmount) &&
        Objects.equals(this.metadata, bookingContractItemSupplier.metadata) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractItemSupplier.cancellableWithNoCharges) &&
        Objects.equals(this.cancellableWithPotentialCharges, bookingContractItemSupplier.cancellableWithPotentialCharges) &&
        Objects.equals(this.cancellableByTraveler, bookingContractItemSupplier.cancellableByTraveler) &&
        Objects.equals(this.isCancellableBySupplier, bookingContractItemSupplier.isCancellableBySupplier) &&
        Objects.equals(this.cancellableBySupplier, bookingContractItemSupplier.cancellableBySupplier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplierItemBookingCode, user, nameInEnglish, descriptionInEnglish, itinerary, pricingType, type, beneficiaryList, payable, policy, externalIdentifier, tokensEarned, dailyRateList, cancelled, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, metadata, cancellableWithNoCharges, cancellableWithPotentialCharges, cancellableByTraveler, isCancellableBySupplier, cancellableBySupplier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractItemSupplier {\n");
    sb.append("    supplierItemBookingCode: ").append(toIndentedString(supplierItemBookingCode)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    descriptionInEnglish: ").append(toIndentedString(descriptionInEnglish)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaryList: ").append(toIndentedString(beneficiaryList)).append("\n");
    sb.append("    payable: ").append(toIndentedString(payable)).append("\n");
    sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
    sb.append("    externalIdentifier: ").append(toIndentedString(externalIdentifier)).append("\n");
    sb.append("    tokensEarned: ").append(toIndentedString(tokensEarned)).append("\n");
    sb.append("    dailyRateList: ").append(toIndentedString(dailyRateList)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    cancellableWithPotentialCharges: ").append(toIndentedString(cancellableWithPotentialCharges)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("    isCancellableBySupplier: ").append(toIndentedString(isCancellableBySupplier)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

