/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.59.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPolygonSupplier;
import travel.wink.sdk.extranet.model.IPLocationSupplier;
import travel.wink.sdk.extranet.model.ItinerarySupplier;
import travel.wink.sdk.extranet.model.RoomConfigurationSupplier;
import travel.wink.sdk.extranet.model.SearchFiltersSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User session information containing itinerary and other user related data.
 */
@JsonPropertyOrder({
  UserSessionSupplier.JSON_PROPERTY_LOCATION,
  UserSessionSupplier.JSON_PROPERTY_IP_LOCATION,
  UserSessionSupplier.JSON_PROPERTY_IP_NUMBER,
  UserSessionSupplier.JSON_PROPERTY_BOUNDS,
  UserSessionSupplier.JSON_PROPERTY_ITINERARY,
  UserSessionSupplier.JSON_PROPERTY_SEARCH_FILTERS,
  UserSessionSupplier.JSON_PROPERTY_LANGUAGE,
  UserSessionSupplier.JSON_PROPERTY_CURRENCY,
  UserSessionSupplier.JSON_PROPERTY_REDIRECT_URL,
  UserSessionSupplier.JSON_PROPERTY_PROMOTIONAL_CODES,
  UserSessionSupplier.JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION
})
@JsonTypeName("UserSession_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-03T09:32:29.460106668+07:00[Asia/Bangkok]")
public class UserSessionSupplier {
  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_IP_LOCATION = "ipLocation";
  private IPLocationSupplier ipLocation;

  public static final String JSON_PROPERTY_IP_NUMBER = "ipNumber";
  private String ipNumber;

  public static final String JSON_PROPERTY_BOUNDS = "bounds";
  private GeoJsonPolygonSupplier bounds;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  private ItinerarySupplier itinerary;

  public static final String JSON_PROPERTY_SEARCH_FILTERS = "searchFilters";
  private SearchFiltersSupplier searchFilters;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
  private String redirectUrl;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION = "selectedRoomConfiguration";
  private RoomConfigurationSupplier selectedRoomConfiguration;

  public UserSessionSupplier() {
  }

  public UserSessionSupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public UserSessionSupplier ipLocation(IPLocationSupplier ipLocation) {
    
    this.ipLocation = ipLocation;
    return this;
  }

   /**
   * Get ipLocation
   * @return ipLocation
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IPLocationSupplier getIpLocation() {
    return ipLocation;
  }


  @JsonProperty(JSON_PROPERTY_IP_LOCATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpLocation(IPLocationSupplier ipLocation) {
    this.ipLocation = ipLocation;
  }


  public UserSessionSupplier ipNumber(String ipNumber) {
    
    this.ipNumber = ipNumber;
    return this;
  }

   /**
   * User&#39;s incoming IP number
   * @return ipNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpNumber() {
    return ipNumber;
  }


  @JsonProperty(JSON_PROPERTY_IP_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpNumber(String ipNumber) {
    this.ipNumber = ipNumber;
  }


  public UserSessionSupplier bounds(GeoJsonPolygonSupplier bounds) {
    
    this.bounds = bounds;
    return this;
  }

   /**
   * Get bounds
   * @return bounds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPolygonSupplier getBounds() {
    return bounds;
  }


  @JsonProperty(JSON_PROPERTY_BOUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBounds(GeoJsonPolygonSupplier bounds) {
    this.bounds = bounds;
  }


  public UserSessionSupplier itinerary(ItinerarySupplier itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

   /**
   * Get itinerary
   * @return itinerary
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItinerarySupplier getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(ItinerarySupplier itinerary) {
    this.itinerary = itinerary;
  }


  public UserSessionSupplier searchFilters(SearchFiltersSupplier searchFilters) {
    
    this.searchFilters = searchFilters;
    return this;
  }

   /**
   * Get searchFilters
   * @return searchFilters
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SearchFiltersSupplier getSearchFilters() {
    return searchFilters;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_FILTERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchFilters(SearchFiltersSupplier searchFilters) {
    this.searchFilters = searchFilters;
  }


  public UserSessionSupplier language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * User&#39;s language preference
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public UserSessionSupplier currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * User&#39;s currency preference
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public UserSessionSupplier redirectUrl(String redirectUrl) {
    
    this.redirectUrl = redirectUrl;
    return this;
  }

   /**
   * Get redirectUrl
   * @return redirectUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRedirectUrl() {
    return redirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }


  public UserSessionSupplier promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public UserSessionSupplier addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Get promotionalCodes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public UserSessionSupplier selectedRoomConfiguration(RoomConfigurationSupplier selectedRoomConfiguration) {
    
    this.selectedRoomConfiguration = selectedRoomConfiguration;
    return this;
  }

   /**
   * Get selectedRoomConfiguration
   * @return selectedRoomConfiguration
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationSupplier getSelectedRoomConfiguration() {
    return selectedRoomConfiguration;
  }


  @JsonProperty(JSON_PROPERTY_SELECTED_ROOM_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelectedRoomConfiguration(RoomConfigurationSupplier selectedRoomConfiguration) {
    this.selectedRoomConfiguration = selectedRoomConfiguration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserSessionSupplier userSessionSupplier = (UserSessionSupplier) o;
    return Objects.equals(this.location, userSessionSupplier.location) &&
        Objects.equals(this.ipLocation, userSessionSupplier.ipLocation) &&
        Objects.equals(this.ipNumber, userSessionSupplier.ipNumber) &&
        Objects.equals(this.bounds, userSessionSupplier.bounds) &&
        Objects.equals(this.itinerary, userSessionSupplier.itinerary) &&
        Objects.equals(this.searchFilters, userSessionSupplier.searchFilters) &&
        Objects.equals(this.language, userSessionSupplier.language) &&
        Objects.equals(this.currency, userSessionSupplier.currency) &&
        Objects.equals(this.redirectUrl, userSessionSupplier.redirectUrl) &&
        Objects.equals(this.promotionalCodes, userSessionSupplier.promotionalCodes) &&
        Objects.equals(this.selectedRoomConfiguration, userSessionSupplier.selectedRoomConfiguration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(location, ipLocation, ipNumber, bounds, itinerary, searchFilters, language, currency, redirectUrl, promotionalCodes, selectedRoomConfiguration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserSessionSupplier {\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    ipLocation: ").append(toIndentedString(ipLocation)).append("\n");
    sb.append("    ipNumber: ").append(toIndentedString(ipNumber)).append("\n");
    sb.append("    bounds: ").append(toIndentedString(bounds)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("    searchFilters: ").append(toIndentedString(searchFilters)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    selectedRoomConfiguration: ").append(toIndentedString(selectedRoomConfiguration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

