/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import travel.wink.sdk.extranet.model.FeeSupplierDetails;

@JsonPropertyOrder(value={"acquirerIdentifier", "vendor", "transactionIdentifier", "customerIdentifier", "status", "agentInvoicedDate", "agentInvoiceIdentifier", "redirectUrl", "fees", "vendorSpecific"})
@JsonTypeName(value="BookingContractPaymentDetails_SupplierDetails")
public class BookingContractPaymentDetailsSupplierDetails {
    public static final String JSON_PROPERTY_ACQUIRER_IDENTIFIER = "acquirerIdentifier";
    private String acquirerIdentifier;
    public static final String JSON_PROPERTY_VENDOR = "vendor";
    private VendorEnum vendor;
    public static final String JSON_PROPERTY_TRANSACTION_IDENTIFIER = "transactionIdentifier";
    private String transactionIdentifier;
    public static final String JSON_PROPERTY_CUSTOMER_IDENTIFIER = "customerIdentifier";
    private String customerIdentifier;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_AGENT_INVOICED_DATE = "agentInvoicedDate";
    private LocalDateTime agentInvoicedDate;
    public static final String JSON_PROPERTY_AGENT_INVOICE_IDENTIFIER = "agentInvoiceIdentifier";
    private String agentInvoiceIdentifier;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_FEES = "fees";
    private List<FeeSupplierDetails> fees;
    public static final String JSON_PROPERTY_VENDOR_SPECIFIC = "vendorSpecific";
    private Map<String, String> vendorSpecific = new HashMap<String, String>();

    public BookingContractPaymentDetailsSupplierDetails acquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcquirerIdentifier() {
        return this.acquirerIdentifier;
    }

    @JsonProperty(value="acquirerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquirerIdentifier(String acquirerIdentifier) {
        this.acquirerIdentifier = acquirerIdentifier;
    }

    public BookingContractPaymentDetailsSupplierDetails vendor(VendorEnum vendor) {
        this.vendor = vendor;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VendorEnum getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendor(VendorEnum vendor) {
        this.vendor = vendor;
    }

    public BookingContractPaymentDetailsSupplierDetails transactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="transactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    @JsonProperty(value="transactionIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransactionIdentifier(String transactionIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
    }

    public BookingContractPaymentDetailsSupplierDetails customerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerIdentifier() {
        return this.customerIdentifier;
    }

    @JsonProperty(value="customerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerIdentifier(String customerIdentifier) {
        this.customerIdentifier = customerIdentifier;
    }

    public BookingContractPaymentDetailsSupplierDetails status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BookingContractPaymentDetailsSupplierDetails agentInvoicedDate(LocalDateTime agentInvoicedDate) {
        this.agentInvoicedDate = agentInvoicedDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="agentInvoicedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getAgentInvoicedDate() {
        return this.agentInvoicedDate;
    }

    @JsonProperty(value="agentInvoicedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgentInvoicedDate(LocalDateTime agentInvoicedDate) {
        this.agentInvoicedDate = agentInvoicedDate;
    }

    public BookingContractPaymentDetailsSupplierDetails agentInvoiceIdentifier(String agentInvoiceIdentifier) {
        this.agentInvoiceIdentifier = agentInvoiceIdentifier;
        return this;
    }

    @Nullable
    @JsonProperty(value="agentInvoiceIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAgentInvoiceIdentifier() {
        return this.agentInvoiceIdentifier;
    }

    @JsonProperty(value="agentInvoiceIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgentInvoiceIdentifier(String agentInvoiceIdentifier) {
        this.agentInvoiceIdentifier = agentInvoiceIdentifier;
    }

    public BookingContractPaymentDetailsSupplierDetails redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public BookingContractPaymentDetailsSupplierDetails fees(List<FeeSupplierDetails> fees) {
        this.fees = fees;
        return this;
    }

    public BookingContractPaymentDetailsSupplierDetails addFeesItem(FeeSupplierDetails feesItem) {
        if (this.fees == null) {
            this.fees = new ArrayList<FeeSupplierDetails>();
        }
        this.fees.add(feesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FeeSupplierDetails> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFees(List<FeeSupplierDetails> fees) {
        this.fees = fees;
    }

    public BookingContractPaymentDetailsSupplierDetails vendorSpecific(Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
        return this;
    }

    public BookingContractPaymentDetailsSupplierDetails putVendorSpecificItem(String key, String vendorSpecificItem) {
        this.vendorSpecific.put(key, vendorSpecificItem);
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getVendorSpecific() {
        return this.vendorSpecific;
    }

    @JsonProperty(value="vendorSpecific")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVendorSpecific(Map<String, String> vendorSpecific) {
        this.vendorSpecific = vendorSpecific;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookingContractPaymentDetailsSupplierDetails bookingContractPaymentDetailsSupplierDetails = (BookingContractPaymentDetailsSupplierDetails)o;
        return Objects.equals(this.acquirerIdentifier, bookingContractPaymentDetailsSupplierDetails.acquirerIdentifier) && Objects.equals((Object)this.vendor, (Object)bookingContractPaymentDetailsSupplierDetails.vendor) && Objects.equals(this.transactionIdentifier, bookingContractPaymentDetailsSupplierDetails.transactionIdentifier) && Objects.equals(this.customerIdentifier, bookingContractPaymentDetailsSupplierDetails.customerIdentifier) && Objects.equals((Object)this.status, (Object)bookingContractPaymentDetailsSupplierDetails.status) && Objects.equals(this.agentInvoicedDate, bookingContractPaymentDetailsSupplierDetails.agentInvoicedDate) && Objects.equals(this.agentInvoiceIdentifier, bookingContractPaymentDetailsSupplierDetails.agentInvoiceIdentifier) && Objects.equals(this.redirectUrl, bookingContractPaymentDetailsSupplierDetails.redirectUrl) && Objects.equals(this.fees, bookingContractPaymentDetailsSupplierDetails.fees) && Objects.equals(this.vendorSpecific, bookingContractPaymentDetailsSupplierDetails.vendorSpecific);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquirerIdentifier, this.vendor, this.transactionIdentifier, this.customerIdentifier, this.status, this.agentInvoicedDate, this.agentInvoiceIdentifier, this.redirectUrl, this.fees, this.vendorSpecific});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookingContractPaymentDetailsSupplierDetails {\n");
        sb.append("    acquirerIdentifier: ").append(this.toIndentedString(this.acquirerIdentifier)).append("\n");
        sb.append("    vendor: ").append(this.toIndentedString((Object)this.vendor)).append("\n");
        sb.append("    transactionIdentifier: ").append(this.toIndentedString(this.transactionIdentifier)).append("\n");
        sb.append("    customerIdentifier: ").append(this.toIndentedString(this.customerIdentifier)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    agentInvoicedDate: ").append(this.toIndentedString(this.agentInvoicedDate)).append("\n");
        sb.append("    agentInvoiceIdentifier: ").append(this.toIndentedString(this.agentInvoiceIdentifier)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    vendorSpecific: ").append(this.toIndentedString(this.vendorSpecific)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VendorEnum {
        STRIPE("STRIPE"),
        AGENT("AGENT"),
        NMI("NMI"),
        WISE("WISE");

        private String value;

        private VendorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VendorEnum fromValue(String value) {
            for (VendorEnum b : VendorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        INITIALIZED("INITIALIZED"),
        PROCESSING("PROCESSING"),
        SUCCEEDED("SUCCEEDED"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

