package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.SimpleMultimedia;
import travel.wink.sdk.extranet.model.UpgradeView;
import travel.wink.sdk.extranet.model.UpsertAddOnRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-08T09:23:20.721546517+07:00[Asia/Bangkok]")
public class AddOnApi {
    private ApiClient apiClient;

    public AddOnApi() {
        this(new ApiClient());
    }

    @Autowired
    public AddOnApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addMultimediaRequestCreation(String hotelIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimedia' is set
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling addMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> addMultimedia(String hotelIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> addMultimediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return addMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, simpleMultimedia, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Multimedia
     * Uploads a videos and/or images to an add-on identified by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Add multimedia record to add-on record owned by this hotel identifier
     * @param addOnIdentifier Add multimedia record to add-on with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addMultimediaWithResponseSpec(String hotelIdentifier, String addOnIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        return addMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, simpleMultimedia, winkVersion);
    }
    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAddOnRequestCreation(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling createAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> createAddOn(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(hotelIdentifier, upsertAddOnRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> createAddOnWithHttpInfo(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return createAddOnRequestCreation(hotelIdentifier, upsertAddOnRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Add-On
     * Create a new add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new add-on record owned by this hotel identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAddOnWithResponseSpec(String hotelIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        return createAddOnRequestCreation(hotelIdentifier, upsertAddOnRequest, winkVersion);
    }
    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAddOn(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Add-On
     * Delete an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove add-on record owned by this hotel identifier
     * @param addOnIdentifier Remove add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAddOnWithResponseSpec(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        return removeAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion);
    }
    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia1RequestCreation(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> removeMultimedia1(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimedia1RequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> removeMultimedia1WithHttpInfo(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return removeMultimedia1RequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing add-on owned by this hotel identifier.
     * @param addOnIdentifier Remove a media record from an existing add-on identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimedia1WithResponseSpec(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMultimedia1RequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, winkVersion);
    }
    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> showAddOn(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> showAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On
     * Retrieve an add-on by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single add-on owned by this hotel identifier
     * @param addOnIdentifier Show add-on record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAddOnWithResponseSpec(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        return showAddOnRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion);
    }
    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOns", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<UpgradeView> showAddOns(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;UpgradeView&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<UpgradeView>>> showAddOnsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return showAddOnsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Add-Ons
     * Retrieve a list of all add-ons for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show add-ons owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAddOnsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showAddOnsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnRequestCreation(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddOnRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddOnRequest' is set
        if (upsertAddOnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddOnRequest' when calling updateAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOn(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(hotelIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> updateAddOnWithHttpInfo(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnRequestCreation(hotelIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Add-On
     * Update an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing add-on record owned by this hotel identifier
     * @param addOnIdentifier Update an existing add-on record identified by this identifier
     * @param upsertAddOnRequest The upsertAddOnRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAddOnWithResponseSpec(String hotelIdentifier, String addOnIdentifier, UpsertAddOnRequest upsertAddOnRequest, String winkVersion) throws WebClientResponseException {
        return updateAddOnRequestCreation(hotelIdentifier, addOnIdentifier, upsertAddOnRequest, winkVersion);
    }
    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAddOnMultimediaRequestCreation(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        Object postBody = simpleMultimedia;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'simpleMultimedia' is set
        if (simpleMultimedia == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimedia' when calling updateAddOnMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> updateAddOnMultimedia(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> updateAddOnMultimediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return updateAddOnMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Multimedia
     * Update media meta data for a specific package media entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing multimedia record on add-on record owned by this hotel identifier
     * @param addOnIdentifier Update existing multimedia record on add-on with this identifier
     * @param multimediaIdentifier Update existing multimedia record with this identifier
     * @param simpleMultimedia The simpleMultimedia parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAddOnMultimediaWithResponseSpec(String hotelIdentifier, String addOnIdentifier, String multimediaIdentifier, SimpleMultimedia simpleMultimedia, String winkVersion) throws WebClientResponseException {
        return updateAddOnMultimediaRequestCreation(hotelIdentifier, addOnIdentifier, multimediaIdentifier, simpleMultimedia, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadBinaryAddOnMediaRequestCreation(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadBinaryAddOnMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/upgrade/{addOnIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return UpgradeView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpgradeView> uploadBinaryAddOnMedia(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(hotelIdentifier, addOnIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;UpgradeView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpgradeView>> uploadBinaryAddOnMediaWithHttpInfo(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<UpgradeView> localVarReturnType = new ParameterizedTypeReference<UpgradeView>() {};
        return uploadBinaryAddOnMediaRequestCreation(hotelIdentifier, addOnIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing add-on.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing add-on owned by this hotel identifier
     * @param addOnIdentifier Upload multipart files and associate them with an existing add-on with this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadBinaryAddOnMediaWithResponseSpec(String hotelIdentifier, String addOnIdentifier, List<File> files) throws WebClientResponseException {
        return uploadBinaryAddOnMediaRequestCreation(hotelIdentifier, addOnIdentifier, files);
    }
}
