package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.InventoryUsageSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-08T09:23:20.721546517+07:00[Asia/Bangkok]")
public class InventoryUsageApi {
    private ApiClient apiClient;

    public InventoryUsageApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryUsageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Activity Usage
     * Retrieve an aggregate report where specified activity is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param activityIdentifier Activity identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showActivityUsageRequestCreation(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'activityIdentifier' is set
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/activity/{activityIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity Usage
     * Retrieve an aggregate report where specified activity is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param activityIdentifier Activity identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showActivityUsage(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Activity Usage
     * Retrieve an aggregate report where specified activity is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param activityIdentifier Activity identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showActivityUsageWithHttpInfo(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Activity Usage
     * Retrieve an aggregate report where specified activity is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param activityIdentifier Activity identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showActivityUsageWithResponseSpec(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        return showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion);
    }
    /**
     * Show Add-On Usage
     * Retrieve an aggregate report where specified add-on is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param addOnIdentifier Add-On identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAddOnUsageRequestCreation(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addOnIdentifier' is set
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/add-on/{addOnIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On Usage
     * Retrieve an aggregate report where specified add-on is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param addOnIdentifier Add-On identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showAddOnUsage(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On Usage
     * Retrieve an aggregate report where specified add-on is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param addOnIdentifier Add-On identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showAddOnUsageWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On Usage
     * Retrieve an aggregate report where specified add-on is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param addOnIdentifier Add-On identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAddOnUsageWithResponseSpec(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        return showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion);
    }
    /**
     * Show Attraction Usage
     * Retrieve an aggregate report where specified attraction is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param attractionIdentifier Attraction identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAttractionUsageRequestCreation(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'attractionIdentifier' is set
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/attraction/{attractionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction Usage
     * Retrieve an aggregate report where specified attraction is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param attractionIdentifier Attraction identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showAttractionUsage(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Attraction Usage
     * Retrieve an aggregate report where specified attraction is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param attractionIdentifier Attraction identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showAttractionUsageWithHttpInfo(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Attraction Usage
     * Retrieve an aggregate report where specified attraction is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param attractionIdentifier Attraction identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAttractionUsageWithResponseSpec(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        return showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion);
    }
    /**
     * Show Meeting Room Usage
     * Retrieve an aggregate report where specified meeting room is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param meetingRoomIdentifier Meeting room identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomUsageRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/meeting-room/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room Usage
     * Retrieve an aggregate report where specified meeting room is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param meetingRoomIdentifier Meeting room identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showMeetingRoomUsage(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Meeting Room Usage
     * Retrieve an aggregate report where specified meeting room is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param meetingRoomIdentifier Meeting room identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showMeetingRoomUsageWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Meeting Room Usage
     * Retrieve an aggregate report where specified meeting room is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param meetingRoomIdentifier Meeting room identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMeetingRoomUsageWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion);
    }
    /**
     * Show Place Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param placeIdentifier Place identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPlaceUsageRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'placeIdentifier' is set
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/place/{placeIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param placeIdentifier Place identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showPlaceUsage(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Place Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param placeIdentifier Place identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showPlaceUsageWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Place Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param placeIdentifier Place identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPlaceUsageWithResponseSpec(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        return showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion);
    }
    /**
     * Show Rate Plan Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param ratePlanIdentifier Rate plan identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRatePlanUsageRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ratePlanIdentifier' is set
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/rate-plan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Rate Plan Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param ratePlanIdentifier Rate plan identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showRatePlanUsage(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Rate Plan Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param ratePlanIdentifier Rate plan identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showRatePlanUsageWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Rate Plan Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param ratePlanIdentifier Rate plan identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRatePlanUsageWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }
    /**
     * Show Restaurant Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param restaurantIdentifier Restaurant identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRestaurantUsageRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param restaurantIdentifier Restaurant identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showRestaurantUsage(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Restaurant Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param restaurantIdentifier Restaurant identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showRestaurantUsageWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Restaurant Usage
     * Retrieve an aggregate report where specified rate plan is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param restaurantIdentifier Restaurant identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRestaurantUsageWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        return showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion);
    }
    /**
     * Show Room Type Usage
     * Retrieve an aggregate report where specified room type is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param roomTypeIdentifier Room type identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRoomTypeUsageRequestCreation(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'roomTypeIdentifier' is set
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/room-type/{roomTypeIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Room Type Usage
     * Retrieve an aggregate report where specified room type is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param roomTypeIdentifier Room type identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showRoomTypeUsage(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Room Type Usage
     * Retrieve an aggregate report where specified room type is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param roomTypeIdentifier Room type identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showRoomTypeUsageWithHttpInfo(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Room Type Usage
     * Retrieve an aggregate report where specified room type is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param roomTypeIdentifier Room type identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRoomTypeUsageWithResponseSpec(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        return showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion);
    }
    /**
     * Show Spa Usage
     * Retrieve an aggregate report where specified spa is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param spaIdentifier Spa identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSpaUsageRequestCreation(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'spaIdentifier' is set
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/spa/{spaIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Spa Usage
     * Retrieve an aggregate report where specified spa is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param spaIdentifier Spa identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryUsageSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUsageSupplier> showSpaUsage(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Spa Usage
     * Retrieve an aggregate report where specified spa is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param spaIdentifier Spa identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUsageSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUsageSupplier>> showSpaUsageWithHttpInfo(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>() {};
        return showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Spa Usage
     * Retrieve an aggregate report where specified spa is being used on affiliate real estate.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Hotel identifier inventory owner
     * @param spaIdentifier Spa identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSpaUsageWithResponseSpec(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        return showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion);
    }
}
