package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.MeetingRoomViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertMeetingRoomRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-08T09:23:20.721546517+07:00[Asia/Bangkok]")
public class MeetingRoomApi {
    private ApiClient apiClient;

    public MeetingRoomApi() {
        this(new ApiClient());
    }

    @Autowired
    public MeetingRoomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMeetingRoomRequestCreation(String hotelIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertMeetingRoomRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertMeetingRoomRequestSupplier' is set
        if (upsertMeetingRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequestSupplier' when calling createMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomViewSupplier> createMeetingRoom(String hotelIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MeetingRoomViewSupplier>> createMeetingRoomWithHttpInfo(String hotelIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Meeting Room
     * Create a new meeting room
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new meeting room record and associate it with this hotel identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createMeetingRoomWithResponseSpec(String hotelIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createMeetingRoomRequestCreation(hotelIdentifier, upsertMeetingRoomRequestSupplier, winkVersion);
    }
    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Meeting Room
     * Remove a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove meeting room with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMeetingRoomWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion);
    }
    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia4RequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia4", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomViewSupplier> removeMultimedia4(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MeetingRoomViewSupplier>> removeMultimedia4WithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove a meeting room&#39;s video or image by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Remove media for meeting room with this identifier
     * @param multimediaIdentifier Remove media with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimedia4WithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMultimedia4RequestCreation(hotelIdentifier, meetingRoomIdentifier, multimediaIdentifier, winkVersion);
    }
    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomViewSupplier> showMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MeetingRoomViewSupplier>> showMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Retrieve a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show a single meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Show meeting room for identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMeetingRoomWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return showMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion);
    }
    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomPairsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoomPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showMeetingRoomPairs(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showMeetingRoomPairsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showMeetingRoomPairsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showMeetingRoomPairsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of meeting rooms as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting room key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMeetingRoomPairsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showMeetingRoomPairsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMeetingRoomsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRooms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MeetingRoomViewSupplier> showMeetingRooms(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return showMeetingRoomsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;MeetingRoomViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MeetingRoomViewSupplier>>> showMeetingRoomsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return showMeetingRoomsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Meeting Rooms
     * Retrieve list of meeting rooms
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show meeting rooms associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMeetingRoomsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showMeetingRoomsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMeetingRoomRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertMeetingRoomRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertMeetingRoomRequestSupplier' is set
        if (upsertMeetingRoomRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertMeetingRoomRequestSupplier' when calling updateMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomViewSupplier> updateMeetingRoom(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MeetingRoomViewSupplier>> updateMeetingRoomWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Meeting Room
     * Update a meeting room by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update a meeting room owned by this hotel identifier
     * @param meetingRoomIdentifier Update meeting room with this identifier
     * @param upsertMeetingRoomRequestSupplier The upsertMeetingRoomRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMeetingRoomWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, UpsertMeetingRoomRequestSupplier upsertMeetingRoomRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateMeetingRoomRequestCreation(hotelIdentifier, meetingRoomIdentifier, upsertMeetingRoomRequestSupplier, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadMeetingRoomMediaRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'meetingRoomIdentifier' is set
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMeetingRoomMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/meetingroom/{meetingRoomIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return MeetingRoomViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MeetingRoomViewSupplier> uploadMeetingRoomMedia(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;MeetingRoomViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MeetingRoomViewSupplier>> uploadMeetingRoomMediaWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MeetingRoomViewSupplier> localVarReturnType = new ParameterizedTypeReference<MeetingRoomViewSupplier>() {};
        return uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to a meeting room identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload binary media for meeting room associated with this hotel identifier
     * @param meetingRoomIdentifier Upload binary media for meeting room with this hotel identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadMeetingRoomMediaWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, List<File> files) throws WebClientResponseException {
        return uploadMeetingRoomMediaRequestCreation(hotelIdentifier, meetingRoomIdentifier, files);
    }
}
