/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.62.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.LocalizedDescriptionSupplier;
import travel.wink.sdk.extranet.model.RateModifierSupplier;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotion ancillary data object
 */
@JsonPropertyOrder({
  RateModifierBundleSupplier.JSON_PROPERTY_IDENTIFIER,
  RateModifierBundleSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierBundleSupplier.JSON_PROPERTY_NAME,
  RateModifierBundleSupplier.JSON_PROPERTY_ENABLED,
  RateModifierBundleSupplier.JSON_PROPERTY_ITEMS,
  RateModifierBundleSupplier.JSON_PROPERTY_MODIFIER_OVERRIDE,
  RateModifierBundleSupplier.JSON_PROPERTY_TYPE,
  RateModifierBundleSupplier.JSON_PROPERTY_PRICING_TYPE,
  RateModifierBundleSupplier.JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER,
  RateModifierBundleSupplier.JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER,
  RateModifierBundleSupplier.JSON_PROPERTY_IS_VALID,
  RateModifierBundleSupplier.JSON_PROPERTY_DESCRIPTION
})
@JsonTypeName("RateModifierBundle_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-08T09:23:20.721546517+07:00[Asia/Bangkok]")
public class RateModifierBundleSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<RateModifierSupplier> items = new ArrayList<>();

  public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
  private VariableChargeSupplier modifierOverride;

  /**
   * Required if manual override modifier is not null
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER = "hasPercentDiscountModifier";
  private Boolean hasPercentDiscountModifier;

  public static final String JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER = "hasFixedDiscountModifier";
  private Boolean hasFixedDiscountModifier;

  public static final String JSON_PROPERTY_IS_VALID = "isValid";
  private Boolean isValid;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private List<LocalizedDescriptionSupplier> description;

  public RateModifierBundleSupplier() {
  }

  public RateModifierBundleSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierBundleSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierBundleSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion ancillary.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierBundleSupplier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion ancillary is enabled or not.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public RateModifierBundleSupplier items(List<RateModifierSupplier> items) {
    
    this.items = items;
    return this;
  }

  public RateModifierBundleSupplier addItemsItem(RateModifierSupplier itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Get items
   * @return items
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RateModifierSupplier> getItems() {
    return items;
  }


  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItems(List<RateModifierSupplier> items) {
    this.items = items;
  }


  public RateModifierBundleSupplier modifierOverride(VariableChargeSupplier modifierOverride) {
    
    this.modifierOverride = modifierOverride;
    return this;
  }

   /**
   * Get modifierOverride
   * @return modifierOverride
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getModifierOverride() {
    return modifierOverride;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setModifierOverride(VariableChargeSupplier modifierOverride) {
    this.modifierOverride = modifierOverride;
  }


  public RateModifierBundleSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Required if manual override modifier is not null
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierBundleSupplier pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   * @return pricingType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierBundleSupplier hasPercentDiscountModifier(Boolean hasPercentDiscountModifier) {
    
    this.hasPercentDiscountModifier = hasPercentDiscountModifier;
    return this;
  }

   /**
   * Get hasPercentDiscountModifier
   * @return hasPercentDiscountModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPercentDiscountModifier() {
    return hasPercentDiscountModifier;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPercentDiscountModifier(Boolean hasPercentDiscountModifier) {
    this.hasPercentDiscountModifier = hasPercentDiscountModifier;
  }


  public RateModifierBundleSupplier hasFixedDiscountModifier(Boolean hasFixedDiscountModifier) {
    
    this.hasFixedDiscountModifier = hasFixedDiscountModifier;
    return this;
  }

   /**
   * Get hasFixedDiscountModifier
   * @return hasFixedDiscountModifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFixedDiscountModifier() {
    return hasFixedDiscountModifier;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFixedDiscountModifier(Boolean hasFixedDiscountModifier) {
    this.hasFixedDiscountModifier = hasFixedDiscountModifier;
  }


  public RateModifierBundleSupplier isValid(Boolean isValid) {
    
    this.isValid = isValid;
    return this;
  }

   /**
   * Get isValid
   * @return isValid
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsValid() {
    return isValid;
  }


  @JsonProperty(JSON_PROPERTY_IS_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsValid(Boolean isValid) {
    this.isValid = isValid;
  }


  public RateModifierBundleSupplier description(List<LocalizedDescriptionSupplier> description) {
    
    this.description = description;
    return this;
  }

  public RateModifierBundleSupplier addDescriptionItem(LocalizedDescriptionSupplier descriptionItem) {
    if (this.description == null) {
      this.description = new ArrayList<>();
    }
    this.description.add(descriptionItem);
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplier> getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(List<LocalizedDescriptionSupplier> description) {
    this.description = description;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierBundleSupplier rateModifierBundleSupplier = (RateModifierBundleSupplier) o;
    return Objects.equals(this.identifier, rateModifierBundleSupplier.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierBundleSupplier.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierBundleSupplier.name) &&
        Objects.equals(this.enabled, rateModifierBundleSupplier.enabled) &&
        Objects.equals(this.items, rateModifierBundleSupplier.items) &&
        Objects.equals(this.modifierOverride, rateModifierBundleSupplier.modifierOverride) &&
        Objects.equals(this.type, rateModifierBundleSupplier.type) &&
        Objects.equals(this.pricingType, rateModifierBundleSupplier.pricingType) &&
        Objects.equals(this.hasPercentDiscountModifier, rateModifierBundleSupplier.hasPercentDiscountModifier) &&
        Objects.equals(this.hasFixedDiscountModifier, rateModifierBundleSupplier.hasFixedDiscountModifier) &&
        Objects.equals(this.isValid, rateModifierBundleSupplier.isValid) &&
        Objects.equals(this.description, rateModifierBundleSupplier.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, enabled, items, modifierOverride, type, pricingType, hasPercentDiscountModifier, hasFixedDiscountModifier, isValid, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierBundleSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    modifierOverride: ").append(toIndentedString(modifierOverride)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    hasPercentDiscountModifier: ").append(toIndentedString(hasPercentDiscountModifier)).append("\n");
    sb.append("    hasFixedDiscountModifier: ").append(toIndentedString(hasFixedDiscountModifier)).append("\n");
    sb.append("    isValid: ").append(toIndentedString(isValid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

