/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.HotelViewSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;

public class MediaApi {
    private ApiClient apiClient;

    public MediaApi() {
        this(new ApiClient());
    }

    @Autowired
    public MediaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createMultimediaRequestCreation(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        SimpleMultimediaSupplier postBody = simpleMultimediaSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling createMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> createMultimedia(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> createMultimediaWithHttpInfo(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createMultimediaWithResponseSpec(String hotelIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return this.createMultimediaRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeMediaListRequestCreation(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifiers == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifiers' when calling removeMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "multimediaIdentifiers", multimediaIdentifiers));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/list", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> removeMediaList(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> removeMediaListWithHttpInfo(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMediaListWithResponseSpec(String hotelIdentifier, List<String> multimediaIdentifiers, String winkVersion) throws WebClientResponseException {
        return this.removeMediaListRequestCreation(hotelIdentifier, multimediaIdentifiers, winkVersion);
    }

    private WebClient.ResponseSpec removeMultimediaRequestCreation(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> removeMultimedia(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> removeMultimediaWithHttpInfo(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeMultimediaWithResponseSpec(String hotelIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showMediaListRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaSupplier> showMediaList(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.showMediaListRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaSupplier>>> showMediaListWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaSupplier> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaSupplier>(this){};
        return this.showMediaListRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMediaListWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showMediaListRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateMediaListRequestCreation(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        List<SimpleMultimediaSupplier> postBody = simpleMultimediaSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMediaList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateMediaList(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateMediaListWithHttpInfo(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMediaListWithResponseSpec(String hotelIdentifier, List<SimpleMultimediaSupplier> simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateMediaListRequestCreation(hotelIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec updateMultimediaRequestCreation(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        SimpleMultimediaSupplier postBody = simpleMultimediaSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (simpleMultimediaSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'simpleMultimediaSupplier' when calling updateMultimedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> updateMultimedia(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> updateMultimediaWithHttpInfo(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateMultimediaWithResponseSpec(String hotelIdentifier, String multimediaIdentifier, SimpleMultimediaSupplier simpleMultimediaSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateMultimediaRequestCreation(hotelIdentifier, multimediaIdentifier, simpleMultimediaSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadMultipartFilesRequestCreation(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadMultipartFiles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadMultipartFiles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/multimedia/upload", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> uploadMultipartFiles(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.uploadMultipartFilesRequestCreation(hotelIdentifier, files).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> uploadMultipartFilesWithHttpInfo(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(this){};
        return this.uploadMultipartFilesRequestCreation(hotelIdentifier, files).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadMultipartFilesWithResponseSpec(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadMultipartFilesRequestCreation(hotelIdentifier, files);
    }
}

