/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.SalesChannelRelationshipRequestViewSupplier;
import travel.wink.sdk.extranet.model.UpsertSalesChannelRelationshipRequestRequestSupplier;

public class SalesChannelRelationshipRequestsApi {
    private ApiClient apiClient;

    public SalesChannelRelationshipRequestsApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelRelationshipRequestsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSalesChannelRequestRequestCreation(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertSalesChannelRelationshipRequestRequestSupplier postBody = upsertSalesChannelRelationshipRequestRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSalesChannelRelationshipRequestRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRelationshipRequestRequestSupplier' when calling createSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestViewSupplier> createSalesChannelRequest(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestViewSupplier>> createSalesChannelRequestWithHttpInfo(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSalesChannelRequestWithResponseSpec(String hotelIdentifier, UpsertSalesChannelRelationshipRequestRequestSupplier upsertSalesChannelRelationshipRequestRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createSalesChannelRequestRequestCreation(hotelIdentifier, upsertSalesChannelRelationshipRequestRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeSalesChannelRequestRequestCreation(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSalesChannelRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestViewSupplier> removeSalesChannelRequest(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestViewSupplier>> removeSalesChannelRequestWithHttpInfo(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSalesChannelRequestWithResponseSpec(String hotelIdentifier, String salesChannelRequestIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeSalesChannelRequestRequestCreation(hotelIdentifier, salesChannelRequestIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSalesChannelRequestsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSalesChannelRequests", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/request/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelRelationshipRequestViewSupplier> showSalesChannelRequests(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelRelationshipRequestViewSupplier>>> showSalesChannelRequestsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewSupplier>(this){};
        return this.showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelRequestsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSalesChannelRequestsRequestCreation(hotelIdentifier, winkVersion);
    }
}

