/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.extranet.model.InvoiceLineItemPeriodSupplier;
import travel.wink.sdk.extranet.model.PlanSupplier;
import travel.wink.sdk.extranet.model.PriceSupplier;
import travel.wink.sdk.extranet.model.TaxAmountSupplier;
import travel.wink.sdk.extranet.model.TaxRateSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InvoiceLineItemSupplier
 */
@JsonPropertyOrder({
  InvoiceLineItemSupplier.JSON_PROPERTY_AMOUNT,
  InvoiceLineItemSupplier.JSON_PROPERTY_CURRENCY,
  InvoiceLineItemSupplier.JSON_PROPERTY_DESCRIPTION,
  InvoiceLineItemSupplier.JSON_PROPERTY_DISCOUNTABLE,
  InvoiceLineItemSupplier.JSON_PROPERTY_ID,
  InvoiceLineItemSupplier.JSON_PROPERTY_INVOICE_ITEM,
  InvoiceLineItemSupplier.JSON_PROPERTY_LIVEMODE,
  InvoiceLineItemSupplier.JSON_PROPERTY_METADATA,
  InvoiceLineItemSupplier.JSON_PROPERTY_OBJECT,
  InvoiceLineItemSupplier.JSON_PROPERTY_PERIOD,
  InvoiceLineItemSupplier.JSON_PROPERTY_PLAN,
  InvoiceLineItemSupplier.JSON_PROPERTY_PRICE,
  InvoiceLineItemSupplier.JSON_PROPERTY_PRORATION,
  InvoiceLineItemSupplier.JSON_PROPERTY_QUANTITY,
  InvoiceLineItemSupplier.JSON_PROPERTY_SUBSCRIPTION,
  InvoiceLineItemSupplier.JSON_PROPERTY_SUBSCRIPTION_ITEM,
  InvoiceLineItemSupplier.JSON_PROPERTY_TAX_AMOUNTS,
  InvoiceLineItemSupplier.JSON_PROPERTY_TAX_RATES,
  InvoiceLineItemSupplier.JSON_PROPERTY_TYPE
})
@JsonTypeName("InvoiceLineItem_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T17:00:54.890892627+07:00[Asia/Bangkok]")
public class InvoiceLineItemSupplier {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISCOUNTABLE = "discountable";
  private Boolean discountable;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INVOICE_ITEM = "invoiceItem";
  private String invoiceItem;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PERIOD = "period";
  private InvoiceLineItemPeriodSupplier period;

  public static final String JSON_PROPERTY_PLAN = "plan";
  private PlanSupplier plan;

  public static final String JSON_PROPERTY_PRICE = "price";
  private PriceSupplier price;

  public static final String JSON_PROPERTY_PRORATION = "proration";
  private Boolean proration;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity;

  public static final String JSON_PROPERTY_SUBSCRIPTION = "subscription";
  private String subscription;

  public static final String JSON_PROPERTY_SUBSCRIPTION_ITEM = "subscriptionItem";
  private String subscriptionItem;

  public static final String JSON_PROPERTY_TAX_AMOUNTS = "taxAmounts";
  private List<TaxAmountSupplier> taxAmounts;

  public static final String JSON_PROPERTY_TAX_RATES = "taxRates";
  private List<TaxRateSupplier> taxRates;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public InvoiceLineItemSupplier() {
  }

  public InvoiceLineItemSupplier amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public InvoiceLineItemSupplier currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public InvoiceLineItemSupplier description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public InvoiceLineItemSupplier discountable(Boolean discountable) {
    
    this.discountable = discountable;
    return this;
  }

   /**
   * Get discountable
   * @return discountable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDiscountable() {
    return discountable;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscountable(Boolean discountable) {
    this.discountable = discountable;
  }


  public InvoiceLineItemSupplier id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public InvoiceLineItemSupplier invoiceItem(String invoiceItem) {
    
    this.invoiceItem = invoiceItem;
    return this;
  }

   /**
   * Get invoiceItem
   * @return invoiceItem
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVOICE_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInvoiceItem() {
    return invoiceItem;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoiceItem(String invoiceItem) {
    this.invoiceItem = invoiceItem;
  }


  public InvoiceLineItemSupplier livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public InvoiceLineItemSupplier metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public InvoiceLineItemSupplier putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public InvoiceLineItemSupplier _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public InvoiceLineItemSupplier period(InvoiceLineItemPeriodSupplier period) {
    
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceLineItemPeriodSupplier getPeriod() {
    return period;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriod(InvoiceLineItemPeriodSupplier period) {
    this.period = period;
  }


  public InvoiceLineItemSupplier plan(PlanSupplier plan) {
    
    this.plan = plan;
    return this;
  }

   /**
   * Get plan
   * @return plan
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlanSupplier getPlan() {
    return plan;
  }


  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlan(PlanSupplier plan) {
    this.plan = plan;
  }


  public InvoiceLineItemSupplier price(PriceSupplier price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriceSupplier getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(PriceSupplier price) {
    this.price = price;
  }


  public InvoiceLineItemSupplier proration(Boolean proration) {
    
    this.proration = proration;
    return this;
  }

   /**
   * Get proration
   * @return proration
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getProration() {
    return proration;
  }


  @JsonProperty(JSON_PROPERTY_PRORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProration(Boolean proration) {
    this.proration = proration;
  }


  public InvoiceLineItemSupplier quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public InvoiceLineItemSupplier subscription(String subscription) {
    
    this.subscription = subscription;
    return this;
  }

   /**
   * Get subscription
   * @return subscription
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubscription() {
    return subscription;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscription(String subscription) {
    this.subscription = subscription;
  }


  public InvoiceLineItemSupplier subscriptionItem(String subscriptionItem) {
    
    this.subscriptionItem = subscriptionItem;
    return this;
  }

   /**
   * Get subscriptionItem
   * @return subscriptionItem
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubscriptionItem() {
    return subscriptionItem;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionItem(String subscriptionItem) {
    this.subscriptionItem = subscriptionItem;
  }


  public InvoiceLineItemSupplier taxAmounts(List<TaxAmountSupplier> taxAmounts) {
    
    this.taxAmounts = taxAmounts;
    return this;
  }

  public InvoiceLineItemSupplier addTaxAmountsItem(TaxAmountSupplier taxAmountsItem) {
    if (this.taxAmounts == null) {
      this.taxAmounts = new ArrayList<>();
    }
    this.taxAmounts.add(taxAmountsItem);
    return this;
  }

   /**
   * Get taxAmounts
   * @return taxAmounts
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxAmountSupplier> getTaxAmounts() {
    return taxAmounts;
  }


  @JsonProperty(JSON_PROPERTY_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxAmounts(List<TaxAmountSupplier> taxAmounts) {
    this.taxAmounts = taxAmounts;
  }


  public InvoiceLineItemSupplier taxRates(List<TaxRateSupplier> taxRates) {
    
    this.taxRates = taxRates;
    return this;
  }

  public InvoiceLineItemSupplier addTaxRatesItem(TaxRateSupplier taxRatesItem) {
    if (this.taxRates == null) {
      this.taxRates = new ArrayList<>();
    }
    this.taxRates.add(taxRatesItem);
    return this;
  }

   /**
   * Get taxRates
   * @return taxRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxRateSupplier> getTaxRates() {
    return taxRates;
  }


  @JsonProperty(JSON_PROPERTY_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxRates(List<TaxRateSupplier> taxRates) {
    this.taxRates = taxRates;
  }


  public InvoiceLineItemSupplier type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLineItemSupplier invoiceLineItemSupplier = (InvoiceLineItemSupplier) o;
    return Objects.equals(this.amount, invoiceLineItemSupplier.amount) &&
        Objects.equals(this.currency, invoiceLineItemSupplier.currency) &&
        Objects.equals(this.description, invoiceLineItemSupplier.description) &&
        Objects.equals(this.discountable, invoiceLineItemSupplier.discountable) &&
        Objects.equals(this.id, invoiceLineItemSupplier.id) &&
        Objects.equals(this.invoiceItem, invoiceLineItemSupplier.invoiceItem) &&
        Objects.equals(this.livemode, invoiceLineItemSupplier.livemode) &&
        Objects.equals(this.metadata, invoiceLineItemSupplier.metadata) &&
        Objects.equals(this._object, invoiceLineItemSupplier._object) &&
        Objects.equals(this.period, invoiceLineItemSupplier.period) &&
        Objects.equals(this.plan, invoiceLineItemSupplier.plan) &&
        Objects.equals(this.price, invoiceLineItemSupplier.price) &&
        Objects.equals(this.proration, invoiceLineItemSupplier.proration) &&
        Objects.equals(this.quantity, invoiceLineItemSupplier.quantity) &&
        Objects.equals(this.subscription, invoiceLineItemSupplier.subscription) &&
        Objects.equals(this.subscriptionItem, invoiceLineItemSupplier.subscriptionItem) &&
        Objects.equals(this.taxAmounts, invoiceLineItemSupplier.taxAmounts) &&
        Objects.equals(this.taxRates, invoiceLineItemSupplier.taxRates) &&
        Objects.equals(this.type, invoiceLineItemSupplier.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency, description, discountable, id, invoiceItem, livemode, metadata, _object, period, plan, price, proration, quantity, subscription, subscriptionItem, taxAmounts, taxRates, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLineItemSupplier {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    discountable: ").append(toIndentedString(discountable)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceItem: ").append(toIndentedString(invoiceItem)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    plan: ").append(toIndentedString(plan)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    proration: ").append(toIndentedString(proration)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    subscription: ").append(toIndentedString(subscription)).append("\n");
    sb.append("    subscriptionItem: ").append(toIndentedString(subscriptionItem)).append("\n");
    sb.append("    taxAmounts: ").append(toIndentedString(taxAmounts)).append("\n");
    sb.append("    taxRates: ").append(toIndentedString(taxRates)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

