/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.64.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PropertyBookingRefundRequestSupplier
 */
@JsonPropertyOrder({
  PropertyBookingRefundRequestSupplier.JSON_PROPERTY_TYPE,
  PropertyBookingRefundRequestSupplier.JSON_PROPERTY_DESCRIPTION,
  PropertyBookingRefundRequestSupplier.JSON_PROPERTY_REFUND,
  PropertyBookingRefundRequestSupplier.JSON_PROPERTY_CANCEL_ON_REFUND
})
@JsonTypeName("PropertyBookingRefundRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:18:42.794855426+07:00[Asia/Bangkok]")
public class PropertyBookingRefundRequestSupplier {
  /**
   * Type of reason
   */
  public enum TypeEnum {
    DUPLICATE("DUPLICATE"),
    
    FRAUDULENT("FRAUDULENT"),
    
    REQUESTED_BY_CUSTOMER("REQUESTED_BY_CUSTOMER"),
    
    GUEST_COMPLAINT("GUEST_COMPLAINT"),
    
    GUEST_BOOKED_INCORRECT_DATE("GUEST_BOOKED_INCORRECT_DATE"),
    
    GUEST_SICK("GUEST_SICK"),
    
    OVERBOOKING("OVERBOOKING"),
    
    EMERGENCY("EMERGENCY"),
    
    FLIGHT_CANCELLED("FLIGHT_CANCELLED"),
    
    DEATH_IN_FAMILY("DEATH_IN_FAMILY"),
    
    OTHER("OTHER"),
    
    EXPIRED_UNCAPTURED_CHARGE("EXPIRED_UNCAPTURED_CHARGE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_REFUND = "refund";
  private CustomMonetaryAmount refund;

  /**
   * Whether to cancel the booking alongside requesting a refund.
   */
  public enum CancelOnRefundEnum {
    NONE("NONE"),
    
    CANCEL_ON_SUCCESSFUL_REFUND("CANCEL_ON_SUCCESSFUL_REFUND"),
    
    CANCEL_REGARDLESS("CANCEL_REGARDLESS");

    private String value;

    CancelOnRefundEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancelOnRefundEnum fromValue(String value) {
      for (CancelOnRefundEnum b : CancelOnRefundEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCEL_ON_REFUND = "cancelOnRefund";
  private CancelOnRefundEnum cancelOnRefund;

  public PropertyBookingRefundRequestSupplier() {
  }

  public PropertyBookingRefundRequestSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of reason
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public PropertyBookingRefundRequestSupplier description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Textual description of why the refund is being requested
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public PropertyBookingRefundRequestSupplier refund(CustomMonetaryAmount refund) {
    
    this.refund = refund;
    return this;
  }

   /**
   * Get refund
   * @return refund
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getRefund() {
    return refund;
  }


  @JsonProperty(JSON_PROPERTY_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefund(CustomMonetaryAmount refund) {
    this.refund = refund;
  }


  public PropertyBookingRefundRequestSupplier cancelOnRefund(CancelOnRefundEnum cancelOnRefund) {
    
    this.cancelOnRefund = cancelOnRefund;
    return this;
  }

   /**
   * Whether to cancel the booking alongside requesting a refund.
   * @return cancelOnRefund
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancelOnRefundEnum getCancelOnRefund() {
    return cancelOnRefund;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_ON_REFUND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancelOnRefund(CancelOnRefundEnum cancelOnRefund) {
    this.cancelOnRefund = cancelOnRefund;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier = (PropertyBookingRefundRequestSupplier) o;
    return Objects.equals(this.type, propertyBookingRefundRequestSupplier.type) &&
        Objects.equals(this.description, propertyBookingRefundRequestSupplier.description) &&
        Objects.equals(this.refund, propertyBookingRefundRequestSupplier.refund) &&
        Objects.equals(this.cancelOnRefund, propertyBookingRefundRequestSupplier.cancelOnRefund);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, description, refund, cancelOnRefund);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyBookingRefundRequestSupplier {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    refund: ").append(toIndentedString(refund)).append("\n");
    sb.append("    cancelOnRefund: ").append(toIndentedString(cancelOnRefund)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

