/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.64.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.ReviewAnswerSupplierDetails;
import travel.wink.sdk.extranet.model.ReviewUserSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * User review created by the traveler after the booking completed.
 */
@JsonPropertyOrder({
  ReviewSupplierDetails.JSON_PROPERTY_IDENTIFIER,
  ReviewSupplierDetails.JSON_PROPERTY_BOOKING_IDENTIFIER,
  ReviewSupplierDetails.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ReviewSupplierDetails.JSON_PROPERTY_USER,
  ReviewSupplierDetails.JSON_PROPERTY_REVIEW_DATE,
  ReviewSupplierDetails.JSON_PROPERTY_AVERAGE_SCORE,
  ReviewSupplierDetails.JSON_PROPERTY_ANSWERS,
  ReviewSupplierDetails.JSON_PROPERTY_MESSAGE_FROM_GUEST,
  ReviewSupplierDetails.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  ReviewSupplierDetails.JSON_PROPERTY_IMAGE_IDENTIFIER,
  ReviewSupplierDetails.JSON_PROPERTY_TEXT,
  ReviewSupplierDetails.JSON_PROPERTY_APPROVED_TEXT,
  ReviewSupplierDetails.JSON_PROPERTY_APPROVED_IMAGE,
  ReviewSupplierDetails.JSON_PROPERTY_LIKES,
  ReviewSupplierDetails.JSON_PROPERTY_ROOM_NUMBER,
  ReviewSupplierDetails.JSON_PROPERTY_ROOM_RATING,
  ReviewSupplierDetails.JSON_PROPERTY_RESPONDED
})
@JsonTypeName("Review_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:18:42.794855426+07:00[Asia/Bangkok]")
public class ReviewSupplierDetails {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private UUID bookingIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_USER = "user";
  private ReviewUserSupplierDetails user;

  public static final String JSON_PROPERTY_REVIEW_DATE = "reviewDate";
  private java.time.LocalDateTime reviewDate;

  public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
  private java.math.BigDecimal averageScore;

  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<ReviewAnswerSupplierDetails> answers;

  public static final String JSON_PROPERTY_MESSAGE_FROM_GUEST = "messageFromGuest";
  private String messageFromGuest;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_APPROVED_TEXT = "approvedText";
  private Boolean approvedText;

  public static final String JSON_PROPERTY_APPROVED_IMAGE = "approvedImage";
  private Boolean approvedImage;

  public static final String JSON_PROPERTY_LIKES = "likes";
  private List<String> likes;

  public static final String JSON_PROPERTY_ROOM_NUMBER = "roomNumber";
  private String roomNumber;

  public static final String JSON_PROPERTY_ROOM_RATING = "roomRating";
  private Integer roomRating;

  public static final String JSON_PROPERTY_RESPONDED = "responded";
  private Boolean responded = false;

  public ReviewSupplierDetails() {
  }

  public ReviewSupplierDetails identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique review identifier identifying this record.
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public ReviewSupplierDetails bookingIdentifier(UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier identifier booking this review is associated with.
   * @return bookingIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingIdentifier(UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public ReviewSupplierDetails hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier this booking is associated with.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ReviewSupplierDetails user(ReviewUserSupplierDetails user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ReviewUserSupplierDetails getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(ReviewUserSupplierDetails user) {
    this.user = user;
  }


  public ReviewSupplierDetails reviewDate(java.time.LocalDateTime reviewDate) {
    
    this.reviewDate = reviewDate;
    return this;
  }

   /**
   * Date of review.
   * @return reviewDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReviewDate() {
    return reviewDate;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewDate(java.time.LocalDateTime reviewDate) {
    this.reviewDate = reviewDate;
  }


  public ReviewSupplierDetails averageScore(java.math.BigDecimal averageScore) {
    
    this.averageScore = averageScore;
    return this;
  }

   /**
   * Total points divided by number of questions.
   * @return averageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getAverageScore() {
    return averageScore;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageScore(java.math.BigDecimal averageScore) {
    this.averageScore = averageScore;
  }


  public ReviewSupplierDetails answers(List<ReviewAnswerSupplierDetails> answers) {
    
    this.answers = answers;
    return this;
  }

  public ReviewSupplierDetails addAnswersItem(ReviewAnswerSupplierDetails answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of user review answers.
   * @return answers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ReviewAnswerSupplierDetails> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswers(List<ReviewAnswerSupplierDetails> answers) {
    this.answers = answers;
  }


  public ReviewSupplierDetails messageFromGuest(String messageFromGuest) {
    
    this.messageFromGuest = messageFromGuest;
    return this;
  }

   /**
   * Private message from guest to the hotel. Is not displayed on property profile.
   * @return messageFromGuest
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromGuest() {
    return messageFromGuest;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_GUEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromGuest(String messageFromGuest) {
    this.messageFromGuest = messageFromGuest;
  }


  public ReviewSupplierDetails responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * Property can response to traveler review. Response goes on public review profile and can be seen by others.
   * @return responseFromHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public ReviewSupplierDetails imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public ReviewSupplierDetails text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return text
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public ReviewSupplierDetails approvedText(Boolean approvedText) {
    
    this.approvedText = approvedText;
    return this;
  }

   /**
   * Hotel allows the review text to be displayed as part of their profile.
   * @return approvedText
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedText() {
    return approvedText;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedText(Boolean approvedText) {
    this.approvedText = approvedText;
  }


  public ReviewSupplierDetails approvedImage(Boolean approvedImage) {
    
    this.approvedImage = approvedImage;
    return this;
  }

   /**
   * Hotel allows the user-generated image to be displayed as part of their profile.
   * @return approvedImage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getApprovedImage() {
    return approvedImage;
  }


  @JsonProperty(JSON_PROPERTY_APPROVED_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApprovedImage(Boolean approvedImage) {
    this.approvedImage = approvedImage;
  }


  public ReviewSupplierDetails likes(List<String> likes) {
    
    this.likes = likes;
    return this;
  }

  public ReviewSupplierDetails addLikesItem(String likesItem) {
    if (this.likes == null) {
      this.likes = new ArrayList<>();
    }
    this.likes.add(likesItem);
    return this;
  }

   /**
   * List of member identifiers who liked the textual review
   * @return likes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLikes() {
    return likes;
  }


  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLikes(List<String> likes) {
    this.likes = likes;
  }


  public ReviewSupplierDetails roomNumber(String roomNumber) {
    
    this.roomNumber = roomNumber;
    return this;
  }

   /**
   * Guest&#39;s room number during their stay.
   * @return roomNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomNumber() {
    return roomNumber;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomNumber(String roomNumber) {
    this.roomNumber = roomNumber;
  }


  public ReviewSupplierDetails roomRating(Integer roomRating) {
    
    this.roomRating = roomRating;
    return this;
  }

   /**
   * Guest&#39;s room rating
   * @return roomRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRoomRating() {
    return roomRating;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRating(Integer roomRating) {
    this.roomRating = roomRating;
  }


  public ReviewSupplierDetails responded(Boolean responded) {
    
    this.responded = responded;
    return this;
  }

   /**
   * Returns true if property has responded to the review given by the guest.
   * @return responded
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getResponded() {
    return responded;
  }


  @JsonProperty(JSON_PROPERTY_RESPONDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponded(Boolean responded) {
    this.responded = responded;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReviewSupplierDetails reviewSupplierDetails = (ReviewSupplierDetails) o;
    return Objects.equals(this.identifier, reviewSupplierDetails.identifier) &&
        Objects.equals(this.bookingIdentifier, reviewSupplierDetails.bookingIdentifier) &&
        Objects.equals(this.hotelIdentifier, reviewSupplierDetails.hotelIdentifier) &&
        Objects.equals(this.user, reviewSupplierDetails.user) &&
        Objects.equals(this.reviewDate, reviewSupplierDetails.reviewDate) &&
        Objects.equals(this.averageScore, reviewSupplierDetails.averageScore) &&
        Objects.equals(this.answers, reviewSupplierDetails.answers) &&
        Objects.equals(this.messageFromGuest, reviewSupplierDetails.messageFromGuest) &&
        Objects.equals(this.responseFromHotel, reviewSupplierDetails.responseFromHotel) &&
        Objects.equals(this.imageIdentifier, reviewSupplierDetails.imageIdentifier) &&
        Objects.equals(this.text, reviewSupplierDetails.text) &&
        Objects.equals(this.approvedText, reviewSupplierDetails.approvedText) &&
        Objects.equals(this.approvedImage, reviewSupplierDetails.approvedImage) &&
        Objects.equals(this.likes, reviewSupplierDetails.likes) &&
        Objects.equals(this.roomNumber, reviewSupplierDetails.roomNumber) &&
        Objects.equals(this.roomRating, reviewSupplierDetails.roomRating) &&
        Objects.equals(this.responded, reviewSupplierDetails.responded);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, bookingIdentifier, hotelIdentifier, user, reviewDate, averageScore, answers, messageFromGuest, responseFromHotel, imageIdentifier, text, approvedText, approvedImage, likes, roomNumber, roomRating, responded);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReviewSupplierDetails {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    reviewDate: ").append(toIndentedString(reviewDate)).append("\n");
    sb.append("    averageScore: ").append(toIndentedString(averageScore)).append("\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    messageFromGuest: ").append(toIndentedString(messageFromGuest)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    approvedText: ").append(toIndentedString(approvedText)).append("\n");
    sb.append("    approvedImage: ").append(toIndentedString(approvedImage)).append("\n");
    sb.append("    likes: ").append(toIndentedString(likes)).append("\n");
    sb.append("    roomNumber: ").append(toIndentedString(roomNumber)).append("\n");
    sb.append("    roomRating: ").append(toIndentedString(roomRating)).append("\n");
    sb.append("    responded: ").append(toIndentedString(responded)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

