/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.64.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ScheduleItemSupplier
 */
@JsonPropertyOrder({
  ScheduleItemSupplier.JSON_PROPERTY_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_START,
  ScheduleItemSupplier.JSON_PROPERTY_START_TIMEZONE,
  ScheduleItemSupplier.JSON_PROPERTY_END,
  ScheduleItemSupplier.JSON_PROPERTY_END_TIMEZONE,
  ScheduleItemSupplier.JSON_PROPERTY_IS_ALL_DAY,
  ScheduleItemSupplier.JSON_PROPERTY_TITLE,
  ScheduleItemSupplier.JSON_PROPERTY_DESCRIPTION,
  ScheduleItemSupplier.JSON_PROPERTY_RECURRENCE_RULE,
  ScheduleItemSupplier.JSON_PROPERTY_RECURRENCE_ID,
  ScheduleItemSupplier.JSON_PROPERTY_RECURRENCE_EXCEPTION,
  ScheduleItemSupplier.JSON_PROPERTY_OWNER_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_BOOKING_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_HOTEL_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_TYPE,
  ScheduleItemSupplier.JSON_PROPERTY_ATTENDEES,
  ScheduleItemSupplier.JSON_PROPERTY_EMAIL,
  ScheduleItemSupplier.JSON_PROPERTY_FULL_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_FIRST_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_LAST_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_VENUE_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_LOCALIZED_VENUE_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_CONTACT,
  ScheduleItemSupplier.JSON_PROPERTY_ADDRESS,
  ScheduleItemSupplier.JSON_PROPERTY_CREATED,
  ScheduleItemSupplier.JSON_PROPERTY_LAST_MODIFIED,
  ScheduleItemSupplier.JSON_PROPERTY_SEQUENCE,
  ScheduleItemSupplier.JSON_PROPERTY_BRAND_NAME,
  ScheduleItemSupplier.JSON_PROPERTY_EMAIL_HEADER_LOGO_URL,
  ScheduleItemSupplier.JSON_PROPERTY_LOGO_IDENTIFIER,
  ScheduleItemSupplier.JSON_PROPERTY_ALL_DAY
})
@JsonTypeName("ScheduleItem_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:18:42.794855426+07:00[Asia/Bangkok]")
public class ScheduleItemSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_START = "start";
  private java.time.LocalDateTime start;

  public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
  private String startTimezone;

  public static final String JSON_PROPERTY_END = "end";
  private java.time.LocalDateTime end;

  public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
  private String endTimezone;

  public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
  private Boolean isAllDay = false;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
  private String recurrenceRule;

  public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
  private String recurrenceId;

  public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
  private List<java.time.LocalDateTime> recurrenceException;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private UUID bookingIdentifier;

  public static final String JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER = "bookingOwnerIdentifier";
  private UUID bookingOwnerIdentifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  /**
   * The type of travel inventory.
   */
  public enum TypeEnum {
    ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_FULL_NAME = "fullName";
  private String fullName;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_VENUE_NAME = "venueName";
  private String venueName;

  public static final String JSON_PROPERTY_LOCALIZED_VENUE_NAME = "localizedVenueName";
  private String localizedVenueName;

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactSupplier contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_CREATED = "created";
  private java.time.LocalDateTime created;

  public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
  private java.time.LocalDateTime lastModified;

  public static final String JSON_PROPERTY_SEQUENCE = "sequence";
  private Long sequence = 0l;

  public static final String JSON_PROPERTY_BRAND_NAME = "brandName";
  private String brandName;

  public static final String JSON_PROPERTY_EMAIL_HEADER_LOGO_URL = "emailHeaderLogoUrl";
  private String emailHeaderLogoUrl;

  public static final String JSON_PROPERTY_LOGO_IDENTIFIER = "logoIdentifier";
  private String logoIdentifier;

  public static final String JSON_PROPERTY_ALL_DAY = "allDay";
  private Boolean allDay;

  public ScheduleItemSupplier() {
  }

  public ScheduleItemSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique schedule identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public ScheduleItemSupplier start(java.time.LocalDateTime start) {
    
    this.start = start;
    return this;
  }

   /**
   * Start date time of scheduled event
   * @return start
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStart(java.time.LocalDateTime start) {
    this.start = start;
  }


  public ScheduleItemSupplier startTimezone(String startTimezone) {
    
    this.startTimezone = startTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return startTimezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartTimezone() {
    return startTimezone;
  }


  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartTimezone(String startTimezone) {
    this.startTimezone = startTimezone;
  }


  public ScheduleItemSupplier end(java.time.LocalDateTime end) {
    
    this.end = end;
    return this;
  }

   /**
   * End date time of scheduled event
   * @return end
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getEnd() {
    return end;
  }


  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnd(java.time.LocalDateTime end) {
    this.end = end;
  }


  public ScheduleItemSupplier endTimezone(String endTimezone) {
    
    this.endTimezone = endTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return endTimezone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndTimezone() {
    return endTimezone;
  }


  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndTimezone(String endTimezone) {
    this.endTimezone = endTimezone;
  }


  public ScheduleItemSupplier isAllDay(Boolean isAllDay) {
    
    this.isAllDay = isAllDay;
    return this;
  }

   /**
   * Flag indicating whether this is an all day event.
   * @return isAllDay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsAllDay() {
    return isAllDay;
  }


  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsAllDay(Boolean isAllDay) {
    this.isAllDay = isAllDay;
  }


  public ScheduleItemSupplier title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * Title of scheduled event.
   * @return title
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public ScheduleItemSupplier description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description of scheduled event.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ScheduleItemSupplier recurrenceRule(String recurrenceRule) {
    
    this.recurrenceRule = recurrenceRule;
    return this;
  }

   /**
   * If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)
   * @return recurrenceRule
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceRule() {
    return recurrenceRule;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceRule(String recurrenceRule) {
    this.recurrenceRule = recurrenceRule;
  }


  public ScheduleItemSupplier recurrenceId(String recurrenceId) {
    
    this.recurrenceId = recurrenceId;
    return this;
  }

   /**
   * The parent ID of the recurring event.
   * @return recurrenceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceId() {
    return recurrenceId;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceId(String recurrenceId) {
    this.recurrenceId = recurrenceId;
  }


  public ScheduleItemSupplier recurrenceException(List<java.time.LocalDateTime> recurrenceException) {
    
    this.recurrenceException = recurrenceException;
    return this;
  }

  public ScheduleItemSupplier addRecurrenceExceptionItem(java.time.LocalDateTime recurrenceExceptionItem) {
    if (this.recurrenceException == null) {
      this.recurrenceException = new ArrayList<>();
    }
    this.recurrenceException.add(recurrenceExceptionItem);
    return this;
  }

   /**
   * Exceptions to the recurrence rule.
   * @return recurrenceException
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<java.time.LocalDateTime> getRecurrenceException() {
    return recurrenceException;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceException(List<java.time.LocalDateTime> recurrenceException) {
    this.recurrenceException = recurrenceException;
  }


  public ScheduleItemSupplier ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * The unique identifier of the travel inventory you are creating a scheduled event for.
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public ScheduleItemSupplier bookingIdentifier(UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier this scheduled event was created as part of.
   * @return bookingIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingIdentifier(UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public ScheduleItemSupplier bookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
    
    this.bookingOwnerIdentifier = bookingOwnerIdentifier;
    return this;
  }

   /**
   * Which company owns this schedule. (Owner of the engine)
   * @return bookingOwnerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingOwnerIdentifier() {
    return bookingOwnerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingOwnerIdentifier(UUID bookingOwnerIdentifier) {
    this.bookingOwnerIdentifier = bookingOwnerIdentifier;
  }


  public ScheduleItemSupplier hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier that owns the travel inventory.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public ScheduleItemSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of travel inventory.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ScheduleItemSupplier attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests attending this event.
   * minimum: 1
   * @return attendees
  **/
  @jakarta.annotation.Nullable
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }


  public ScheduleItemSupplier email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email of the person scheduling this event.
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public ScheduleItemSupplier fullName(String fullName) {
    
    this.fullName = fullName;
    return this;
  }

   /**
   * Full name of person scheduling this event.
   * @return fullName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullName() {
    return fullName;
  }


  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullName(String fullName) {
    this.fullName = fullName;
  }


  public ScheduleItemSupplier firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * First name of person scheduling this event.
   * @return firstName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public ScheduleItemSupplier lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name of person scheduling this event.
   * @return lastName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public ScheduleItemSupplier venueName(String venueName) {
    
    this.venueName = venueName;
    return this;
  }

   /**
   * Name of venue attendees will visit.
   * @return venueName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVenueName() {
    return venueName;
  }


  @JsonProperty(JSON_PROPERTY_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVenueName(String venueName) {
    this.venueName = venueName;
  }


  public ScheduleItemSupplier localizedVenueName(String localizedVenueName) {
    
    this.localizedVenueName = localizedVenueName;
    return this;
  }

   /**
   * Localized name of venue attendees will visit.
   * @return localizedVenueName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCALIZED_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalizedVenueName() {
    return localizedVenueName;
  }


  @JsonProperty(JSON_PROPERTY_LOCALIZED_VENUE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalizedVenueName(String localizedVenueName) {
    this.localizedVenueName = localizedVenueName;
  }


  public ScheduleItemSupplier contact(ContactSupplier contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(ContactSupplier contact) {
    this.contact = contact;
  }


  public ScheduleItemSupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public ScheduleItemSupplier created(java.time.LocalDateTime created) {
    
    this.created = created;
    return this;
  }

   /**
   * Date time this schedule event was created.
   * @return created
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(java.time.LocalDateTime created) {
    this.created = created;
  }


  public ScheduleItemSupplier lastModified(java.time.LocalDateTime lastModified) {
    
    this.lastModified = lastModified;
    return this;
  }

   /**
   * Last date time this scheduled event was modified.
   * @return lastModified
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastModified() {
    return lastModified;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastModified(java.time.LocalDateTime lastModified) {
    this.lastModified = lastModified;
  }


  public ScheduleItemSupplier sequence(Long sequence) {
    
    this.sequence = sequence;
    return this;
  }

   /**
   * Schedule event recurring sequence
   * @return sequence
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEQUENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSequence() {
    return sequence;
  }


  @JsonProperty(JSON_PROPERTY_SEQUENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSequence(Long sequence) {
    this.sequence = sequence;
  }


  public ScheduleItemSupplier brandName(String brandName) {
    
    this.brandName = brandName;
    return this;
  }

   /**
   * Brand name for email header
   * @return brandName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BRAND_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBrandName() {
    return brandName;
  }


  @JsonProperty(JSON_PROPERTY_BRAND_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrandName(String brandName) {
    this.brandName = brandName;
  }


  public ScheduleItemSupplier emailHeaderLogoUrl(String emailHeaderLogoUrl) {
    
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
    return this;
  }

   /**
   * Venue owner logo
   * @return emailHeaderLogoUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailHeaderLogoUrl() {
    return emailHeaderLogoUrl;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_HEADER_LOGO_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailHeaderLogoUrl(String emailHeaderLogoUrl) {
    this.emailHeaderLogoUrl = emailHeaderLogoUrl;
  }


  public ScheduleItemSupplier logoIdentifier(String logoIdentifier) {
    
    this.logoIdentifier = logoIdentifier;
    return this;
  }

   /**
   * Cloudinary image identifier of logo
   * @return logoIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLogoIdentifier() {
    return logoIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LOGO_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoIdentifier(String logoIdentifier) {
    this.logoIdentifier = logoIdentifier;
  }


  public ScheduleItemSupplier allDay(Boolean allDay) {
    
    this.allDay = allDay;
    return this;
  }

   /**
   * Get allDay
   * @return allDay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllDay() {
    return allDay;
  }


  @JsonProperty(JSON_PROPERTY_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllDay(Boolean allDay) {
    this.allDay = allDay;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ScheduleItemSupplier scheduleItemSupplier = (ScheduleItemSupplier) o;
    return Objects.equals(this.identifier, scheduleItemSupplier.identifier) &&
        Objects.equals(this.start, scheduleItemSupplier.start) &&
        Objects.equals(this.startTimezone, scheduleItemSupplier.startTimezone) &&
        Objects.equals(this.end, scheduleItemSupplier.end) &&
        Objects.equals(this.endTimezone, scheduleItemSupplier.endTimezone) &&
        Objects.equals(this.isAllDay, scheduleItemSupplier.isAllDay) &&
        Objects.equals(this.title, scheduleItemSupplier.title) &&
        Objects.equals(this.description, scheduleItemSupplier.description) &&
        Objects.equals(this.recurrenceRule, scheduleItemSupplier.recurrenceRule) &&
        Objects.equals(this.recurrenceId, scheduleItemSupplier.recurrenceId) &&
        Objects.equals(this.recurrenceException, scheduleItemSupplier.recurrenceException) &&
        Objects.equals(this.ownerIdentifier, scheduleItemSupplier.ownerIdentifier) &&
        Objects.equals(this.bookingIdentifier, scheduleItemSupplier.bookingIdentifier) &&
        Objects.equals(this.bookingOwnerIdentifier, scheduleItemSupplier.bookingOwnerIdentifier) &&
        Objects.equals(this.hotelIdentifier, scheduleItemSupplier.hotelIdentifier) &&
        Objects.equals(this.type, scheduleItemSupplier.type) &&
        Objects.equals(this.attendees, scheduleItemSupplier.attendees) &&
        Objects.equals(this.email, scheduleItemSupplier.email) &&
        Objects.equals(this.fullName, scheduleItemSupplier.fullName) &&
        Objects.equals(this.firstName, scheduleItemSupplier.firstName) &&
        Objects.equals(this.lastName, scheduleItemSupplier.lastName) &&
        Objects.equals(this.venueName, scheduleItemSupplier.venueName) &&
        Objects.equals(this.localizedVenueName, scheduleItemSupplier.localizedVenueName) &&
        Objects.equals(this.contact, scheduleItemSupplier.contact) &&
        Objects.equals(this.address, scheduleItemSupplier.address) &&
        Objects.equals(this.created, scheduleItemSupplier.created) &&
        Objects.equals(this.lastModified, scheduleItemSupplier.lastModified) &&
        Objects.equals(this.sequence, scheduleItemSupplier.sequence) &&
        Objects.equals(this.brandName, scheduleItemSupplier.brandName) &&
        Objects.equals(this.emailHeaderLogoUrl, scheduleItemSupplier.emailHeaderLogoUrl) &&
        Objects.equals(this.logoIdentifier, scheduleItemSupplier.logoIdentifier) &&
        Objects.equals(this.allDay, scheduleItemSupplier.allDay);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, start, startTimezone, end, endTimezone, isAllDay, title, description, recurrenceRule, recurrenceId, recurrenceException, ownerIdentifier, bookingIdentifier, bookingOwnerIdentifier, hotelIdentifier, type, attendees, email, fullName, firstName, lastName, venueName, localizedVenueName, contact, address, created, lastModified, sequence, brandName, emailHeaderLogoUrl, logoIdentifier, allDay);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ScheduleItemSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    startTimezone: ").append(toIndentedString(startTimezone)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    endTimezone: ").append(toIndentedString(endTimezone)).append("\n");
    sb.append("    isAllDay: ").append(toIndentedString(isAllDay)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    recurrenceRule: ").append(toIndentedString(recurrenceRule)).append("\n");
    sb.append("    recurrenceId: ").append(toIndentedString(recurrenceId)).append("\n");
    sb.append("    recurrenceException: ").append(toIndentedString(recurrenceException)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    bookingOwnerIdentifier: ").append(toIndentedString(bookingOwnerIdentifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    venueName: ").append(toIndentedString(venueName)).append("\n");
    sb.append("    localizedVenueName: ").append(toIndentedString(localizedVenueName)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    lastModified: ").append(toIndentedString(lastModified)).append("\n");
    sb.append("    sequence: ").append(toIndentedString(sequence)).append("\n");
    sb.append("    brandName: ").append(toIndentedString(brandName)).append("\n");
    sb.append("    emailHeaderLogoUrl: ").append(toIndentedString(emailHeaderLogoUrl)).append("\n");
    sb.append("    logoIdentifier: ").append(toIndentedString(logoIdentifier)).append("\n");
    sb.append("    allDay: ").append(toIndentedString(allDay)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

