/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.64.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpdateScheduleItemRequestSupplier
 */
@JsonPropertyOrder({
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_START,
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_END,
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_START_TIMEZONE,
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_END_TIMEZONE,
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_IS_ALL_DAY,
  UpdateScheduleItemRequestSupplier.JSON_PROPERTY_ATTENDEES
})
@JsonTypeName("UpdateScheduleItemRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:18:42.794855426+07:00[Asia/Bangkok]")
public class UpdateScheduleItemRequestSupplier {
  public static final String JSON_PROPERTY_START = "start";
  private java.time.LocalDateTime start;

  public static final String JSON_PROPERTY_END = "end";
  private java.time.LocalDateTime end;

  public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
  private String startTimezone;

  public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
  private String endTimezone;

  public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
  private Boolean isAllDay = false;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public UpdateScheduleItemRequestSupplier() {
  }

  public UpdateScheduleItemRequestSupplier start(java.time.LocalDateTime start) {
    
    this.start = start;
    return this;
  }

   /**
   * Start date time of scheduled event
   * @return start
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStart(java.time.LocalDateTime start) {
    this.start = start;
  }


  public UpdateScheduleItemRequestSupplier end(java.time.LocalDateTime end) {
    
    this.end = end;
    return this;
  }

   /**
   * End date time of scheduled event
   * @return end
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getEnd() {
    return end;
  }


  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnd(java.time.LocalDateTime end) {
    this.end = end;
  }


  public UpdateScheduleItemRequestSupplier startTimezone(String startTimezone) {
    
    this.startTimezone = startTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return startTimezone
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStartTimezone() {
    return startTimezone;
  }


  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartTimezone(String startTimezone) {
    this.startTimezone = startTimezone;
  }


  public UpdateScheduleItemRequestSupplier endTimezone(String endTimezone) {
    
    this.endTimezone = endTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return endTimezone
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEndTimezone() {
    return endTimezone;
  }


  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndTimezone(String endTimezone) {
    this.endTimezone = endTimezone;
  }


  public UpdateScheduleItemRequestSupplier isAllDay(Boolean isAllDay) {
    
    this.isAllDay = isAllDay;
    return this;
  }

   /**
   * Flag indicating whether this is an all day event.
   * @return isAllDay
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIsAllDay() {
    return isAllDay;
  }


  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIsAllDay(Boolean isAllDay) {
    this.isAllDay = isAllDay;
  }


  public UpdateScheduleItemRequestSupplier attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests attending this event.
   * minimum: 1
   * @return attendees
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateScheduleItemRequestSupplier updateScheduleItemRequestSupplier = (UpdateScheduleItemRequestSupplier) o;
    return Objects.equals(this.start, updateScheduleItemRequestSupplier.start) &&
        Objects.equals(this.end, updateScheduleItemRequestSupplier.end) &&
        Objects.equals(this.startTimezone, updateScheduleItemRequestSupplier.startTimezone) &&
        Objects.equals(this.endTimezone, updateScheduleItemRequestSupplier.endTimezone) &&
        Objects.equals(this.isAllDay, updateScheduleItemRequestSupplier.isAllDay) &&
        Objects.equals(this.attendees, updateScheduleItemRequestSupplier.attendees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(start, end, startTimezone, endTimezone, isAllDay, attendees);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateScheduleItemRequestSupplier {\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    startTimezone: ").append(toIndentedString(startTimezone)).append("\n");
    sb.append("    endTimezone: ").append(toIndentedString(endTimezone)).append("\n");
    sb.append("    isAllDay: ").append(toIndentedString(isAllDay)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

