package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.RestaurantViewSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertRestaurantRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-23T16:38:26.009483578+07:00[Asia/Bangkok]")
public class RestaurantApi {
    private ApiClient apiClient;

    public RestaurantApi() {
        this(new ApiClient());
    }

    @Autowired
    public RestaurantApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Restaurant
     * Create a new restaurant
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new restaurant record owned by this hotel identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRestaurantRequestCreation(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRestaurantRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRestaurantRequestSupplier' is set
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling createRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Restaurant
     * Create a new restaurant
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new restaurant record owned by this hotel identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RestaurantViewSupplier> createRestaurant(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Restaurant
     * Create a new restaurant
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new restaurant record owned by this hotel identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RestaurantViewSupplier>> createRestaurantWithHttpInfo(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Restaurant
     * Create a new restaurant
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create a new restaurant record owned by this hotel identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRestaurantWithResponseSpec(String hotelIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createRestaurantRequestCreation(hotelIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }
    /**
     * Delete Multimedia
     * Remove media from an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing restaurant owned by this hotel identifier.
     * @param restaurantIdentifier Remove a media record from an existing restaurant identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMultimedia3RequestCreation(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'multimediaIdentifier' is set
        if (multimediaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'multimediaIdentifier' when calling removeMultimedia3", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        pathParams.put("multimediaIdentifier", multimediaIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}/multimedia/{multimediaIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing restaurant owned by this hotel identifier.
     * @param restaurantIdentifier Remove a media record from an existing restaurant identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RestaurantViewSupplier> removeMultimedia3(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing restaurant owned by this hotel identifier.
     * @param restaurantIdentifier Remove a media record from an existing restaurant identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RestaurantViewSupplier>> removeMultimedia3WithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Multimedia
     * Remove media from an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a media record from an existing restaurant owned by this hotel identifier.
     * @param restaurantIdentifier Remove a media record from an existing restaurant identified by this identifier.
     * @param multimediaIdentifier Remove a media record with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMultimedia3WithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String multimediaIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMultimedia3RequestCreation(hotelIdentifier, restaurantIdentifier, multimediaIdentifier, winkVersion);
    }
    /**
     * Delete Restaurant
     * Remove a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Remove restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling removeRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Restaurant
     * Remove a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Remove restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRestaurant(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Restaurant
     * Remove a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Remove restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Restaurant
     * Remove a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Remove restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        return removeRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion);
    }
    /**
     * Show Restaurant
     * Retrieve a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single restaurant owned by this hotel identifier
     * @param restaurantIdentifier Show restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant
     * Retrieve a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single restaurant owned by this hotel identifier
     * @param restaurantIdentifier Show restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RestaurantViewSupplier> showRestaurant(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Retrieve a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single restaurant owned by this hotel identifier
     * @param restaurantIdentifier Show restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RestaurantViewSupplier>> showRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Retrieve a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single restaurant owned by this hotel identifier
     * @param restaurantIdentifier Show restaurant record identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        return showRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion);
    }
    /**
     * Show Reference Pairs
     * Retrieve list of restaurants as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurant pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRestaurantPairsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurantPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of restaurants as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurant pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;KeyValuePairSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairSupplier> showRestaurantPairs(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of restaurants as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurant pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showRestaurantPairsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>() {};
        return showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Reference Pairs
     * Retrieve list of restaurants as key/value pairs (identifier, name)
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurant pairs owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRestaurantPairsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showRestaurantPairsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show Restaurants
     * Retrieve list of restaurants for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurants owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRestaurantsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurants", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurants
     * Retrieve list of restaurants for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurants owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RestaurantViewSupplier> showRestaurants(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return showRestaurantsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Restaurants
     * Retrieve list of restaurants for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurants owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RestaurantViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RestaurantViewSupplier>>> showRestaurantsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return showRestaurantsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Restaurants
     * Retrieve list of restaurants for property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show restaurants owned by this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRestaurantsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showRestaurantsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Restaurant
     * Update a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Update an existing restaurant record identified by this identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRestaurantRequestCreation(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRestaurantRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRestaurantRequestSupplier' is set
        if (upsertRestaurantRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRestaurantRequestSupplier' when calling updateRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Restaurant
     * Update a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Update an existing restaurant record identified by this identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RestaurantViewSupplier> updateRestaurant(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Restaurant
     * Update a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Update an existing restaurant record identified by this identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RestaurantViewSupplier>> updateRestaurantWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Restaurant
     * Update a restaurant by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update an existing restaurant record owned by this hotel identifier
     * @param restaurantIdentifier Update an existing restaurant record identified by this identifier
     * @param upsertRestaurantRequestSupplier The upsertRestaurantRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRestaurantWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, UpsertRestaurantRequestSupplier upsertRestaurantRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateRestaurantRequestCreation(hotelIdentifier, restaurantIdentifier, upsertRestaurantRequestSupplier, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing restaurant owned by this hotel identifier
     * @param restaurantIdentifier Upload multipart files and associate them with an existing restaurant with this identifier
     * @param files The files parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadRestaurantMediaRequestCreation(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'restaurantIdentifier' is set
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadRestaurantMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/restaurant/{restaurantIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing restaurant owned by this hotel identifier
     * @param restaurantIdentifier Upload multipart files and associate them with an existing restaurant with this identifier
     * @param files The files parameter
     * @return RestaurantViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RestaurantViewSupplier> uploadRestaurantMedia(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing restaurant owned by this hotel identifier
     * @param restaurantIdentifier Upload multipart files and associate them with an existing restaurant with this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;RestaurantViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RestaurantViewSupplier>> uploadRestaurantMediaWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<RestaurantViewSupplier> localVarReturnType = new ParameterizedTypeReference<RestaurantViewSupplier>() {};
        return uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload a list of binary / multipart videos and/or images to an existing restaurant.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart files and associate them with an existing restaurant owned by this hotel identifier
     * @param restaurantIdentifier Upload multipart files and associate them with an existing restaurant with this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadRestaurantMediaWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, List<File> files) throws WebClientResponseException {
        return uploadRestaurantMediaRequestCreation(hotelIdentifier, restaurantIdentifier, files);
    }
}
