/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InventoryUsageSupplier;

public class InventoryUsageApi {
    private ApiClient apiClient;

    public InventoryUsageApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryUsageApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showActivityUsageRequestCreation(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (activityIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'activityIdentifier' when calling showActivityUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("activityIdentifier", activityIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/activity/{activityIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showActivityUsage(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showActivityUsageWithHttpInfo(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActivityUsageWithResponseSpec(String hotelIdentifier, String activityIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActivityUsageRequestCreation(hotelIdentifier, activityIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAddOnUsageRequestCreation(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addOnIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'addOnIdentifier' when calling showAddOnUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("addOnIdentifier", addOnIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/add-on/{addOnIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showAddOnUsage(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showAddOnUsageWithHttpInfo(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAddOnUsageWithResponseSpec(String hotelIdentifier, String addOnIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAddOnUsageRequestCreation(hotelIdentifier, addOnIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showAttractionUsageRequestCreation(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling showAttractionUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/attraction/{attractionIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showAttractionUsage(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showAttractionUsageWithHttpInfo(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAttractionUsageWithResponseSpec(String hotelIdentifier, String attractionIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showAttractionUsageRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showMeetingRoomUsageRequestCreation(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (meetingRoomIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'meetingRoomIdentifier' when calling showMeetingRoomUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("meetingRoomIdentifier", meetingRoomIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/meeting-room/{meetingRoomIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showMeetingRoomUsage(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showMeetingRoomUsageWithHttpInfo(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showMeetingRoomUsageWithResponseSpec(String hotelIdentifier, String meetingRoomIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showMeetingRoomUsageRequestCreation(hotelIdentifier, meetingRoomIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showPlaceUsageRequestCreation(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (placeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'placeIdentifier' when calling showPlaceUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("placeIdentifier", placeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/place/{placeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showPlaceUsage(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showPlaceUsageWithHttpInfo(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPlaceUsageWithResponseSpec(String hotelIdentifier, String placeIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showPlaceUsageRequestCreation(hotelIdentifier, placeIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRatePlanUsageRequestCreation(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ratePlanIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'ratePlanIdentifier' when calling showRatePlanUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("ratePlanIdentifier", ratePlanIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/rate-plan/{ratePlanIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRatePlanUsage(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRatePlanUsageWithHttpInfo(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRatePlanUsageWithResponseSpec(String hotelIdentifier, String ratePlanIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRatePlanUsageRequestCreation(hotelIdentifier, ratePlanIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRestaurantUsageRequestCreation(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (restaurantIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'restaurantIdentifier' when calling showRestaurantUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("restaurantIdentifier", restaurantIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/restaurant/{restaurantIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRestaurantUsage(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRestaurantUsageWithHttpInfo(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRestaurantUsageWithResponseSpec(String hotelIdentifier, String restaurantIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRestaurantUsageRequestCreation(hotelIdentifier, restaurantIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showRoomTypeUsageRequestCreation(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (roomTypeIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'roomTypeIdentifier' when calling showRoomTypeUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("roomTypeIdentifier", roomTypeIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/room-type/{roomTypeIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showRoomTypeUsage(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showRoomTypeUsageWithHttpInfo(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRoomTypeUsageWithResponseSpec(String hotelIdentifier, String roomTypeIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showRoomTypeUsageRequestCreation(hotelIdentifier, roomTypeIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSpaUsageRequestCreation(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (spaIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'spaIdentifier' when calling showSpaUsage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("spaIdentifier", spaIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/usage/spa/{spaIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryUsageSupplier> showSpaUsage(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryUsageSupplier>> showSpaUsageWithHttpInfo(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUsageSupplier> localVarReturnType = new ParameterizedTypeReference<InventoryUsageSupplier>(this){};
        return this.showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSpaUsageWithResponseSpec(String hotelIdentifier, String spaIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSpaUsageRequestCreation(hotelIdentifier, spaIdentifier, winkVersion);
    }
}

