/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.extranet.model.InventoryUsageItemSupplier;

@JsonPropertyOrder(value={"inventoryIdentifier", "name", "type", "itemList", "referenced"})
@JsonTypeName(value="InventoryUsage_Supplier")
public class InventoryUsageSupplier {
    public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
    private UUID inventoryIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
    private List<InventoryUsageItemSupplier> itemList = new ArrayList<InventoryUsageItemSupplier>();
    public static final String JSON_PROPERTY_REFERENCED = "referenced";
    private Boolean referenced;

    public InventoryUsageSupplier inventoryIdentifier(UUID inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getInventoryIdentifier() {
        return this.inventoryIdentifier;
    }

    @JsonProperty(value="inventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryIdentifier(UUID inventoryIdentifier) {
        this.inventoryIdentifier = inventoryIdentifier;
    }

    public InventoryUsageSupplier name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public InventoryUsageSupplier type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public InventoryUsageSupplier itemList(List<InventoryUsageItemSupplier> itemList) {
        this.itemList = itemList;
        return this;
    }

    public InventoryUsageSupplier addItemListItem(InventoryUsageItemSupplier itemListItem) {
        if (this.itemList == null) {
            this.itemList = new ArrayList<InventoryUsageItemSupplier>();
        }
        this.itemList.add(itemListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<InventoryUsageItemSupplier> getItemList() {
        return this.itemList;
    }

    @JsonProperty(value="itemList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItemList(List<InventoryUsageItemSupplier> itemList) {
        this.itemList = itemList;
    }

    public InventoryUsageSupplier referenced(Boolean referenced) {
        this.referenced = referenced;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenced")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReferenced() {
        return this.referenced;
    }

    @JsonProperty(value="referenced")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenced(Boolean referenced) {
        this.referenced = referenced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryUsageSupplier inventoryUsageSupplier = (InventoryUsageSupplier)o;
        return Objects.equals(this.inventoryIdentifier, inventoryUsageSupplier.inventoryIdentifier) && Objects.equals(this.name, inventoryUsageSupplier.name) && Objects.equals((Object)this.type, (Object)inventoryUsageSupplier.type) && Objects.equals(this.itemList, inventoryUsageSupplier.itemList) && Objects.equals(this.referenced, inventoryUsageSupplier.referenced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inventoryIdentifier, this.name, this.type, this.itemList, this.referenced});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InventoryUsageSupplier {\n");
        sb.append("    inventoryIdentifier: ").append(this.toIndentedString(this.inventoryIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    referenced: ").append(this.toIndentedString(this.referenced)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        GUEST_ROOM("GUEST_ROOM"),
        ADD_ON("ADD_ON"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        ATTRACTION("ATTRACTION"),
        PLACE("PLACE"),
        ACTIVITY("ACTIVITY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

