/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.BedroomConfigurationSupplier;
import travel.wink.sdk.extranet.model.ContactSupplier;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.SimpleDescriptionSupplier;
import travel.wink.sdk.extranet.model.SimpleMultimediaSupplier;
import travel.wink.sdk.extranet.model.SocialSupplier;
import travel.wink.sdk.extranet.model.TransactionalTravelInventorySupplier;
import travel.wink.sdk.extranet.model.TravelInventoryRecognitionSupplier;
import travel.wink.sdk.extranet.model.UpsertAddressRequestSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertGuestRoomRequestSupplier
 */
@JsonPropertyOrder({
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_FEATURED_IND,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_LIFESTYLE_TYPE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_LOCATION,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_DESCRIPTIONS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MULTIMEDIAS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ADDRESS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_COMMISSIONABLE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_NAME,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_PROXIMITY_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_SORT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_BOOKABLE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ACTIVE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_DISABILITY_FEATURES,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_SECURITY_FEATURES,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_CONTACT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_SOCIALS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_PRICE_POINT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_RECOGNITION_LIST,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_TRANSACTION_INVENTORY_LIST,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MAX_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MIN_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_QUANTITY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_NON_SMOKING,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_SIZE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MAX_ADULT_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MAX_CHILD_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_BATHROOM_COUNT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_LIVING_ROOM_COUNT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MAX_ROLLAWAYS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_CATEGORY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_FLOOR,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_LOCATION_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_VIEW_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_COMPOSITE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_COMPOSITE_COUNT,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_CLASSIFICATION_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_ARCHITECTURE_CODE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_ROOM_GENDER,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_SHARED_ROOM_IND,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MAX_CRIBS,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_AMENITIES,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_BASE_RATE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_MIN_RATE,
  UpsertGuestRoomRequestSupplier.JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST
})
@JsonTypeName("UpsertGuestRoomRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:16:48.275510066+07:00[Asia/Bangkok]")
public class UpsertGuestRoomRequestSupplier {
  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionSupplier> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaSupplier> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private UpsertAddressRequestSupplier address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactSupplier contact;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialSupplier> socials = new ArrayList<>();

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionSupplier> recognitionList = new ArrayList<>();

  public static final String JSON_PROPERTY_TRANSACTION_INVENTORY_LIST = "transactionInventoryList";
  private List<TransactionalTravelInventorySupplier> transactionInventoryList = new ArrayList<>();

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy = 2;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy = 1;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
  private Boolean nonSmoking;

  public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
  private List<BedroomConfigurationSupplier> bedroomConfigurationList = new ArrayList<>();

  public static final String JSON_PROPERTY_SIZE = "size";
  private Float size;

  public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
  private Integer maxAdultOccupancy = 2;

  public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
  private Integer maxChildOccupancy = 0;

  public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
  private Integer bathroomCount = 1;

  public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
  private Integer livingRoomCount = 1;

  public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
  private Integer maxRollaways = 0;

  public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
  private String roomCategory;

  public static final String JSON_PROPERTY_FLOOR = "floor";
  private String floor;

  public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
  private String roomLocationCode;

  public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
  private String roomViewCode;

  public static final String JSON_PROPERTY_COMPOSITE = "composite";
  private Boolean composite = false;

  public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
  private Integer compositeCount = 0;

  public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
  private String roomClassificationCode;

  public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
  private String roomArchitectureCode;

  /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   */
  public enum RoomGenderEnum {
    MALE("Male"),
    
    FEMALE("Female"),
    
    MALEANDFEMALE("MaleAndFemale"),
    
    UNKNOWN("Unknown");

    private String value;

    RoomGenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoomGenderEnum fromValue(String value) {
      for (RoomGenderEnum b : RoomGenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
  private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;

  public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
  private Boolean sharedRoomInd = false;

  public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
  private Integer maxCribs = 0;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities = new ArrayList<>();

  public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
  private Integer includedAdultOccupancy = 2;

  public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
  private Integer includedChildOccupancy = 0;

  public static final String JSON_PROPERTY_BASE_RATE = "baseRate";
  private CustomMonetaryAmount baseRate;

  public static final String JSON_PROPERTY_MIN_RATE = "minRate";
  private CustomMonetaryAmount minRate;

  public static final String JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST = "transactionalInventoryList";
  private List<TransactionalTravelInventorySupplier> transactionalInventoryList = new ArrayList<>();

  public UpsertGuestRoomRequestSupplier() {
  }

  public UpsertGuestRoomRequestSupplier featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public UpsertGuestRoomRequestSupplier lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public UpsertGuestRoomRequestSupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public UpsertGuestRoomRequestSupplier descriptions(List<SimpleDescriptionSupplier> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addDescriptionsItem(SimpleDescriptionSupplier descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionSupplier> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionSupplier> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertGuestRoomRequestSupplier multimedias(List<SimpleMultimediaSupplier> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addMultimediasItem(SimpleMultimediaSupplier multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaSupplier> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaSupplier> multimedias) {
    this.multimedias = multimedias;
  }


  public UpsertGuestRoomRequestSupplier address(UpsertAddressRequestSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UpsertAddressRequestSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(UpsertAddressRequestSupplier address) {
    this.address = address;
  }


  public UpsertGuestRoomRequestSupplier commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public UpsertGuestRoomRequestSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertGuestRoomRequestSupplier proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public UpsertGuestRoomRequestSupplier sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public UpsertGuestRoomRequestSupplier minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public UpsertGuestRoomRequestSupplier bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public UpsertGuestRoomRequestSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public UpsertGuestRoomRequestSupplier disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public UpsertGuestRoomRequestSupplier securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public UpsertGuestRoomRequestSupplier contact(ContactSupplier contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ContactSupplier getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContact(ContactSupplier contact) {
    this.contact = contact;
  }


  public UpsertGuestRoomRequestSupplier socials(List<SocialSupplier> socials) {
    
    this.socials = socials;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addSocialsItem(SocialSupplier socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialSupplier> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialSupplier> socials) {
    this.socials = socials;
  }


  public UpsertGuestRoomRequestSupplier pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public UpsertGuestRoomRequestSupplier recognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addRecognitionListItem(TravelInventoryRecognitionSupplier recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionSupplier> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionSupplier> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public UpsertGuestRoomRequestSupplier transactionInventoryList(List<TransactionalTravelInventorySupplier> transactionInventoryList) {
    
    this.transactionInventoryList = transactionInventoryList;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addTransactionInventoryListItem(TransactionalTravelInventorySupplier transactionInventoryListItem) {
    if (this.transactionInventoryList == null) {
      this.transactionInventoryList = new ArrayList<>();
    }
    this.transactionInventoryList.add(transactionInventoryListItem);
    return this;
  }

   /**
   * Get transactionInventoryList
   * @return transactionInventoryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTION_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionalTravelInventorySupplier> getTransactionInventoryList() {
    return transactionInventoryList;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTION_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionInventoryList(List<TransactionalTravelInventorySupplier> transactionInventoryList) {
    this.transactionInventoryList = transactionInventoryList;
  }


  public UpsertGuestRoomRequestSupplier maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum number of guest allowed in a room type.
   * minimum: 1
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public UpsertGuestRoomRequestSupplier minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum number of guests allowed in a room type.
   * minimum: 1
   * @return minOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public UpsertGuestRoomRequestSupplier quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Defines the number of rooms of this type
   * minimum: 1
   * @return quantity
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public UpsertGuestRoomRequestSupplier nonSmoking(Boolean nonSmoking) {
    
    this.nonSmoking = nonSmoking;
    return this;
  }

   /**
   * Non-smoking indicator
   * @return nonSmoking
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getNonSmoking() {
    return nonSmoking;
  }


  @JsonProperty(JSON_PROPERTY_NON_SMOKING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNonSmoking(Boolean nonSmoking) {
    this.nonSmoking = nonSmoking;
  }


  public UpsertGuestRoomRequestSupplier bedroomConfigurationList(List<BedroomConfigurationSupplier> bedroomConfigurationList) {
    
    this.bedroomConfigurationList = bedroomConfigurationList;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addBedroomConfigurationListItem(BedroomConfigurationSupplier bedroomConfigurationListItem) {
    this.bedroomConfigurationList.add(bedroomConfigurationListItem);
    return this;
  }

   /**
   * A room type can have more than one bed configuration.
   * @return bedroomConfigurationList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<BedroomConfigurationSupplier> getBedroomConfigurationList() {
    return bedroomConfigurationList;
  }


  @JsonProperty(JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBedroomConfigurationList(List<BedroomConfigurationSupplier> bedroomConfigurationList) {
    this.bedroomConfigurationList = bedroomConfigurationList;
  }


  public UpsertGuestRoomRequestSupplier size(Float size) {
    
    this.size = size;
    return this;
  }

   /**
   * Number of square meters that defines the size of this room type.
   * minimum: 1
   * @return size
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Float size) {
    this.size = size;
  }


  public UpsertGuestRoomRequestSupplier maxAdultOccupancy(Integer maxAdultOccupancy) {
    
    this.maxAdultOccupancy = maxAdultOccupancy;
    return this;
  }

   /**
   * Maximum number of adults allowed in a room type.
   * minimum: 1
   * @return maxAdultOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxAdultOccupancy() {
    return maxAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
    this.maxAdultOccupancy = maxAdultOccupancy;
  }


  public UpsertGuestRoomRequestSupplier maxChildOccupancy(Integer maxChildOccupancy) {
    
    this.maxChildOccupancy = maxChildOccupancy;
    return this;
  }

   /**
   * Maximum number of children allowed in a room type.
   * minimum: 0
   * @return maxChildOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxChildOccupancy() {
    return maxChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxChildOccupancy(Integer maxChildOccupancy) {
    this.maxChildOccupancy = maxChildOccupancy;
  }


  public UpsertGuestRoomRequestSupplier bathroomCount(Integer bathroomCount) {
    
    this.bathroomCount = bathroomCount;
    return this;
  }

   /**
   * Number of bathrooms
   * minimum: 0
   * @return bathroomCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getBathroomCount() {
    return bathroomCount;
  }


  @JsonProperty(JSON_PROPERTY_BATHROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBathroomCount(Integer bathroomCount) {
    this.bathroomCount = bathroomCount;
  }


  public UpsertGuestRoomRequestSupplier livingRoomCount(Integer livingRoomCount) {
    
    this.livingRoomCount = livingRoomCount;
    return this;
  }

   /**
   * Number of living rooms
   * minimum: 0
   * @return livingRoomCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLivingRoomCount() {
    return livingRoomCount;
  }


  @JsonProperty(JSON_PROPERTY_LIVING_ROOM_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLivingRoomCount(Integer livingRoomCount) {
    this.livingRoomCount = livingRoomCount;
  }


  public UpsertGuestRoomRequestSupplier maxRollaways(Integer maxRollaways) {
    
    this.maxRollaways = maxRollaways;
    return this;
  }

   /**
   * Maximum number of rollaway beds allowed in this room type.
   * minimum: 0
   * @return maxRollaways
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxRollaways() {
    return maxRollaways;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ROLLAWAYS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRollaways(Integer maxRollaways) {
    this.maxRollaways = maxRollaways;
  }


  public UpsertGuestRoomRequestSupplier roomCategory(String roomCategory) {
    
    this.roomCategory = roomCategory;
    return this;
  }

   /**
   * Indicates the category of the room. Typical values would be Moderate, Standard, or Deluxe. Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomCategory() {
    return roomCategory;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomCategory(String roomCategory) {
    this.roomCategory = roomCategory;
  }


  public UpsertGuestRoomRequestSupplier floor(String floor) {
    
    this.floor = floor;
    return this;
  }

   /**
   * Floor an which a room is located
   * @return floor
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFloor() {
    return floor;
  }


  @JsonProperty(JSON_PROPERTY_FLOOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFloor(String floor) {
    this.floor = floor;
  }


  public UpsertGuestRoomRequestSupplier roomLocationCode(String roomLocationCode) {
    
    this.roomLocationCode = roomLocationCode;
    return this;
  }

   /**
   * Indicates the location of the room within the hotel structure. Typical values would be \&quot;Near Exit\&quot;,\&quot;Close to elevator\&quot;, \&quot;Low Floor\&quot; or \&quot;High Floor\&quot;. Supported OTA specification &#x60;RLT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomLocationCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomLocationCode() {
    return roomLocationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_LOCATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomLocationCode(String roomLocationCode) {
    this.roomLocationCode = roomLocationCode;
  }


  public UpsertGuestRoomRequestSupplier roomViewCode(String roomViewCode) {
    
    this.roomViewCode = roomViewCode;
    return this;
  }

   /**
   * Indicates the view of the room. Typical values would be \&quot;Ocean view\&quot;, \&quot;Pool view\&quot; or \&quot;Garden View\&quot;. Supported OTA specification &#x60;RVT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomViewCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomViewCode() {
    return roomViewCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_VIEW_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomViewCode(String roomViewCode) {
    this.roomViewCode = roomViewCode;
  }


  public UpsertGuestRoomRequestSupplier composite(Boolean composite) {
    
    this.composite = composite;
    return this;
  }

   /**
   * Indicates that the room (suite) is a composite of smaller units.
   * @return composite
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getComposite() {
    return composite;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setComposite(Boolean composite) {
    this.composite = composite;
  }


  public UpsertGuestRoomRequestSupplier compositeCount(Integer compositeCount) {
    
    this.compositeCount = compositeCount;
    return this;
  }

   /**
   * Number of rooms of this room type that makes up a larger unit (composite) such as a two bedroom suite could be comprised of two king rooms plus other room types. A 0 means disabled.
   * minimum: 0
   * @return compositeCount
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getCompositeCount() {
    return compositeCount;
  }


  @JsonProperty(JSON_PROPERTY_COMPOSITE_COUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompositeCount(Integer compositeCount) {
    this.compositeCount = compositeCount;
  }


  public UpsertGuestRoomRequestSupplier roomClassificationCode(String roomClassificationCode) {
    
    this.roomClassificationCode = roomClassificationCode;
    return this;
  }

   /**
   * Specifies the room classification (e.g., cabin, apartment). Supported OTA specification &#x60;GRI&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomClassificationCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomClassificationCode() {
    return roomClassificationCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CLASSIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomClassificationCode(String roomClassificationCode) {
    this.roomClassificationCode = roomClassificationCode;
  }


  public UpsertGuestRoomRequestSupplier roomArchitectureCode(String roomArchitectureCode) {
    
    this.roomArchitectureCode = roomArchitectureCode;
    return this;
  }

   /**
   * Specifies the architectural style of a room. Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return roomArchitectureCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomArchitectureCode() {
    return roomArchitectureCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_ARCHITECTURE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomArchitectureCode(String roomArchitectureCode) {
    this.roomArchitectureCode = roomArchitectureCode;
  }


  public UpsertGuestRoomRequestSupplier roomGender(RoomGenderEnum roomGender) {
    
    this.roomGender = roomGender;
    return this;
  }

   /**
   * Used to request or specify a gender assignment for a room. Note: Typically used by Hosteliers.
   * @return roomGender
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomGenderEnum getRoomGender() {
    return roomGender;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomGender(RoomGenderEnum roomGender) {
    this.roomGender = roomGender;
  }


  public UpsertGuestRoomRequestSupplier sharedRoomInd(Boolean sharedRoomInd) {
    
    this.sharedRoomInd = sharedRoomInd;
    return this;
  }

   /**
   * If TRUE, the room requires or has sharing available. Note: Typically used by Hosteliers.
   * @return sharedRoomInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getSharedRoomInd() {
    return sharedRoomInd;
  }


  @JsonProperty(JSON_PROPERTY_SHARED_ROOM_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSharedRoomInd(Boolean sharedRoomInd) {
    this.sharedRoomInd = sharedRoomInd;
  }


  public UpsertGuestRoomRequestSupplier maxCribs(Integer maxCribs) {
    
    this.maxCribs = maxCribs;
    return this;
  }

   /**
   * Maximum number of cribs allowed in a room type.
   * minimum: 0
   * @return maxCribs
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxCribs() {
    return maxCribs;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CRIBS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxCribs(Integer maxCribs) {
    this.maxCribs = maxCribs;
  }


  public UpsertGuestRoomRequestSupplier amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Collection of room amenity items available to the guest. Supported OTA specification &#x60;RMA&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  public UpsertGuestRoomRequestSupplier includedAdultOccupancy(Integer includedAdultOccupancy) {
    
    this.includedAdultOccupancy = includedAdultOccupancy;
    return this;
  }

   /**
   * The number of pax the room price was meant for
   * minimum: 0
   * @return includedAdultOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedAdultOccupancy() {
    return includedAdultOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
    this.includedAdultOccupancy = includedAdultOccupancy;
  }


  public UpsertGuestRoomRequestSupplier includedChildOccupancy(Integer includedChildOccupancy) {
    
    this.includedChildOccupancy = includedChildOccupancy;
    return this;
  }

   /**
   * The number of children the room price was meant for
   * minimum: 0
   * @return includedChildOccupancy
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getIncludedChildOccupancy() {
    return includedChildOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
    this.includedChildOccupancy = includedChildOccupancy;
  }


  public UpsertGuestRoomRequestSupplier baseRate(CustomMonetaryAmount baseRate) {
    
    this.baseRate = baseRate;
    return this;
  }

   /**
   * Get baseRate
   * @return baseRate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getBaseRate() {
    return baseRate;
  }


  @JsonProperty(JSON_PROPERTY_BASE_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBaseRate(CustomMonetaryAmount baseRate) {
    this.baseRate = baseRate;
  }


  public UpsertGuestRoomRequestSupplier minRate(CustomMonetaryAmount minRate) {
    
    this.minRate = minRate;
    return this;
  }

   /**
   * Get minRate
   * @return minRate
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getMinRate() {
    return minRate;
  }


  @JsonProperty(JSON_PROPERTY_MIN_RATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMinRate(CustomMonetaryAmount minRate) {
    this.minRate = minRate;
  }


  public UpsertGuestRoomRequestSupplier transactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    
    this.transactionalInventoryList = transactionalInventoryList;
    return this;
  }

  public UpsertGuestRoomRequestSupplier addTransactionalInventoryListItem(TransactionalTravelInventorySupplier transactionalInventoryListItem) {
    if (this.transactionalInventoryList == null) {
      this.transactionalInventoryList = new ArrayList<>();
    }
    this.transactionalInventoryList.add(transactionalInventoryListItem);
    return this;
  }

   /**
   * Purchasable items for this inventory.
   * @return transactionalInventoryList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TransactionalTravelInventorySupplier> getTransactionalInventoryList() {
    return transactionalInventoryList;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONAL_INVENTORY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionalInventoryList(List<TransactionalTravelInventorySupplier> transactionalInventoryList) {
    this.transactionalInventoryList = transactionalInventoryList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertGuestRoomRequestSupplier upsertGuestRoomRequestSupplier = (UpsertGuestRoomRequestSupplier) o;
    return Objects.equals(this.featuredInd, upsertGuestRoomRequestSupplier.featuredInd) &&
        Objects.equals(this.lifestyleType, upsertGuestRoomRequestSupplier.lifestyleType) &&
        Objects.equals(this.location, upsertGuestRoomRequestSupplier.location) &&
        Objects.equals(this.descriptions, upsertGuestRoomRequestSupplier.descriptions) &&
        Objects.equals(this.multimedias, upsertGuestRoomRequestSupplier.multimedias) &&
        Objects.equals(this.address, upsertGuestRoomRequestSupplier.address) &&
        Objects.equals(this.commissionable, upsertGuestRoomRequestSupplier.commissionable) &&
        Objects.equals(this.name, upsertGuestRoomRequestSupplier.name) &&
        Objects.equals(this.proximityCode, upsertGuestRoomRequestSupplier.proximityCode) &&
        Objects.equals(this.sort, upsertGuestRoomRequestSupplier.sort) &&
        Objects.equals(this.minAgeAppropriateCode, upsertGuestRoomRequestSupplier.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, upsertGuestRoomRequestSupplier.bookable) &&
        Objects.equals(this.active, upsertGuestRoomRequestSupplier.active) &&
        Objects.equals(this.disabilityFeatures, upsertGuestRoomRequestSupplier.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, upsertGuestRoomRequestSupplier.securityFeatures) &&
        Objects.equals(this.contact, upsertGuestRoomRequestSupplier.contact) &&
        Objects.equals(this.socials, upsertGuestRoomRequestSupplier.socials) &&
        Objects.equals(this.pricePoint, upsertGuestRoomRequestSupplier.pricePoint) &&
        Objects.equals(this.recognitionList, upsertGuestRoomRequestSupplier.recognitionList) &&
        Objects.equals(this.transactionInventoryList, upsertGuestRoomRequestSupplier.transactionInventoryList) &&
        Objects.equals(this.maxOccupancy, upsertGuestRoomRequestSupplier.maxOccupancy) &&
        Objects.equals(this.minOccupancy, upsertGuestRoomRequestSupplier.minOccupancy) &&
        Objects.equals(this.quantity, upsertGuestRoomRequestSupplier.quantity) &&
        Objects.equals(this.nonSmoking, upsertGuestRoomRequestSupplier.nonSmoking) &&
        Objects.equals(this.bedroomConfigurationList, upsertGuestRoomRequestSupplier.bedroomConfigurationList) &&
        Objects.equals(this.size, upsertGuestRoomRequestSupplier.size) &&
        Objects.equals(this.maxAdultOccupancy, upsertGuestRoomRequestSupplier.maxAdultOccupancy) &&
        Objects.equals(this.maxChildOccupancy, upsertGuestRoomRequestSupplier.maxChildOccupancy) &&
        Objects.equals(this.bathroomCount, upsertGuestRoomRequestSupplier.bathroomCount) &&
        Objects.equals(this.livingRoomCount, upsertGuestRoomRequestSupplier.livingRoomCount) &&
        Objects.equals(this.maxRollaways, upsertGuestRoomRequestSupplier.maxRollaways) &&
        Objects.equals(this.roomCategory, upsertGuestRoomRequestSupplier.roomCategory) &&
        Objects.equals(this.floor, upsertGuestRoomRequestSupplier.floor) &&
        Objects.equals(this.roomLocationCode, upsertGuestRoomRequestSupplier.roomLocationCode) &&
        Objects.equals(this.roomViewCode, upsertGuestRoomRequestSupplier.roomViewCode) &&
        Objects.equals(this.composite, upsertGuestRoomRequestSupplier.composite) &&
        Objects.equals(this.compositeCount, upsertGuestRoomRequestSupplier.compositeCount) &&
        Objects.equals(this.roomClassificationCode, upsertGuestRoomRequestSupplier.roomClassificationCode) &&
        Objects.equals(this.roomArchitectureCode, upsertGuestRoomRequestSupplier.roomArchitectureCode) &&
        Objects.equals(this.roomGender, upsertGuestRoomRequestSupplier.roomGender) &&
        Objects.equals(this.sharedRoomInd, upsertGuestRoomRequestSupplier.sharedRoomInd) &&
        Objects.equals(this.maxCribs, upsertGuestRoomRequestSupplier.maxCribs) &&
        Objects.equals(this.amenities, upsertGuestRoomRequestSupplier.amenities) &&
        Objects.equals(this.includedAdultOccupancy, upsertGuestRoomRequestSupplier.includedAdultOccupancy) &&
        Objects.equals(this.includedChildOccupancy, upsertGuestRoomRequestSupplier.includedChildOccupancy) &&
        Objects.equals(this.baseRate, upsertGuestRoomRequestSupplier.baseRate) &&
        Objects.equals(this.minRate, upsertGuestRoomRequestSupplier.minRate) &&
        Objects.equals(this.transactionalInventoryList, upsertGuestRoomRequestSupplier.transactionalInventoryList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(featuredInd, lifestyleType, location, descriptions, multimedias, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, contact, socials, pricePoint, recognitionList, transactionInventoryList, maxOccupancy, minOccupancy, quantity, nonSmoking, bedroomConfigurationList, size, maxAdultOccupancy, maxChildOccupancy, bathroomCount, livingRoomCount, maxRollaways, roomCategory, floor, roomLocationCode, roomViewCode, composite, compositeCount, roomClassificationCode, roomArchitectureCode, roomGender, sharedRoomInd, maxCribs, amenities, includedAdultOccupancy, includedChildOccupancy, baseRate, minRate, transactionalInventoryList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertGuestRoomRequestSupplier {\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    transactionInventoryList: ").append(toIndentedString(transactionInventoryList)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    nonSmoking: ").append(toIndentedString(nonSmoking)).append("\n");
    sb.append("    bedroomConfigurationList: ").append(toIndentedString(bedroomConfigurationList)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    maxAdultOccupancy: ").append(toIndentedString(maxAdultOccupancy)).append("\n");
    sb.append("    maxChildOccupancy: ").append(toIndentedString(maxChildOccupancy)).append("\n");
    sb.append("    bathroomCount: ").append(toIndentedString(bathroomCount)).append("\n");
    sb.append("    livingRoomCount: ").append(toIndentedString(livingRoomCount)).append("\n");
    sb.append("    maxRollaways: ").append(toIndentedString(maxRollaways)).append("\n");
    sb.append("    roomCategory: ").append(toIndentedString(roomCategory)).append("\n");
    sb.append("    floor: ").append(toIndentedString(floor)).append("\n");
    sb.append("    roomLocationCode: ").append(toIndentedString(roomLocationCode)).append("\n");
    sb.append("    roomViewCode: ").append(toIndentedString(roomViewCode)).append("\n");
    sb.append("    composite: ").append(toIndentedString(composite)).append("\n");
    sb.append("    compositeCount: ").append(toIndentedString(compositeCount)).append("\n");
    sb.append("    roomClassificationCode: ").append(toIndentedString(roomClassificationCode)).append("\n");
    sb.append("    roomArchitectureCode: ").append(toIndentedString(roomArchitectureCode)).append("\n");
    sb.append("    roomGender: ").append(toIndentedString(roomGender)).append("\n");
    sb.append("    sharedRoomInd: ").append(toIndentedString(sharedRoomInd)).append("\n");
    sb.append("    maxCribs: ").append(toIndentedString(maxCribs)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    includedAdultOccupancy: ").append(toIndentedString(includedAdultOccupancy)).append("\n");
    sb.append("    includedChildOccupancy: ").append(toIndentedString(includedChildOccupancy)).append("\n");
    sb.append("    baseRate: ").append(toIndentedString(baseRate)).append("\n");
    sb.append("    minRate: ").append(toIndentedString(minRate)).append("\n");
    sb.append("    transactionalInventoryList: ").append(toIndentedString(transactionalInventoryList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

