/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.BookingCancellableSupplier;
import travel.wink.sdk.extranet.model.BookingCountSupplier;
import travel.wink.sdk.extranet.model.BookingViewSupplier;
import travel.wink.sdk.extranet.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.model.BooleanResponseSupplier;
import travel.wink.sdk.extranet.model.CancellationDetailSupplier;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.PageBookingViewSupplier;
import travel.wink.sdk.extranet.model.PropertyBookingRefundRequestSupplier;
import travel.wink.sdk.extranet.model.StateSupplier;

public class BookingApi {
    private ApiClient apiClient;

    public BookingApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelHotelBookingRequestCreation(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        CancellationDetailSupplier postBody = cancellationDetailSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailSupplier' when calling cancelHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/cancel", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplier> cancelHotelBooking(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.cancelHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> cancelHotelBookingWithHttpInfo(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.cancelHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelHotelBookingWithResponseSpec(String hotelIdentifier, String bookingIdentifier, CancellationDetailSupplier cancellationDetailSupplier, String winkVersion) throws WebClientResponseException {
        return this.cancelHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, cancellationDetailSupplier, winkVersion);
    }

    private WebClient.ResponseSpec isBookingCancellableRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling isBookingCancellable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/cancellable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingCancellableSupplier> isBookingCancellable(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(){};
        return this.isBookingCancellableRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCancellableSupplier>> isBookingCancellableWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCancellableSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCancellableSupplier>(){};
        return this.isBookingCancellableRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isBookingCancellableWithResponseSpec(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        return this.isBookingCancellableRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec requestRefundRequestCreation(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        PropertyBookingRefundRequestSupplier postBody = propertyBookingRefundRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (propertyBookingRefundRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyBookingRefundRequestSupplier' when calling requestRefund", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/request-refund", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplier> requestRefund(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.requestRefundRequestCreation(hotelIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplier>> requestRefundWithHttpInfo(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplier>(){};
        return this.requestRefundRequestCreation(hotelIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec requestRefundWithResponseSpec(String hotelIdentifier, String bookingIdentifier, PropertyBookingRefundRequestSupplier propertyBookingRefundRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.requestRefundRequestCreation(hotelIdentifier, bookingIdentifier, propertyBookingRefundRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec resendBookingConfirmationEmailRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmail", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseSupplier> resendBookingConfirmationEmail(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(){};
        return this.resendBookingConfirmationEmailRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseSupplier>> resendBookingConfirmationEmailWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseSupplier> localVarReturnType = new ParameterizedTypeReference<BooleanResponseSupplier>(){};
        return this.resendBookingConfirmationEmailRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec resendBookingConfirmationEmailWithResponseSpec(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        return this.resendBookingConfirmationEmailRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showActiveAffiliatesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActiveAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/owner/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showActiveAffiliates(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showActiveAffiliatesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveAffiliatesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showActiveAffiliatesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActiveAffiliatesWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActiveAffiliatesRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showActiveMasterRatesRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showActiveMasterRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/roomrate/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showActiveMasterRates(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showActiveMasterRatesRequestCreation(hotelIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showActiveMasterRatesWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(){};
        return this.showActiveMasterRatesRequestCreation(hotelIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showActiveMasterRatesWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showActiveMasterRatesRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showBookingsCountRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showBookingsCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/count", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingCountSupplier> showBookingsCount(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>(){};
        return this.showBookingsCountRequestCreation(hotelIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingCountSupplier>> showBookingsCountWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingCountSupplier> localVarReturnType = new ParameterizedTypeReference<BookingCountSupplier>(){};
        return this.showBookingsCountRequestCreation(hotelIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingsCountWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showBookingsCountRequestCreation(hotelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showHotelBookingRequestCreation(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showHotelBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewSupplierDetails> showHotelBooking(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.showHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewSupplierDetails>> showHotelBookingWithHttpInfo(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>(){};
        return this.showHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookingWithResponseSpec(String hotelIdentifier, String bookingIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showHotelBookingRequestCreation(hotelIdentifier, bookingIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showHotelBookingsRequestCreation(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showHotelBookings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewSupplier> showHotelBookings(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.showHotelBookingsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookingsWithHttpInfo(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.showHotelBookingsRequestCreation(hotelIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookingsWithResponseSpec(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.showHotelBookingsRequestCreation(hotelIdentifier, stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showHotelBookings1RequestCreation(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showHotelBookings1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pageNumber", pageNumber));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "maxResults", maxResults));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "search", search));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/booking/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewSupplier> showHotelBookings1(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.showHotelBookings1RequestCreation(hotelIdentifier, state, pageNumber, maxResults, search, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewSupplier>> showHotelBookings1WithHttpInfo(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewSupplier> localVarReturnType = new ParameterizedTypeReference<PageBookingViewSupplier>(){};
        return this.showHotelBookings1RequestCreation(hotelIdentifier, state, pageNumber, maxResults, search, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showHotelBookings1WithResponseSpec(String hotelIdentifier, String state, Integer pageNumber, Integer maxResults, String search, String winkVersion) throws WebClientResponseException {
        return this.showHotelBookings1RequestCreation(hotelIdentifier, state, pageNumber, maxResults, search, winkVersion);
    }
}

