package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CompanyUserSupplier;
import travel.wink.sdk.extranet.model.CreateHotelierRequestSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:52.377864372+07:00[Asia/Bangkok]")
public class AccessApi {
    private ApiClient apiClient;

    public AccessApi() {
        this(new ApiClient());
    }

    @Autowired
    public AccessApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete manager
     * Remove manager by specified identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove manager from this hotel identifier
     * @param userIdentifier Remove manager with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeManagerRequestCreation(String hotelIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'userIdentifier' is set
        if (userIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'userIdentifier' when calling removeManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("userIdentifier", userIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/access/{userIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete manager
     * Remove manager by specified identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove manager from this hotel identifier
     * @param userIdentifier Remove manager with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeManager(String hotelIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeManagerRequestCreation(hotelIdentifier, userIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete manager
     * Remove manager by specified identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove manager from this hotel identifier
     * @param userIdentifier Remove manager with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeManagerWithHttpInfo(String hotelIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeManagerRequestCreation(hotelIdentifier, userIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete manager
     * Remove manager by specified identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Remove manager from this hotel identifier
     * @param userIdentifier Remove manager with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeManagerWithResponseSpec(String hotelIdentifier, String userIdentifier, String winkVersion) throws WebClientResponseException {
        return removeManagerRequestCreation(hotelIdentifier, userIdentifier, winkVersion);
    }
    /**
     * Add manager to property
     * Link an existing user with your property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate manager with this hotel identifier
     * @param createHotelierRequestSupplier The createHotelierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyUserSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec saveManagerRequestCreation(String hotelIdentifier, CreateHotelierRequestSupplier createHotelierRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = createHotelierRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling saveManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createHotelierRequestSupplier' is set
        if (createHotelierRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'createHotelierRequestSupplier' when calling saveManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/access", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add manager to property
     * Link an existing user with your property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate manager with this hotel identifier
     * @param createHotelierRequestSupplier The createHotelierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyUserSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyUserSupplier> saveManager(String hotelIdentifier, CreateHotelierRequestSupplier createHotelierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return saveManagerRequestCreation(hotelIdentifier, createHotelierRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add manager to property
     * Link an existing user with your property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate manager with this hotel identifier
     * @param createHotelierRequestSupplier The createHotelierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyUserSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyUserSupplier>> saveManagerWithHttpInfo(String hotelIdentifier, CreateHotelierRequestSupplier createHotelierRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return saveManagerRequestCreation(hotelIdentifier, createHotelierRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add manager to property
     * Link an existing user with your property.
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Associate manager with this hotel identifier
     * @param createHotelierRequestSupplier The createHotelierRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec saveManagerWithResponseSpec(String hotelIdentifier, CreateHotelierRequestSupplier createHotelierRequestSupplier, String winkVersion) throws WebClientResponseException {
        return saveManagerRequestCreation(hotelIdentifier, createHotelierRequestSupplier, winkVersion);
    }
    /**
     * Show managers
     * Retrieve list of existing property managers
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Return managers for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyUserSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showManagersRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showManagers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/access/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show managers
     * Retrieve list of existing property managers
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Return managers for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyUserSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CompanyUserSupplier> showManagers(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return showManagersRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show managers
     * Retrieve list of existing property managers
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Return managers for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CompanyUserSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CompanyUserSupplier>>> showManagersWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyUserSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyUserSupplier>() {};
        return showManagersRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show managers
     * Retrieve list of existing property managers
     * <p><b>503</b> - Service Unavailable
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Return managers for hotel with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showManagersWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showManagersRequestCreation(hotelIdentifier, winkVersion);
    }
}
