/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.8.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.extranet.model.AddressSupplier;
import travel.wink.sdk.extranet.model.GeoJsonPointSupplier;
import travel.wink.sdk.extranet.model.HotelOnMapSupplier;
import travel.wink.sdk.extranet.model.SalesChannelSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InventorySupplier
 */
@JsonPropertyOrder({
  InventorySupplier.JSON_PROPERTY_IDENTIFIER,
  InventorySupplier.JSON_PROPERTY_SALES_CHANNEL,
  InventorySupplier.JSON_PROPERTY_INVENTORY_TYPE,
  InventorySupplier.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  InventorySupplier.JSON_PROPERTY_INVENTORY_NAME,
  InventorySupplier.JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH,
  InventorySupplier.JSON_PROPERTY_ENABLED,
  InventorySupplier.JSON_PROPERTY_IMAGE_IDENTIFIER,
  InventorySupplier.JSON_PROPERTY_PRICE_POINT,
  InventorySupplier.JSON_PROPERTY_LOCATION,
  InventorySupplier.JSON_PROPERTY_ADDRESS,
  InventorySupplier.JSON_PROPERTY_QUANTITY,
  InventorySupplier.JSON_PROPERTY_COMMISSIONABLE,
  InventorySupplier.JSON_PROPERTY_BOOKABLE,
  InventorySupplier.JSON_PROPERTY_HOTEL
})
@JsonTypeName("Inventory_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:52.377864372+07:00[Asia/Bangkok]")
public class InventorySupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelSupplier salesChannel;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  private UUID inventoryIdentifier;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public static final String JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH = "inventoryNameInEnglish";
  private String inventoryNameInEnglish;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointSupplier location;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressSupplier address;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 0;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = false;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapSupplier hotel;

  public InventorySupplier() {
  }

  public InventorySupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Inventory identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public InventorySupplier salesChannel(SalesChannelSupplier salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SalesChannelSupplier getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannel(SalesChannelSupplier salesChannel) {
    this.salesChannel = salesChannel;
  }


  public InventorySupplier inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public InventorySupplier inventoryIdentifier(UUID inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

   /**
   * Inventory type identifier
   * @return inventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryIdentifier(UUID inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }


  public InventorySupplier inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Name of inventory as hotel is seeing it
   * @return inventoryName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  public InventorySupplier inventoryNameInEnglish(String inventoryNameInEnglish) {
    
    this.inventoryNameInEnglish = inventoryNameInEnglish;
    return this;
  }

   /**
   * Name of inventory as traveler is seeing it
   * @return inventoryNameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryNameInEnglish() {
    return inventoryNameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryNameInEnglish(String inventoryNameInEnglish) {
    this.inventoryNameInEnglish = inventoryNameInEnglish;
  }


  public InventorySupplier enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this inventory is enabled or not
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public InventorySupplier imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Main image of inventory
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public InventorySupplier pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public InventorySupplier location(GeoJsonPointSupplier location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointSupplier getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointSupplier location) {
    this.location = location;
  }


  public InventorySupplier address(AddressSupplier address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressSupplier getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressSupplier address) {
    this.address = address;
  }


  public InventorySupplier quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * quantity
   * @return quantity
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public InventorySupplier commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this is commissionable or not
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public InventorySupplier bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Whether inventory can be booked
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public InventorySupplier hotel(HotelOnMapSupplier hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapSupplier getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapSupplier hotel) {
    this.hotel = hotel;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventorySupplier inventorySupplier = (InventorySupplier) o;
    return Objects.equals(this.identifier, inventorySupplier.identifier) &&
        Objects.equals(this.salesChannel, inventorySupplier.salesChannel) &&
        Objects.equals(this.inventoryType, inventorySupplier.inventoryType) &&
        Objects.equals(this.inventoryIdentifier, inventorySupplier.inventoryIdentifier) &&
        Objects.equals(this.inventoryName, inventorySupplier.inventoryName) &&
        Objects.equals(this.inventoryNameInEnglish, inventorySupplier.inventoryNameInEnglish) &&
        Objects.equals(this.enabled, inventorySupplier.enabled) &&
        Objects.equals(this.imageIdentifier, inventorySupplier.imageIdentifier) &&
        Objects.equals(this.pricePoint, inventorySupplier.pricePoint) &&
        Objects.equals(this.location, inventorySupplier.location) &&
        Objects.equals(this.address, inventorySupplier.address) &&
        Objects.equals(this.quantity, inventorySupplier.quantity) &&
        Objects.equals(this.commissionable, inventorySupplier.commissionable) &&
        Objects.equals(this.bookable, inventorySupplier.bookable) &&
        Objects.equals(this.hotel, inventorySupplier.hotel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, salesChannel, inventoryType, inventoryIdentifier, inventoryName, inventoryNameInEnglish, enabled, imageIdentifier, pricePoint, location, address, quantity, commissionable, bookable, hotel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventorySupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    inventoryNameInEnglish: ").append(toIndentedString(inventoryNameInEnglish)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

