/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.8.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.DailyRateSupplierDetails;
import travel.wink.sdk.extranet.model.LocalizedDescriptionSupplierDetails;
import travel.wink.sdk.extranet.model.QuoteSupplierDetails;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Calculated price
 */
@JsonPropertyOrder({
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  StayRateSupplierDetails.JSON_PROPERTY_QUANTITY,
  StayRateSupplierDetails.JSON_PROPERTY_MIN_OCCUPANCY,
  StayRateSupplierDetails.JSON_PROPERTY_MAX_OCCUPANCY,
  StayRateSupplierDetails.JSON_PROPERTY_RATE_SOURCE,
  StayRateSupplierDetails.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  StayRateSupplierDetails.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  StayRateSupplierDetails.JSON_PROPERTY_PREMIUM_PERCENT,
  StayRateSupplierDetails.JSON_PROPERTY_AVAILABLE,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  StayRateSupplierDetails.JSON_PROPERTY_OFFER_DETAILS,
  StayRateSupplierDetails.JSON_PROPERTY_PROMOTIONAL_CODES,
  StayRateSupplierDetails.JSON_PROPERTY_LIST,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT,
  StayRateSupplierDetails.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT,
  StayRateSupplierDetails.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  StayRateSupplierDetails.JSON_PROPERTY_INTERNAL_TOTAL,
  StayRateSupplierDetails.JSON_PROPERTY_SOURCE_TOTAL
})
@JsonTypeName("StayRate_SupplierDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:52.377864372+07:00[Asia/Bangkok]")
public class StayRateSupplierDetails {
  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private CustomMonetaryAmount sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private CustomMonetaryAmount internalBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
  private BigDecimal sourceExtraPaxModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
  private BigDecimal internalExtraPaxModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
  private BigDecimal userSpecifiedCurrencyExtraPaxModifier;

  public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
  private BigDecimal sourceExtraChildModifier;

  public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
  private BigDecimal internalExtraChildModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
  private BigDecimal userSpecifiedCurrencyExtraChildModifier;

  public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
  private BigDecimal sourceSingleOccupantModifier;

  public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
  private BigDecimal internalSingleOccupantModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
  private BigDecimal userSpecifiedCurrencySingleOccupantModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private BigDecimal sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private BigDecimal internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private BigDecimal userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private BigDecimal sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private BigDecimal internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private BigDecimal userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private BigDecimal sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private BigDecimal internalChannelModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private BigDecimal userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  private String rateSource;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteSupplierDetails sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteSupplierDetails sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
  private List<LocalizedDescriptionSupplierDetails> offerDetails = new ArrayList<>();

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_LIST = "list";
  private List<DailyRateSupplierDetails> _list = new ArrayList<>();

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT = "userSpecifiedCurrencyAveragePricePerNight";
  private CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight;

  public static final String JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT = "internalAveragePricePerNight";
  private CustomMonetaryAmount internalAveragePricePerNight;

  public static final String JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT = "sourceAveragePricePerNight";
  private CustomMonetaryAmount sourceAveragePricePerNight;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public StayRateSupplierDetails() {
  }

  public StayRateSupplierDetails userSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public StayRateSupplierDetails sourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public StayRateSupplierDetails internalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public StayRateSupplierDetails sourceExtraPaxModifier(BigDecimal sourceExtraPaxModifier) {
    
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in hotel currency.
   * @return sourceExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraPaxModifier() {
    return sourceExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraPaxModifier(BigDecimal sourceExtraPaxModifier) {
    this.sourceExtraPaxModifier = sourceExtraPaxModifier;
  }


  public StayRateSupplierDetails internalExtraPaxModifier(BigDecimal internalExtraPaxModifier) {
    
    this.internalExtraPaxModifier = internalExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in wink currency
   * @return internalExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraPaxModifier() {
    return internalExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraPaxModifier(BigDecimal internalExtraPaxModifier) {
    this.internalExtraPaxModifier = internalExtraPaxModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyExtraPaxModifier(BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    return this;
  }

   /**
   * Extra person modifier in user specified currency
   * @return userSpecifiedCurrencyExtraPaxModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraPaxModifier() {
    return userSpecifiedCurrencyExtraPaxModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraPaxModifier(BigDecimal userSpecifiedCurrencyExtraPaxModifier) {
    this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
  }


  public StayRateSupplierDetails sourceExtraChildModifier(BigDecimal sourceExtraChildModifier) {
    
    this.sourceExtraChildModifier = sourceExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in hotel currency
   * @return sourceExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceExtraChildModifier() {
    return sourceExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceExtraChildModifier(BigDecimal sourceExtraChildModifier) {
    this.sourceExtraChildModifier = sourceExtraChildModifier;
  }


  public StayRateSupplierDetails internalExtraChildModifier(BigDecimal internalExtraChildModifier) {
    
    this.internalExtraChildModifier = internalExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in wink currency
   * @return internalExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalExtraChildModifier() {
    return internalExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalExtraChildModifier(BigDecimal internalExtraChildModifier) {
    this.internalExtraChildModifier = internalExtraChildModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyExtraChildModifier(BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    return this;
  }

   /**
   * Extra child modifier in user specified currcency
   * @return userSpecifiedCurrencyExtraChildModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyExtraChildModifier() {
    return userSpecifiedCurrencyExtraChildModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyExtraChildModifier(BigDecimal userSpecifiedCurrencyExtraChildModifier) {
    this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
  }


  public StayRateSupplierDetails sourceSingleOccupantModifier(BigDecimal sourceSingleOccupantModifier) {
    
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in hotel currency
   * @return sourceSingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceSingleOccupantModifier() {
    return sourceSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceSingleOccupantModifier(BigDecimal sourceSingleOccupantModifier) {
    this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
  }


  public StayRateSupplierDetails internalSingleOccupantModifier(BigDecimal internalSingleOccupantModifier) {
    
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    return this;
  }

   /**
   * Singe occupant modifier in wink currency
   * @return internalSingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalSingleOccupantModifier() {
    return internalSingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalSingleOccupantModifier(BigDecimal internalSingleOccupantModifier) {
    this.internalSingleOccupantModifier = internalSingleOccupantModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencySingleOccupantModifier(BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    return this;
  }

   /**
   * Single occupant modifier in user specified currency
   * @return userSpecifiedCurrencySingleOccupantModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencySingleOccupantModifier() {
    return userSpecifiedCurrencySingleOccupantModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencySingleOccupantModifier(BigDecimal userSpecifiedCurrencySingleOccupantModifier) {
    this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
  }


  public StayRateSupplierDetails sourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public StayRateSupplierDetails internalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in wink currency
   * @return internalPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Rate discount modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public StayRateSupplierDetails sourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public StayRateSupplierDetails internalPremiumModifier(BigDecimal internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in wink currency
   * @return internalPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(BigDecimal internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Rate premiums modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public StayRateSupplierDetails sourceChannelModifier(BigDecimal sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(BigDecimal sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public StayRateSupplierDetails internalChannelModifier(BigDecimal internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(BigDecimal internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public StayRateSupplierDetails quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public StayRateSupplierDetails minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Minimum occupancy
   * @return minOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public StayRateSupplierDetails maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Maximum occupancy
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }


  public StayRateSupplierDetails rateSource(String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

   /**
   * Source
   * @return rateSource
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(String rateSource) {
    this.rateSource = rateSource;
  }


  public StayRateSupplierDetails promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public StayRateSupplierDetails channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Chanel discount percent
   * @return channelDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public StayRateSupplierDetails premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public StayRateSupplierDetails available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  public StayRateSupplierDetails sourceToUserCurrencyQuote(QuoteSupplierDetails sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteSupplierDetails getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToUserCurrencyQuote(QuoteSupplierDetails sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public StayRateSupplierDetails sourceToInternalCurrencyQuote(QuoteSupplierDetails sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteSupplierDetails getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceToInternalCurrencyQuote(QuoteSupplierDetails sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public StayRateSupplierDetails offerDetails(List<LocalizedDescriptionSupplierDetails> offerDetails) {
    
    this.offerDetails = offerDetails;
    return this;
  }

  public StayRateSupplierDetails addOfferDetailsItem(LocalizedDescriptionSupplierDetails offerDetailsItem) {
    if (this.offerDetails == null) {
      this.offerDetails = new ArrayList<>();
    }
    this.offerDetails.add(offerDetailsItem);
    return this;
  }

   /**
   * Localized text of the discount
   * @return offerDetails
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedDescriptionSupplierDetails> getOfferDetails() {
    return offerDetails;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DETAILS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfferDetails(List<LocalizedDescriptionSupplierDetails> offerDetails) {
    this.offerDetails = offerDetails;
  }


  public StayRateSupplierDetails promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public StayRateSupplierDetails addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * Promotional codes
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public StayRateSupplierDetails _list(List<DailyRateSupplierDetails> _list) {
    
    this._list = _list;
    return this;
  }

  public StayRateSupplierDetails addListItem(DailyRateSupplierDetails _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

   /**
   * Get _list
   * @return _list
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<DailyRateSupplierDetails> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(List<DailyRateSupplierDetails> _list) {
    this._list = _list;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyAveragePricePerNight(CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyAveragePricePerNight
   * @return userSpecifiedCurrencyAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyAveragePricePerNight() {
    return userSpecifiedCurrencyAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyAveragePricePerNight(CustomMonetaryAmount userSpecifiedCurrencyAveragePricePerNight) {
    this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
  }


  public StayRateSupplierDetails internalAveragePricePerNight(CustomMonetaryAmount internalAveragePricePerNight) {
    
    this.internalAveragePricePerNight = internalAveragePricePerNight;
    return this;
  }

   /**
   * Get internalAveragePricePerNight
   * @return internalAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalAveragePricePerNight() {
    return internalAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAveragePricePerNight(CustomMonetaryAmount internalAveragePricePerNight) {
    this.internalAveragePricePerNight = internalAveragePricePerNight;
  }


  public StayRateSupplierDetails sourceAveragePricePerNight(CustomMonetaryAmount sourceAveragePricePerNight) {
    
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
    return this;
  }

   /**
   * Get sourceAveragePricePerNight
   * @return sourceAveragePricePerNight
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceAveragePricePerNight() {
    return sourceAveragePricePerNight;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAveragePricePerNight(CustomMonetaryAmount sourceAveragePricePerNight) {
    this.sourceAveragePricePerNight = sourceAveragePricePerNight;
  }


  public StayRateSupplierDetails totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  public StayRateSupplierDetails userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public StayRateSupplierDetails internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  public StayRateSupplierDetails sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StayRateSupplierDetails stayRateSupplierDetails = (StayRateSupplierDetails) o;
    return Objects.equals(this.userSpecifiedCurrencyBaseTotal, stayRateSupplierDetails.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, stayRateSupplierDetails.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, stayRateSupplierDetails.internalBaseTotal) &&
        Objects.equals(this.sourceExtraPaxModifier, stayRateSupplierDetails.sourceExtraPaxModifier) &&
        Objects.equals(this.internalExtraPaxModifier, stayRateSupplierDetails.internalExtraPaxModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, stayRateSupplierDetails.userSpecifiedCurrencyExtraPaxModifier) &&
        Objects.equals(this.sourceExtraChildModifier, stayRateSupplierDetails.sourceExtraChildModifier) &&
        Objects.equals(this.internalExtraChildModifier, stayRateSupplierDetails.internalExtraChildModifier) &&
        Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, stayRateSupplierDetails.userSpecifiedCurrencyExtraChildModifier) &&
        Objects.equals(this.sourceSingleOccupantModifier, stayRateSupplierDetails.sourceSingleOccupantModifier) &&
        Objects.equals(this.internalSingleOccupantModifier, stayRateSupplierDetails.internalSingleOccupantModifier) &&
        Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, stayRateSupplierDetails.userSpecifiedCurrencySingleOccupantModifier) &&
        Objects.equals(this.sourcePromotionalModifier, stayRateSupplierDetails.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, stayRateSupplierDetails.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, stayRateSupplierDetails.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePremiumModifier, stayRateSupplierDetails.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, stayRateSupplierDetails.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, stayRateSupplierDetails.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourceChannelModifier, stayRateSupplierDetails.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, stayRateSupplierDetails.internalChannelModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, stayRateSupplierDetails.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.quantity, stayRateSupplierDetails.quantity) &&
        Objects.equals(this.minOccupancy, stayRateSupplierDetails.minOccupancy) &&
        Objects.equals(this.maxOccupancy, stayRateSupplierDetails.maxOccupancy) &&
        Objects.equals(this.rateSource, stayRateSupplierDetails.rateSource) &&
        Objects.equals(this.promotionalDiscountPercent, stayRateSupplierDetails.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, stayRateSupplierDetails.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, stayRateSupplierDetails.premiumPercent) &&
        Objects.equals(this.available, stayRateSupplierDetails.available) &&
        Objects.equals(this.sourceToUserCurrencyQuote, stayRateSupplierDetails.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, stayRateSupplierDetails.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.offerDetails, stayRateSupplierDetails.offerDetails) &&
        Objects.equals(this.promotionalCodes, stayRateSupplierDetails.promotionalCodes) &&
        Objects.equals(this._list, stayRateSupplierDetails._list) &&
        Objects.equals(this.userSpecifiedCurrencyAveragePricePerNight, stayRateSupplierDetails.userSpecifiedCurrencyAveragePricePerNight) &&
        Objects.equals(this.internalAveragePricePerNight, stayRateSupplierDetails.internalAveragePricePerNight) &&
        Objects.equals(this.sourceAveragePricePerNight, stayRateSupplierDetails.sourceAveragePricePerNight) &&
        Objects.equals(this.totalDiscountPercent, stayRateSupplierDetails.totalDiscountPercent) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, stayRateSupplierDetails.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, stayRateSupplierDetails.internalTotal) &&
        Objects.equals(this.sourceTotal, stayRateSupplierDetails.sourceTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, sourceExtraPaxModifier, internalExtraPaxModifier, userSpecifiedCurrencyExtraPaxModifier, sourceExtraChildModifier, internalExtraChildModifier, userSpecifiedCurrencyExtraChildModifier, sourceSingleOccupantModifier, internalSingleOccupantModifier, userSpecifiedCurrencySingleOccupantModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPromotionalModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyPremiumModifier, sourceChannelModifier, internalChannelModifier, userSpecifiedCurrencyChannelModifier, quantity, minOccupancy, maxOccupancy, rateSource, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, available, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, offerDetails, promotionalCodes, _list, userSpecifiedCurrencyAveragePricePerNight, internalAveragePricePerNight, sourceAveragePricePerNight, totalDiscountPercent, userSpecifiedCurrencyTotal, internalTotal, sourceTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StayRateSupplierDetails {\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    sourceExtraPaxModifier: ").append(toIndentedString(sourceExtraPaxModifier)).append("\n");
    sb.append("    internalExtraPaxModifier: ").append(toIndentedString(internalExtraPaxModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraPaxModifier)).append("\n");
    sb.append("    sourceExtraChildModifier: ").append(toIndentedString(sourceExtraChildModifier)).append("\n");
    sb.append("    internalExtraChildModifier: ").append(toIndentedString(internalExtraChildModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(toIndentedString(userSpecifiedCurrencyExtraChildModifier)).append("\n");
    sb.append("    sourceSingleOccupantModifier: ").append(toIndentedString(sourceSingleOccupantModifier)).append("\n");
    sb.append("    internalSingleOccupantModifier: ").append(toIndentedString(internalSingleOccupantModifier)).append("\n");
    sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(toIndentedString(userSpecifiedCurrencySingleOccupantModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    offerDetails: ").append(toIndentedString(offerDetails)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    userSpecifiedCurrencyAveragePricePerNight: ").append(toIndentedString(userSpecifiedCurrencyAveragePricePerNight)).append("\n");
    sb.append("    internalAveragePricePerNight: ").append(toIndentedString(internalAveragePricePerNight)).append("\n");
    sb.append("    sourceAveragePricePerNight: ").append(toIndentedString(sourceAveragePricePerNight)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

