/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.8.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertPropertyProfileRequestSupplier
 */
@JsonPropertyOrder({
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_STARS,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_LOCAL_NAME,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_CHAIN,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_BRAND,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_WHEN_BUILT,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_LICENSE_NUMBER,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_LOCATION_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_SEGMENT_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_HOTEL_CATEGORY,
  UpsertPropertyProfileRequestSupplier.JSON_PROPERTY_ARCHITECTURAL_STYLE
})
@JsonTypeName("UpsertPropertyProfileRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-22T15:43:52.377864372+07:00[Asia/Bangkok]")
public class UpsertPropertyProfileRequestSupplier {
  public static final String JSON_PROPERTY_STARS = "stars";
  private Integer stars;

  public static final String JSON_PROPERTY_LOCAL_NAME = "localName";
  private String localName;

  public static final String JSON_PROPERTY_HOTEL_CHAIN = "hotelChain";
  private String hotelChain;

  public static final String JSON_PROPERTY_HOTEL_BRAND = "hotelBrand";
  private String hotelBrand;

  public static final String JSON_PROPERTY_WHEN_BUILT = "whenBuilt";
  private String whenBuilt;

  public static final String JSON_PROPERTY_LICENSE_NUMBER = "licenseNumber";
  private String licenseNumber;

  public static final String JSON_PROPERTY_LOCATION_CATEGORY = "locationCategory";
  private String locationCategory;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORY = "segmentCategory";
  private String segmentCategory;

  public static final String JSON_PROPERTY_HOTEL_CATEGORY = "hotelCategory";
  private String hotelCategory;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLE = "architecturalStyle";
  private String architecturalStyle;

  public UpsertPropertyProfileRequestSupplier() {
  }

  public UpsertPropertyProfileRequestSupplier stars(Integer stars) {
    
    this.stars = stars;
    return this;
  }

   /**
   * Hotel star rating.
   * minimum: 0
   * maximum: 6
   * @return stars
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0) @Max(6)
  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getStars() {
    return stars;
  }


  @JsonProperty(JSON_PROPERTY_STARS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStars(Integer stars) {
    this.stars = stars;
  }


  public UpsertPropertyProfileRequestSupplier localName(String localName) {
    
    this.localName = localName;
    return this;
  }

   /**
   * Name of the hotel in its local language if you use it for domestic guests.
   * @return localName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocalName() {
    return localName;
  }


  @JsonProperty(JSON_PROPERTY_LOCAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocalName(String localName) {
    this.localName = localName;
  }


  public UpsertPropertyProfileRequestSupplier hotelChain(String hotelChain) {
    
    this.hotelChain = hotelChain;
    return this;
  }

   /**
   * Hotel chain name if property is part of that chain.
   * @return hotelChain
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelChain() {
    return hotelChain;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CHAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelChain(String hotelChain) {
    this.hotelChain = hotelChain;
  }


  public UpsertPropertyProfileRequestSupplier hotelBrand(String hotelBrand) {
    
    this.hotelBrand = hotelBrand;
    return this;
  }

   /**
   * Hotel brand name if property is part of that brand.
   * @return hotelBrand
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHotelBrand() {
    return hotelBrand;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelBrand(String hotelBrand) {
    this.hotelBrand = hotelBrand;
  }


  public UpsertPropertyProfileRequestSupplier whenBuilt(String whenBuilt) {
    
    this.whenBuilt = whenBuilt;
    return this;
  }

   /**
   * Year the property was constructed.
   * @return whenBuilt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhenBuilt() {
    return whenBuilt;
  }


  @JsonProperty(JSON_PROPERTY_WHEN_BUILT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhenBuilt(String whenBuilt) {
    this.whenBuilt = whenBuilt;
  }


  public UpsertPropertyProfileRequestSupplier licenseNumber(String licenseNumber) {
    
    this.licenseNumber = licenseNumber;
    return this;
  }

   /**
   * If the property has a valid license number to run a hotel in their country, add it here.
   * @return licenseNumber
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLicenseNumber() {
    return licenseNumber;
  }


  @JsonProperty(JSON_PROPERTY_LICENSE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicenseNumber(String licenseNumber) {
    this.licenseNumber = licenseNumber;
  }


  public UpsertPropertyProfileRequestSupplier locationCategory(String locationCategory) {
    
    this.locationCategory = locationCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLocationCategory() {
    return locationCategory;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocationCategory(String locationCategory) {
    this.locationCategory = locationCategory;
  }


  public UpsertPropertyProfileRequestSupplier segmentCategory(String segmentCategory) {
    
    this.segmentCategory = segmentCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSegmentCategory() {
    return segmentCategory;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSegmentCategory(String segmentCategory) {
    this.segmentCategory = segmentCategory;
  }


  public UpsertPropertyProfileRequestSupplier hotelCategory(String hotelCategory) {
    
    this.hotelCategory = hotelCategory;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHotelCategory() {
    return hotelCategory;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelCategory(String hotelCategory) {
    this.hotelCategory = hotelCategory;
  }


  public UpsertPropertyProfileRequestSupplier architecturalStyle(String architecturalStyle) {
    
    this.architecturalStyle = architecturalStyle;
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyle
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getArchitecturalStyle() {
    return architecturalStyle;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArchitecturalStyle(String architecturalStyle) {
    this.architecturalStyle = architecturalStyle;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertPropertyProfileRequestSupplier upsertPropertyProfileRequestSupplier = (UpsertPropertyProfileRequestSupplier) o;
    return Objects.equals(this.stars, upsertPropertyProfileRequestSupplier.stars) &&
        Objects.equals(this.localName, upsertPropertyProfileRequestSupplier.localName) &&
        Objects.equals(this.hotelChain, upsertPropertyProfileRequestSupplier.hotelChain) &&
        Objects.equals(this.hotelBrand, upsertPropertyProfileRequestSupplier.hotelBrand) &&
        Objects.equals(this.whenBuilt, upsertPropertyProfileRequestSupplier.whenBuilt) &&
        Objects.equals(this.licenseNumber, upsertPropertyProfileRequestSupplier.licenseNumber) &&
        Objects.equals(this.locationCategory, upsertPropertyProfileRequestSupplier.locationCategory) &&
        Objects.equals(this.segmentCategory, upsertPropertyProfileRequestSupplier.segmentCategory) &&
        Objects.equals(this.hotelCategory, upsertPropertyProfileRequestSupplier.hotelCategory) &&
        Objects.equals(this.architecturalStyle, upsertPropertyProfileRequestSupplier.architecturalStyle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stars, localName, hotelChain, hotelBrand, whenBuilt, licenseNumber, locationCategory, segmentCategory, hotelCategory, architecturalStyle);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertPropertyProfileRequestSupplier {\n");
    sb.append("    stars: ").append(toIndentedString(stars)).append("\n");
    sb.append("    localName: ").append(toIndentedString(localName)).append("\n");
    sb.append("    hotelChain: ").append(toIndentedString(hotelChain)).append("\n");
    sb.append("    hotelBrand: ").append(toIndentedString(hotelBrand)).append("\n");
    sb.append("    whenBuilt: ").append(toIndentedString(whenBuilt)).append("\n");
    sb.append("    licenseNumber: ").append(toIndentedString(licenseNumber)).append("\n");
    sb.append("    locationCategory: ").append(toIndentedString(locationCategory)).append("\n");
    sb.append("    segmentCategory: ").append(toIndentedString(segmentCategory)).append("\n");
    sb.append("    hotelCategory: ").append(toIndentedString(hotelCategory)).append("\n");
    sb.append("    architecturalStyle: ").append(toIndentedString(architecturalStyle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

