/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.HotelViewSupplier;
import travel.wink.sdk.extranet.model.MultimediaViewSupplier;
import travel.wink.sdk.extranet.model.PropertyRegistrationRequestSupplier;

public class OnboardingApi {
    private ApiClient apiClient;

    public OnboardingApi() {
        this(new ApiClient());
    }

    @Autowired
    public OnboardingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec registerHotelRequestCreation(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        PropertyRegistrationRequestSupplier postBody = propertyRegistrationRequestSupplier;
        if (propertyRegistrationRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'propertyRegistrationRequestSupplier' when calling registerHotel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/register", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HotelViewSupplier> registerHotel(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(){};
        return this.registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HotelViewSupplier>> registerHotelWithHttpInfo(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelViewSupplier> localVarReturnType = new ParameterizedTypeReference<HotelViewSupplier>(){};
        return this.registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec registerHotelWithResponseSpec(PropertyRegistrationRequestSupplier propertyRegistrationRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.registerHotelRequestCreation(propertyRegistrationRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec uploadHotelLogosRequestCreation(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadHotelLogos", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadHotelLogos", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (files != null) {
            formParams.addAll((Object)"files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>(){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/logo", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<MultimediaViewSupplier> uploadHotelLogos(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>(){};
        return this.uploadHotelLogosRequestCreation(hotelIdentifier, files).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<MultimediaViewSupplier>>> uploadHotelLogosWithHttpInfo(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<MultimediaViewSupplier> localVarReturnType = new ParameterizedTypeReference<MultimediaViewSupplier>(){};
        return this.uploadHotelLogosRequestCreation(hotelIdentifier, files).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec uploadHotelLogosWithResponseSpec(String hotelIdentifier, List<File> files) throws WebClientResponseException {
        return this.uploadHotelLogosRequestCreation(hotelIdentifier, files);
    }
}

