package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.BookingTestRequestSupplierDetails;
import travel.wink.sdk.extranet.model.BookingViewSupplierDetails;
import travel.wink.sdk.extranet.model.ChannelNameSupplier;
import travel.wink.sdk.extranet.model.DateRangeSupplier;
import travel.wink.sdk.extranet.model.DescriptiveRoomSupplierDetails;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.PageRateSupplier;
import travel.wink.sdk.extranet.model.RateSupplier;
import travel.wink.sdk.extranet.model.RateTesterSupplierDetails;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.StateSupplier;
import travel.wink.sdk.extranet.model.UpsertBulkRateRequestSupplier;
import travel.wink.sdk.extranet.model.UpsertRateListRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-24T16:36:44.138518294+07:00[Asia/Bangkok]")
public class DailyRateApi {
    private ApiClient apiClient;

    public DailyRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public DailyRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param upsertBulkRateRequestSupplier The upsertBulkRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bulkUpdateRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertBulkRateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertBulkRateRequestSupplier' is set
        if (upsertBulkRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertBulkRateRequestSupplier' when calling bulkUpdateRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/update", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param upsertBulkRateRequestSupplier The upsertBulkRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateSupplier> bulkUpdateRate(String hotelIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param upsertBulkRateRequestSupplier The upsertBulkRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RateSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateSupplier>>> bulkUpdateRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update Daily Rates by Range
     * Bulk update daily rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates by date range owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates by date range owned by this master rate.
     * @param upsertBulkRateRequestSupplier The upsertBulkRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bulkUpdateRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, UpsertBulkRateRequestSupplier upsertBulkRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return bulkUpdateRateRequestCreation(hotelIdentifier, masterRateIdentifier, upsertBulkRateRequestSupplier, winkVersion);
    }
    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param upsertRateListRequestSupplier The upsertRateListRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec bulkUpdateRate1RequestCreation(String hotelIdentifier, String masterRateIdentifier, UpsertRateListRequestSupplier upsertRateListRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateListRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateListRequestSupplier' is set
        if (upsertRateListRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateListRequestSupplier' when calling bulkUpdateRate1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/list/update", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param upsertRateListRequestSupplier The upsertRateListRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateSupplier> bulkUpdateRate1(String hotelIdentifier, String masterRateIdentifier, UpsertRateListRequestSupplier upsertRateListRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, upsertRateListRequestSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param upsertRateListRequestSupplier The upsertRateListRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RateSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateSupplier>>> bulkUpdateRate1WithHttpInfo(String hotelIdentifier, String masterRateIdentifier, UpsertRateListRequestSupplier upsertRateListRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, upsertRateListRequestSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Update Daily Rates by List
     * Update daily rates with list of daily rate records.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update daily rates list owned by this hotel identifier.
     * @param masterRateIdentifier Update daily rates list owned by this master rate.
     * @param upsertRateListRequestSupplier The upsertRateListRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec bulkUpdateRate1WithResponseSpec(String hotelIdentifier, String masterRateIdentifier, UpsertRateListRequestSupplier upsertRateListRequestSupplier, String winkVersion) throws WebClientResponseException {
        return bulkUpdateRate1RequestCreation(hotelIdentifier, masterRateIdentifier, upsertRateListRequestSupplier, winkVersion);
    }
    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequestSupplierDetails The bookingTestRequestSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createTestBookingRequestCreation(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        Object postBody = bookingTestRequestSupplierDetails;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingTestRequestSupplierDetails' is set
        if (bookingTestRequestSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingTestRequestSupplierDetails' when calling createTestBooking", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/booking", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequestSupplierDetails The bookingTestRequestSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return BookingViewSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingViewSupplierDetails> createTestBooking(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequestSupplierDetails The bookingTestRequestSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingViewSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingViewSupplierDetails>> createTestBookingWithHttpInfo(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewSupplierDetails> localVarReturnType = new ParameterizedTypeReference<BookingViewSupplierDetails>() {};
        return createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param bookingTestRequestSupplierDetails The bookingTestRequestSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createTestBookingWithResponseSpec(String hotelIdentifier, BookingTestRequestSupplierDetails bookingTestRequestSupplierDetails, String winkVersion) throws WebClientResponseException {
        return createTestBookingRequestCreation(hotelIdentifier, bookingTestRequestSupplierDetails, winkVersion);
    }
    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllHotelRatesRequestCreation(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = dateRangeSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dateRangeSupplier' is set
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllHotelRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/rates/dates", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateSupplier> showAllHotelRates(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RateSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateSupplier>>> showAllHotelRatesWithHttpInfo(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Daily Rates by Hotel
     * Retrieve daily rates for all master rates by date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAllHotelRatesWithResponseSpec(String hotelIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return showAllHotelRatesRequestCreation(hotelIdentifier, dateRangeSupplier, winkVersion);
    }
    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAllMasterRatesRatesRequestCreation(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = dateRangeSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'dateRangeSupplier' is set
        if (dateRangeSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dateRangeSupplier' when calling showAllMasterRatesRates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rates/dates", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;RateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateSupplier> showAllMasterRatesRates(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;RateSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateSupplier>>> showAllMasterRatesRatesWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateSupplier> localVarReturnType = new ParameterizedTypeReference<RateSupplier>() {};
        return showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Daily Rates by Master Rate
     * Retrieve daily rates for a master rate for date range
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate list owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate list owned by this master rate.
     * @param dateRangeSupplier The dateRangeSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAllMasterRatesRatesWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, DateRangeSupplier dateRangeSupplier, String winkVersion) throws WebClientResponseException {
        return showAllMasterRatesRatesRequestCreation(hotelIdentifier, masterRateIdentifier, dateRangeSupplier, winkVersion);
    }
    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ChannelNameSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showChannelsRequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/channel/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;ChannelNameSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChannelNameSupplier> showChannels(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>() {};
        return showChannelsRequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;ChannelNameSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ChannelNameSupplier>>> showChannelsWithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ChannelNameSupplier> localVarReturnType = new ParameterizedTypeReference<ChannelNameSupplier>() {};
        return showChannelsRequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * List Sales Channels
     * List sales channels for property
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showChannelsWithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showChannelsRequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageRateSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDailyRatesPageRequestCreation(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = stateSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'stateSupplier' is set
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling showDailyRatesPage", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/rate/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return PageRateSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageRateSupplier> showDailyRatesPage(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>() {};
        return showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageRateSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageRateSupplier>> showDailyRatesPageWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageRateSupplier> localVarReturnType = new ParameterizedTypeReference<PageRateSupplier>() {};
        return showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Daily Rate Page
     * Retrieve daily rates for a master rate within a certain date range.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show daily rate page owned by this hotel identifier.
     * @param masterRateIdentifier Show daily rate page owned by this master rate.
     * @param stateSupplier The stateSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDailyRatesPageWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return showDailyRatesPageRequestCreation(hotelIdentifier, masterRateIdentifier, stateSupplier, winkVersion);
    }
    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterSupplierDetails The rateTesterSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;DescriptiveRoomSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDescriptiveInventoryRequestCreation(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        Object postBody = rateTesterSupplierDetails;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rateTesterSupplierDetails' is set
        if (rateTesterSupplierDetails == null) {
            throw new WebClientResponseException("Missing the required parameter 'rateTesterSupplierDetails' when calling showDescriptiveInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sandbox/room/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterSupplierDetails The rateTesterSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;DescriptiveRoomSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DescriptiveRoomSupplierDetails> showDescriptiveInventory(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>() {};
        return showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterSupplierDetails The rateTesterSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;DescriptiveRoomSupplierDetails&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<DescriptiveRoomSupplierDetails>>> showDescriptiveInventoryWithHttpInfo(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DescriptiveRoomSupplierDetails> localVarReturnType = new ParameterizedTypeReference<DescriptiveRoomSupplierDetails>() {};
        return showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Test Rate / Availability
     * Test whether the rates and availability for a sales channel is coming backing the way the property wants
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier The hotelIdentifier parameter
     * @param rateTesterSupplierDetails The rateTesterSupplierDetails parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDescriptiveInventoryWithResponseSpec(String hotelIdentifier, RateTesterSupplierDetails rateTesterSupplierDetails, String winkVersion) throws WebClientResponseException {
        return showDescriptiveInventoryRequestCreation(hotelIdentifier, rateTesterSupplierDetails, winkVersion);
    }
}
