package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.CreateMasterRateRequestSupplier;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.MasterRateViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.RoomRateRemovableResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpdateMasterRateRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:55:35.116871167+07:00[Asia/Bangkok]")
public class MasterRateApi {
    private ApiClient apiClient;

    public MasterRateApi() {
        this(new ApiClient());
    }

    @Autowired
    public MasterRateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequestSupplier The createMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createMasterRateRequestCreation(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = createMasterRateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createMasterRateRequestSupplier' is set
        if (createMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'createMasterRateRequestSupplier' when calling createMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequestSupplier The createMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> createMasterRate(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequestSupplier The createMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> createMasterRateWithHttpInfo(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Master Rate
     * Create a new master rate
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new master rate owned by this hotel identifier.
     * @param createMasterRateRequestSupplier The createMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createMasterRateWithResponseSpec(String hotelIdentifier, CreateMasterRateRequestSupplier createMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createMasterRateRequestCreation(hotelIdentifier, createMasterRateRequestSupplier, winkVersion);
    }
    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return RoomRateRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removableMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removableMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}/removable", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return RoomRateRemovableResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RoomRateRemovableResponseSupplier> removableMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>() {};
        return removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RoomRateRemovableResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RoomRateRemovableResponseSupplier>> removableMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RoomRateRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RoomRateRemovableResponseSupplier>() {};
        return removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify Removable
     * Check if a master rate is removable. If a master is associated / linked with a promotion, it cannot be removed until the associated entity removes it first.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Verify if master rate, owned by this hotel identifier, is removable.
     * @param masterRateIdentifier Verify if master rate, identified by this identifier, is removable.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removableMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return removableMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }
    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling removeMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Master Rate
     * Delete a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove master rate owned by this hotel identifier.
     * @param masterRateIdentifier Remove master rate with this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return removeMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }
    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling showMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> showMasterRate(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> showMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Master Rate
     * Retrieve a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single master rate owned by this hotel identifier.
     * @param masterRateIdentifier Show single master rate with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, String winkVersion) throws WebClientResponseException {
        return showMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, winkVersion);
    }
    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showMasterRates1RequestCreation(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showMasterRates1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<MasterRateViewSupplier> showMasterRates1(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;MasterRateViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<MasterRateViewSupplier>>> showMasterRates1WithHttpInfo(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Master Rates
     * Retrieve list of master rates
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all master rates owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showMasterRates1WithResponseSpec(String hotelIdentifier, String winkVersion) throws WebClientResponseException {
        return showMasterRates1RequestCreation(hotelIdentifier, winkVersion);
    }
    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequestSupplier The updateMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateMasterRateRequestCreation(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = updateMasterRateRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'masterRateIdentifier' is set
        if (masterRateIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'masterRateIdentifier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'updateMasterRateRequestSupplier' is set
        if (updateMasterRateRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'updateMasterRateRequestSupplier' when calling updateMasterRate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("masterRateIdentifier", masterRateIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/master-rate/{masterRateIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequestSupplier The updateMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return MasterRateViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<MasterRateViewSupplier> updateMasterRate(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequestSupplier The updateMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;MasterRateViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<MasterRateViewSupplier>> updateMasterRateWithHttpInfo(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<MasterRateViewSupplier> localVarReturnType = new ParameterizedTypeReference<MasterRateViewSupplier>() {};
        return updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Master Rate
     * Update a master rate by its identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing master rate owned by this hotel identifier.
     * @param masterRateIdentifier Update existing master rate with this identifier.
     * @param updateMasterRateRequestSupplier The updateMasterRateRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateMasterRateWithResponseSpec(String hotelIdentifier, String masterRateIdentifier, UpdateMasterRateRequestSupplier updateMasterRateRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateMasterRateRequestCreation(hotelIdentifier, masterRateIdentifier, updateMasterRateRequestSupplier, winkVersion);
    }
}
