/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import travel.wink.sdk.extranet.model.CustomMonetaryAmount;
import travel.wink.sdk.extranet.model.QuoteSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Pricing information for this ancillary.
 */
@JsonPropertyOrder({
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  LocalizedPriceSupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_BASE_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_INTERNAL_BASE_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER,
  LocalizedPriceSupplier.JSON_PROPERTY_QUANTITY,
  LocalizedPriceSupplier.JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT,
  LocalizedPriceSupplier.JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT,
  LocalizedPriceSupplier.JSON_PROPERTY_PREMIUM_PERCENT,
  LocalizedPriceSupplier.JSON_PROPERTY_HAS_PREMIUM,
  LocalizedPriceSupplier.JSON_PROPERTY_HAS_PROMOTION,
  LocalizedPriceSupplier.JSON_PROPERTY_HAS_CHANNEL_DISCOUNT,
  LocalizedPriceSupplier.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_INTERNAL_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_SOURCE_TOTAL,
  LocalizedPriceSupplier.JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT
})
@JsonTypeName("LocalizedPrice_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:55:35.116871167+07:00[Asia/Bangkok]")
public class LocalizedPriceSupplier {
  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteSupplier sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteSupplier sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyBaseTotal;

  public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
  private CustomMonetaryAmount sourceBaseTotal;

  public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
  private CustomMonetaryAmount internalBaseTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
  private BigDecimal userSpecifiedCurrencyPromotionalModifier;

  public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
  private BigDecimal sourcePromotionalModifier;

  public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
  private BigDecimal internalPromotionalModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
  private BigDecimal userSpecifiedCurrencyPremiumModifier;

  public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
  private BigDecimal sourcePremiumModifier;

  public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
  private BigDecimal internalPremiumModifier;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
  private BigDecimal userSpecifiedCurrencyChannelModifier;

  public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
  private BigDecimal sourceChannelModifier;

  public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
  private BigDecimal internalChannelModifier;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity = 1l;

  public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
  private Float promotionalDiscountPercent;

  public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
  private Float channelDiscountPercent;

  public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
  private Float premiumPercent;

  public static final String JSON_PROPERTY_HAS_PREMIUM = "hasPremium";
  private Boolean hasPremium;

  public static final String JSON_PROPERTY_HAS_PROMOTION = "hasPromotion";
  private Boolean hasPromotion;

  public static final String JSON_PROPERTY_HAS_CHANNEL_DISCOUNT = "hasChannelDiscount";
  private Boolean hasChannelDiscount;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  private CustomMonetaryAmount internalTotal;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
  private Float totalDiscountPercent;

  public LocalizedPriceSupplier() {
  }

  public LocalizedPriceSupplier sourceToUserCurrencyQuote(QuoteSupplier sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplier getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteSupplier sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public LocalizedPriceSupplier sourceToInternalCurrencyQuote(QuoteSupplier sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteSupplier getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteSupplier sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public LocalizedPriceSupplier userSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyBaseTotal
   * @return userSpecifiedCurrencyBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyBaseTotal() {
    return userSpecifiedCurrencyBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSpecifiedCurrencyBaseTotal(CustomMonetaryAmount userSpecifiedCurrencyBaseTotal) {
    this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
  }


  public LocalizedPriceSupplier sourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    
    this.sourceBaseTotal = sourceBaseTotal;
    return this;
  }

   /**
   * Get sourceBaseTotal
   * @return sourceBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getSourceBaseTotal() {
    return sourceBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceBaseTotal(CustomMonetaryAmount sourceBaseTotal) {
    this.sourceBaseTotal = sourceBaseTotal;
  }


  public LocalizedPriceSupplier internalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    
    this.internalBaseTotal = internalBaseTotal;
    return this;
  }

   /**
   * Get internalBaseTotal
   * @return internalBaseTotal
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CustomMonetaryAmount getInternalBaseTotal() {
    return internalBaseTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_BASE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternalBaseTotal(CustomMonetaryAmount internalBaseTotal) {
    this.internalBaseTotal = internalBaseTotal;
  }


  public LocalizedPriceSupplier userSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in user specified currency
   * @return userSpecifiedCurrencyPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPromotionalModifier() {
    return userSpecifiedCurrencyPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPromotionalModifier(BigDecimal userSpecifiedCurrencyPromotionalModifier) {
    this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
  }


  public LocalizedPriceSupplier sourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    
    this.sourcePromotionalModifier = sourcePromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in hotel currency
   * @return sourcePromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePromotionalModifier() {
    return sourcePromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePromotionalModifier(BigDecimal sourcePromotionalModifier) {
    this.sourcePromotionalModifier = sourcePromotionalModifier;
  }


  public LocalizedPriceSupplier internalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    
    this.internalPromotionalModifier = internalPromotionalModifier;
    return this;
  }

   /**
   * Promotional modifiers in wink currency
   * @return internalPromotionalModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPromotionalModifier() {
    return internalPromotionalModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPromotionalModifier(BigDecimal internalPromotionalModifier) {
    this.internalPromotionalModifier = internalPromotionalModifier;
  }


  public LocalizedPriceSupplier userSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in user specified currency
   * @return userSpecifiedCurrencyPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyPremiumModifier() {
    return userSpecifiedCurrencyPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyPremiumModifier(BigDecimal userSpecifiedCurrencyPremiumModifier) {
    this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
  }


  public LocalizedPriceSupplier sourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    
    this.sourcePremiumModifier = sourcePremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in hotel currency
   * @return sourcePremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourcePremiumModifier() {
    return sourcePremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourcePremiumModifier(BigDecimal sourcePremiumModifier) {
    this.sourcePremiumModifier = sourcePremiumModifier;
  }


  public LocalizedPriceSupplier internalPremiumModifier(BigDecimal internalPremiumModifier) {
    
    this.internalPremiumModifier = internalPremiumModifier;
    return this;
  }

   /**
   * Premium modifiers in wink currency
   * @return internalPremiumModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalPremiumModifier() {
    return internalPremiumModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPremiumModifier(BigDecimal internalPremiumModifier) {
    this.internalPremiumModifier = internalPremiumModifier;
  }


  public LocalizedPriceSupplier userSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in user specified currency
   * @return userSpecifiedCurrencyChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUserSpecifiedCurrencyChannelModifier() {
    return userSpecifiedCurrencyChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyChannelModifier(BigDecimal userSpecifiedCurrencyChannelModifier) {
    this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
  }


  public LocalizedPriceSupplier sourceChannelModifier(BigDecimal sourceChannelModifier) {
    
    this.sourceChannelModifier = sourceChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in hotel currency
   * @return sourceChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceChannelModifier() {
    return sourceChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceChannelModifier(BigDecimal sourceChannelModifier) {
    this.sourceChannelModifier = sourceChannelModifier;
  }


  public LocalizedPriceSupplier internalChannelModifier(BigDecimal internalChannelModifier) {
    
    this.internalChannelModifier = internalChannelModifier;
    return this;
  }

   /**
   * Channel / Membership modifier in wink currency
   * @return internalChannelModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalChannelModifier() {
    return internalChannelModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalChannelModifier(BigDecimal internalChannelModifier) {
    this.internalChannelModifier = internalChannelModifier;
  }


  public LocalizedPriceSupplier quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * How many of this item is included in this price
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public LocalizedPriceSupplier promotionalDiscountPercent(Float promotionalDiscountPercent) {
    
    this.promotionalDiscountPercent = promotionalDiscountPercent;
    return this;
  }

   /**
   * Promotional discount percent
   * @return promotionalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPromotionalDiscountPercent() {
    return promotionalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
    this.promotionalDiscountPercent = promotionalDiscountPercent;
  }


  public LocalizedPriceSupplier channelDiscountPercent(Float channelDiscountPercent) {
    
    this.channelDiscountPercent = channelDiscountPercent;
    return this;
  }

   /**
   * Channel discount percent
   * @return channelDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getChannelDiscountPercent() {
    return channelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDiscountPercent(Float channelDiscountPercent) {
    this.channelDiscountPercent = channelDiscountPercent;
  }


  public LocalizedPriceSupplier premiumPercent(Float premiumPercent) {
    
    this.premiumPercent = premiumPercent;
    return this;
  }

   /**
   * Premium percent
   * @return premiumPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPremiumPercent() {
    return premiumPercent;
  }


  @JsonProperty(JSON_PROPERTY_PREMIUM_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPremiumPercent(Float premiumPercent) {
    this.premiumPercent = premiumPercent;
  }


  public LocalizedPriceSupplier hasPremium(Boolean hasPremium) {
    
    this.hasPremium = hasPremium;
    return this;
  }

   /**
   * Get hasPremium
   * @return hasPremium
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPremium() {
    return hasPremium;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PREMIUM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPremium(Boolean hasPremium) {
    this.hasPremium = hasPremium;
  }


  public LocalizedPriceSupplier hasPromotion(Boolean hasPromotion) {
    
    this.hasPromotion = hasPromotion;
    return this;
  }

   /**
   * Get hasPromotion
   * @return hasPromotion
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPromotion() {
    return hasPromotion;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PROMOTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPromotion(Boolean hasPromotion) {
    this.hasPromotion = hasPromotion;
  }


  public LocalizedPriceSupplier hasChannelDiscount(Boolean hasChannelDiscount) {
    
    this.hasChannelDiscount = hasChannelDiscount;
    return this;
  }

   /**
   * Get hasChannelDiscount
   * @return hasChannelDiscount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasChannelDiscount() {
    return hasChannelDiscount;
  }


  @JsonProperty(JSON_PROPERTY_HAS_CHANNEL_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasChannelDiscount(Boolean hasChannelDiscount) {
    this.hasChannelDiscount = hasChannelDiscount;
  }


  public LocalizedPriceSupplier userSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

   /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }


  public LocalizedPriceSupplier internalTotal(CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

   /**
   * Get internalTotal
   * @return internalTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  public LocalizedPriceSupplier sourceTotal(CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

   /**
   * Get sourceTotal
   * @return sourceTotal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }


  public LocalizedPriceSupplier totalDiscountPercent(Float totalDiscountPercent) {
    
    this.totalDiscountPercent = totalDiscountPercent;
    return this;
  }

   /**
   * Get totalDiscountPercent
   * @return totalDiscountPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalDiscountPercent() {
    return totalDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalDiscountPercent(Float totalDiscountPercent) {
    this.totalDiscountPercent = totalDiscountPercent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalizedPriceSupplier localizedPriceSupplier = (LocalizedPriceSupplier) o;
    return Objects.equals(this.sourceToUserCurrencyQuote, localizedPriceSupplier.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, localizedPriceSupplier.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.userSpecifiedCurrencyBaseTotal, localizedPriceSupplier.userSpecifiedCurrencyBaseTotal) &&
        Objects.equals(this.sourceBaseTotal, localizedPriceSupplier.sourceBaseTotal) &&
        Objects.equals(this.internalBaseTotal, localizedPriceSupplier.internalBaseTotal) &&
        Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, localizedPriceSupplier.userSpecifiedCurrencyPromotionalModifier) &&
        Objects.equals(this.sourcePromotionalModifier, localizedPriceSupplier.sourcePromotionalModifier) &&
        Objects.equals(this.internalPromotionalModifier, localizedPriceSupplier.internalPromotionalModifier) &&
        Objects.equals(this.userSpecifiedCurrencyPremiumModifier, localizedPriceSupplier.userSpecifiedCurrencyPremiumModifier) &&
        Objects.equals(this.sourcePremiumModifier, localizedPriceSupplier.sourcePremiumModifier) &&
        Objects.equals(this.internalPremiumModifier, localizedPriceSupplier.internalPremiumModifier) &&
        Objects.equals(this.userSpecifiedCurrencyChannelModifier, localizedPriceSupplier.userSpecifiedCurrencyChannelModifier) &&
        Objects.equals(this.sourceChannelModifier, localizedPriceSupplier.sourceChannelModifier) &&
        Objects.equals(this.internalChannelModifier, localizedPriceSupplier.internalChannelModifier) &&
        Objects.equals(this.quantity, localizedPriceSupplier.quantity) &&
        Objects.equals(this.promotionalDiscountPercent, localizedPriceSupplier.promotionalDiscountPercent) &&
        Objects.equals(this.channelDiscountPercent, localizedPriceSupplier.channelDiscountPercent) &&
        Objects.equals(this.premiumPercent, localizedPriceSupplier.premiumPercent) &&
        Objects.equals(this.hasPremium, localizedPriceSupplier.hasPremium) &&
        Objects.equals(this.hasPromotion, localizedPriceSupplier.hasPromotion) &&
        Objects.equals(this.hasChannelDiscount, localizedPriceSupplier.hasChannelDiscount) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, localizedPriceSupplier.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, localizedPriceSupplier.internalTotal) &&
        Objects.equals(this.sourceTotal, localizedPriceSupplier.sourceTotal) &&
        Objects.equals(this.totalDiscountPercent, localizedPriceSupplier.totalDiscountPercent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, userSpecifiedCurrencyBaseTotal, sourceBaseTotal, internalBaseTotal, userSpecifiedCurrencyPromotionalModifier, sourcePromotionalModifier, internalPromotionalModifier, userSpecifiedCurrencyPremiumModifier, sourcePremiumModifier, internalPremiumModifier, userSpecifiedCurrencyChannelModifier, sourceChannelModifier, internalChannelModifier, quantity, promotionalDiscountPercent, channelDiscountPercent, premiumPercent, hasPremium, hasPromotion, hasChannelDiscount, userSpecifiedCurrencyTotal, internalTotal, sourceTotal, totalDiscountPercent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalizedPriceSupplier {\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    userSpecifiedCurrencyBaseTotal: ").append(toIndentedString(userSpecifiedCurrencyBaseTotal)).append("\n");
    sb.append("    sourceBaseTotal: ").append(toIndentedString(sourceBaseTotal)).append("\n");
    sb.append("    internalBaseTotal: ").append(toIndentedString(internalBaseTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(toIndentedString(userSpecifiedCurrencyPromotionalModifier)).append("\n");
    sb.append("    sourcePromotionalModifier: ").append(toIndentedString(sourcePromotionalModifier)).append("\n");
    sb.append("    internalPromotionalModifier: ").append(toIndentedString(internalPromotionalModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(toIndentedString(userSpecifiedCurrencyPremiumModifier)).append("\n");
    sb.append("    sourcePremiumModifier: ").append(toIndentedString(sourcePremiumModifier)).append("\n");
    sb.append("    internalPremiumModifier: ").append(toIndentedString(internalPremiumModifier)).append("\n");
    sb.append("    userSpecifiedCurrencyChannelModifier: ").append(toIndentedString(userSpecifiedCurrencyChannelModifier)).append("\n");
    sb.append("    sourceChannelModifier: ").append(toIndentedString(sourceChannelModifier)).append("\n");
    sb.append("    internalChannelModifier: ").append(toIndentedString(internalChannelModifier)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    promotionalDiscountPercent: ").append(toIndentedString(promotionalDiscountPercent)).append("\n");
    sb.append("    channelDiscountPercent: ").append(toIndentedString(channelDiscountPercent)).append("\n");
    sb.append("    premiumPercent: ").append(toIndentedString(premiumPercent)).append("\n");
    sb.append("    hasPremium: ").append(toIndentedString(hasPremium)).append("\n");
    sb.append("    hasPromotion: ").append(toIndentedString(hasPromotion)).append("\n");
    sb.append("    hasChannelDiscount: ").append(toIndentedString(hasChannelDiscount)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    totalDiscountPercent: ").append(toIndentedString(totalDiscountPercent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

