package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.RateModifierBundleViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertRateModifierBundleRequestSupplier;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion bundle and associate with this hotel identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createRateModifierBundleRequestCreation(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierBundleRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierBundleRequestSupplier' is set
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion bundle and associate with this hotel identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> createRateModifierBundle(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion bundle and associate with this hotel identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> createRateModifierBundleWithHttpInfo(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Promotion Bundle
     * Create a new rate modifier ancillary
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param hotelIdentifier Create new promotion bundle and associate with this hotel identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createRateModifierBundleWithResponseSpec(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }
    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseSupplier> removeRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>() {};
        return removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Promotion Bundle
     * Delete a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param hotelIdentifier Remove a promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Remove a promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> showRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> showRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Promotion Bundle
     * Retrieve a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show single promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Show single promotion bundle with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }
    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotion bundles owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showRateModifierBundlesRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotion bundles owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<RateModifierBundleViewSupplier> showRateModifierBundles(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotion bundles owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;RateModifierBundleViewSupplier&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<RateModifierBundleViewSupplier>>> showRateModifierBundlesWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Promotion Bundles
     * Retrieve list of rate modifier bundles
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show all promotion bundles owned by this hotel identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showRateModifierBundlesWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept);
    }
    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertRateModifierBundleRequestSupplier;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'promotionBundleIdentifier' is set
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertRateModifierBundleRequestSupplier' is set
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return RateModifierBundleViewSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RateModifierBundleViewSupplier> updateRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RateModifierBundleViewSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> updateRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>() {};
        return updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Promotion Bundle
     * Update a rate modifier ancillary by its identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing promotion bundle owned by this hotel identifier.
     * @param promotionBundleIdentifier Update existing promotion bundle with this identifier.
     * @param upsertRateModifierBundleRequestSupplier The upsertRateModifierBundleRequestSupplier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }
}
