/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.extranet.model.AutoBaseUnitStepsSupplier;
import travel.wink.sdk.extranet.model.AxisLineSupplier;
import travel.wink.sdk.extranet.model.AxisTicksSupplier;
import travel.wink.sdk.extranet.model.CategoryAxisCrosshairSupplier;
import travel.wink.sdk.extranet.model.CategoryAxisNotesSupplier;
import travel.wink.sdk.extranet.model.CategoryAxisSelectSupplier;
import travel.wink.sdk.extranet.model.CategoryAxisTitleSupplier;
import travel.wink.sdk.extranet.model.ChartCategoryAxisLabelsSupplier;
import travel.wink.sdk.extranet.model.ChartCategoryAxisMajorGridLinesSupplier;
import travel.wink.sdk.extranet.model.GridLinesSupplier;
import travel.wink.sdk.extranet.model.PlotBandSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The configuration options of the category axis.
 */
@JsonPropertyOrder({
  ChartCategoryAxisSupplier.JSON_PROPERTY_AUTO_BASE_UNIT_STEPS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_AXIS_CROSSING_VALUE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_BACKGROUND,
  ChartCategoryAxisSupplier.JSON_PROPERTY_BASE_UNIT,
  ChartCategoryAxisSupplier.JSON_PROPERTY_BASE_UNIT_STEP,
  ChartCategoryAxisSupplier.JSON_PROPERTY_CATEGORIES,
  ChartCategoryAxisSupplier.JSON_PROPERTY_COLOR,
  ChartCategoryAxisSupplier.JSON_PROPERTY_JUSTIFIED,
  ChartCategoryAxisSupplier.JSON_PROPERTY_LINE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MAJOR_GRID_LINES,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MAJOR_TICKS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MAX,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MAX_DATE_GROUPS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MAX_DIVISIONS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MIN,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MINOR_GRID_LINES,
  ChartCategoryAxisSupplier.JSON_PROPERTY_MINOR_TICKS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_NAME,
  ChartCategoryAxisSupplier.JSON_PROPERTY_PANE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_PLOT_BANDS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_REVERSE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_ROUND_TO_BASE_UNIT,
  ChartCategoryAxisSupplier.JSON_PROPERTY_START_ANGLE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_TYPE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_VISIBLE,
  ChartCategoryAxisSupplier.JSON_PROPERTY_WEEK_START_DAY,
  ChartCategoryAxisSupplier.JSON_PROPERTY_CROSSHAIR,
  ChartCategoryAxisSupplier.JSON_PROPERTY_LABELS,
  ChartCategoryAxisSupplier.JSON_PROPERTY_NOTES,
  ChartCategoryAxisSupplier.JSON_PROPERTY_SELECT,
  ChartCategoryAxisSupplier.JSON_PROPERTY_TITLE
})
@JsonTypeName("ChartCategoryAxis_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class ChartCategoryAxisSupplier {
  public static final String JSON_PROPERTY_AUTO_BASE_UNIT_STEPS = "autoBaseUnitSteps";
  private AutoBaseUnitStepsSupplier autoBaseUnitSteps;

  public static final String JSON_PROPERTY_AXIS_CROSSING_VALUE = "axisCrossingValue";
  private List<Object> axisCrossingValue;

  public static final String JSON_PROPERTY_BACKGROUND = "background";
  private String background;

  /**
   * The base time interval for the date axis. The default base unit is automatically determined by the minimum difference between subsequent categories. The supported values are:   - &#x60;fit&#x60; - &#x60;milliseconds&#x60; - &#x60;seconds&#x60; - &#x60;minutes&#x60; - &#x60;hours&#x60; - &#x60;days&#x60; - &#x60;weeks&#x60; - &#x60;months&#x60; - &#x60;years&#x60; Setting &#x60;baseUnit&#x60; to &#x60;fit&#x60; sets such a base unit and &#x60;categoryAxis.baseUnitStep&#x60; that the total Number of categories does not exceed &#x60;categoryAxis.maxDateGroups&#x60;. Series data is aggregated for the specified base unit by using the &#x60;series.aggregate&#x60; function.
   */
  public enum BaseUnitEnum {
    MILLISECONDS("milliseconds"),
    
    SECONDS("seconds"),
    
    MINUTES("minutes"),
    
    HOURS("hours"),
    
    DAYS("days"),
    
    WEEKS("weeks"),
    
    MONTHS("months"),
    
    YEARS("years"),
    
    AUTO("auto"),
    
    FIT("fit");

    private String value;

    BaseUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BaseUnitEnum fromValue(String value) {
      for (BaseUnitEnum b : BaseUnitEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BASE_UNIT = "baseUnit";
  private BaseUnitEnum baseUnit;

  public static final String JSON_PROPERTY_BASE_UNIT_STEP = "baseUnitStep";
  private BigDecimal baseUnitStep;

  public static final String JSON_PROPERTY_CATEGORIES = "categories";
  private List<String> categories;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  public static final String JSON_PROPERTY_JUSTIFIED = "justified";
  private Boolean justified;

  public static final String JSON_PROPERTY_LINE = "line";
  private AxisLineSupplier line;

  public static final String JSON_PROPERTY_MAJOR_GRID_LINES = "majorGridLines";
  private ChartCategoryAxisMajorGridLinesSupplier majorGridLines;

  public static final String JSON_PROPERTY_MAJOR_TICKS = "majorTicks";
  private AxisTicksSupplier majorTicks;

  public static final String JSON_PROPERTY_MAX = "max";
  private java.time.LocalDateTime max;

  public static final String JSON_PROPERTY_MAX_DATE_GROUPS = "maxDateGroups";
  private BigDecimal maxDateGroups;

  public static final String JSON_PROPERTY_MAX_DIVISIONS = "maxDivisions";
  private BigDecimal maxDivisions;

  public static final String JSON_PROPERTY_MIN = "min";
  private java.time.LocalDateTime min;

  public static final String JSON_PROPERTY_MINOR_GRID_LINES = "minorGridLines";
  private GridLinesSupplier minorGridLines;

  public static final String JSON_PROPERTY_MINOR_TICKS = "minorTicks";
  private AxisTicksSupplier minorTicks;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PANE = "pane";
  private String pane;

  public static final String JSON_PROPERTY_PLOT_BANDS = "plotBands";
  private List<PlotBandSupplier> plotBands;

  public static final String JSON_PROPERTY_REVERSE = "reverse";
  private Boolean reverse;

  public static final String JSON_PROPERTY_ROUND_TO_BASE_UNIT = "roundToBaseUnit";
  private Boolean roundToBaseUnit;

  public static final String JSON_PROPERTY_START_ANGLE = "startAngle";
  private BigDecimal startAngle;

  /**
   * The category axis type. The supported values are:  - &#x60;category&#x60; Discrete category axis.- &#x60;date&#x60;  Specialized axis for displaying chronological data.
   */
  public enum TypeEnum {
    CATEGORY("category"),
    
    DATE("date");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VISIBLE = "visible";
  private Boolean visible;

  /**
   * The week start day when the &#x60;baseUnit&#x60; is set to &#x60;weeks&#x60;.
   */
  public enum WeekStartDayEnum {
    SUNDAY("Sunday"),
    
    MONDAY("Monday"),
    
    TUESDAY("Tuesday"),
    
    WEDNESDAY("Wednesday"),
    
    THURSDAY("Thursday"),
    
    FRIDAY("Friday"),
    
    SATURDAY("Saturday");

    private String value;

    WeekStartDayEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WeekStartDayEnum fromValue(String value) {
      for (WeekStartDayEnum b : WeekStartDayEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WEEK_START_DAY = "weekStartDay";
  private WeekStartDayEnum weekStartDay;

  public static final String JSON_PROPERTY_CROSSHAIR = "crosshair";
  private CategoryAxisCrosshairSupplier crosshair;

  public static final String JSON_PROPERTY_LABELS = "labels";
  private ChartCategoryAxisLabelsSupplier labels;

  public static final String JSON_PROPERTY_NOTES = "notes";
  private CategoryAxisNotesSupplier notes;

  public static final String JSON_PROPERTY_SELECT = "select";
  private CategoryAxisSelectSupplier select;

  public static final String JSON_PROPERTY_TITLE = "title";
  private CategoryAxisTitleSupplier title;

  public ChartCategoryAxisSupplier() {
  }

  public ChartCategoryAxisSupplier autoBaseUnitSteps(AutoBaseUnitStepsSupplier autoBaseUnitSteps) {
    
    this.autoBaseUnitSteps = autoBaseUnitSteps;
    return this;
  }

   /**
   * Get autoBaseUnitSteps
   * @return autoBaseUnitSteps
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AUTO_BASE_UNIT_STEPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AutoBaseUnitStepsSupplier getAutoBaseUnitSteps() {
    return autoBaseUnitSteps;
  }


  @JsonProperty(JSON_PROPERTY_AUTO_BASE_UNIT_STEPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAutoBaseUnitSteps(AutoBaseUnitStepsSupplier autoBaseUnitSteps) {
    this.autoBaseUnitSteps = autoBaseUnitSteps;
  }


  public ChartCategoryAxisSupplier axisCrossingValue(List<Object> axisCrossingValue) {
    
    this.axisCrossingValue = axisCrossingValue;
    return this;
  }

  public ChartCategoryAxisSupplier addAxisCrossingValueItem(Object axisCrossingValueItem) {
    if (this.axisCrossingValue == null) {
      this.axisCrossingValue = new ArrayList<>();
    }
    this.axisCrossingValue.add(axisCrossingValueItem);
    return this;
  }

   /**
   * The category index or the date (for date category axis) at which the first value axis crosses this axis. The category indices or the date (for date category axis) at which the value axes cross the category axis (when set as an array). To denote the far end of the axis, set an index greater than or equal to the Number of categories.
   * @return axisCrossingValue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getAxisCrossingValue() {
    return axisCrossingValue;
  }


  @JsonProperty(JSON_PROPERTY_AXIS_CROSSING_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAxisCrossingValue(List<Object> axisCrossingValue) {
    this.axisCrossingValue = axisCrossingValue;
  }


  public ChartCategoryAxisSupplier background(String background) {
    
    this.background = background;
    return this;
  }

   /**
   * The background color of the axis.
   * @return background
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBackground() {
    return background;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackground(String background) {
    this.background = background;
  }


  public ChartCategoryAxisSupplier baseUnit(BaseUnitEnum baseUnit) {
    
    this.baseUnit = baseUnit;
    return this;
  }

   /**
   * The base time interval for the date axis. The default base unit is automatically determined by the minimum difference between subsequent categories. The supported values are:   - &#x60;fit&#x60; - &#x60;milliseconds&#x60; - &#x60;seconds&#x60; - &#x60;minutes&#x60; - &#x60;hours&#x60; - &#x60;days&#x60; - &#x60;weeks&#x60; - &#x60;months&#x60; - &#x60;years&#x60; Setting &#x60;baseUnit&#x60; to &#x60;fit&#x60; sets such a base unit and &#x60;categoryAxis.baseUnitStep&#x60; that the total Number of categories does not exceed &#x60;categoryAxis.maxDateGroups&#x60;. Series data is aggregated for the specified base unit by using the &#x60;series.aggregate&#x60; function.
   * @return baseUnit
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BaseUnitEnum getBaseUnit() {
    return baseUnit;
  }


  @JsonProperty(JSON_PROPERTY_BASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseUnit(BaseUnitEnum baseUnit) {
    this.baseUnit = baseUnit;
  }


  public ChartCategoryAxisSupplier baseUnitStep(BigDecimal baseUnitStep) {
    
    this.baseUnitStep = baseUnitStep;
    return this;
  }

   /**
   * The step (interval) between the categories in base units. Setting it to &#x60;auto&#x60; sets the step to such a value that the total Number of categories does not exceed &#x60;categoryAxis.maxDateGroups&#x60;. The option is ignored if &#x60;categoryAxis.baseUnit&#x60; is set to &#x60;fit&#x60;.
   * @return baseUnitStep
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_UNIT_STEP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getBaseUnitStep() {
    return baseUnitStep;
  }


  @JsonProperty(JSON_PROPERTY_BASE_UNIT_STEP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseUnitStep(BigDecimal baseUnitStep) {
    this.baseUnitStep = baseUnitStep;
  }


  public ChartCategoryAxisSupplier categories(List<String> categories) {
    
    this.categories = categories;
    return this;
  }

  public ChartCategoryAxisSupplier addCategoriesItem(String categoriesItem) {
    if (this.categories == null) {
      this.categories = new ArrayList<>();
    }
    this.categories.add(categoriesItem);
    return this;
  }

   /**
   * The category names. The Chart creates a category for every item of the array.
   * @return categories
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCategories() {
    return categories;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategories(List<String> categories) {
    this.categories = categories;
  }


  public ChartCategoryAxisSupplier color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * The color to apply to all axis elements. Accepts a valid CSS color String, including hex and rgb. Can be overridden by &#x60;categoryAxis.labels.color&#x60; and &#x60;categoryAxis.line.color&#x60;.
   * @return color
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public ChartCategoryAxisSupplier justified(Boolean justified) {
    
    this.justified = justified;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart positions categories and series points on major ticks. This removes the empty space before and after the series. The default value is &#x60;false&#x60; except for &#x60;area&#x60;, &#x60;verticalArea&#x60;, &#x60;rangeArea&#x60;, and &#x60;verticalRangeArea&#x60;. The option is ignored if the &#x60;series.type&#x60; option is set to &#x60;bar&#x60;, &#x60;column&#x60;, &#x60;boxPlot&#x60;, &#x60;ohlc&#x60;, &#x60;candlestick&#x60;, or &#x60;waterfall&#x60;.
   * @return justified
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_JUSTIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getJustified() {
    return justified;
  }


  @JsonProperty(JSON_PROPERTY_JUSTIFIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJustified(Boolean justified) {
    this.justified = justified;
  }


  public ChartCategoryAxisSupplier line(AxisLineSupplier line) {
    
    this.line = line;
    return this;
  }

   /**
   * Get line
   * @return line
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AxisLineSupplier getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(AxisLineSupplier line) {
    this.line = line;
  }


  public ChartCategoryAxisSupplier majorGridLines(ChartCategoryAxisMajorGridLinesSupplier majorGridLines) {
    
    this.majorGridLines = majorGridLines;
    return this;
  }

   /**
   * Get majorGridLines
   * @return majorGridLines
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MAJOR_GRID_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisMajorGridLinesSupplier getMajorGridLines() {
    return majorGridLines;
  }


  @JsonProperty(JSON_PROPERTY_MAJOR_GRID_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMajorGridLines(ChartCategoryAxisMajorGridLinesSupplier majorGridLines) {
    this.majorGridLines = majorGridLines;
  }


  public ChartCategoryAxisSupplier majorTicks(AxisTicksSupplier majorTicks) {
    
    this.majorTicks = majorTicks;
    return this;
  }

   /**
   * Get majorTicks
   * @return majorTicks
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MAJOR_TICKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AxisTicksSupplier getMajorTicks() {
    return majorTicks;
  }


  @JsonProperty(JSON_PROPERTY_MAJOR_TICKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMajorTicks(AxisTicksSupplier majorTicks) {
    this.majorTicks = majorTicks;
  }


  public ChartCategoryAxisSupplier max(java.time.LocalDateTime max) {
    
    this.max = max;
    return this;
  }

   /**
   * The last date displayed on a date category axis or the index of the last category displayed on a category axis. By default, the max value is the same as the last category. This is often used in combination with the &#x60;categoryAxis.min&#x60; and &#x60;categoryAxis.roundToBaseUnit&#x60; options to set up a fixed date range.
   * @return max
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getMax() {
    return max;
  }


  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMax(java.time.LocalDateTime max) {
    this.max = max;
  }


  public ChartCategoryAxisSupplier maxDateGroups(BigDecimal maxDateGroups) {
    
    this.maxDateGroups = maxDateGroups;
    return this;
  }

   /**
   * The maximum Number of groups (categories) to display when &#x60;categoryAxis.baseUnit&#x60; is set to &#x60;fit&#x60; or &#x60;categoryAxis.baseUnitStep&#x60; is set to &#x60;auto&#x60;.
   * @return maxDateGroups
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MAX_DATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxDateGroups() {
    return maxDateGroups;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDateGroups(BigDecimal maxDateGroups) {
    this.maxDateGroups = maxDateGroups;
  }


  public ChartCategoryAxisSupplier maxDivisions(BigDecimal maxDivisions) {
    
    this.maxDivisions = maxDivisions;
    return this;
  }

   /**
   * The maximum Number of ticks and labels to display. Applicabable for date category axis.
   * @return maxDivisions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MAX_DIVISIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxDivisions() {
    return maxDivisions;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DIVISIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDivisions(BigDecimal maxDivisions) {
    this.maxDivisions = maxDivisions;
  }


  public ChartCategoryAxisSupplier min(java.time.LocalDateTime min) {
    
    this.min = min;
    return this;
  }

   /**
   * The first date which is displayed on a date category axis or the index of the first category whcih is displayed on a category axis. By default, the min value is the same as the first category. This is often used in combination with the &#x60;categoryAxis.max&#x60; and &#x60;categoryAxis.roundToBaseUnit&#x60; options to set up a fixed date range.
   * @return min
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getMin() {
    return min;
  }


  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMin(java.time.LocalDateTime min) {
    this.min = min;
  }


  public ChartCategoryAxisSupplier minorGridLines(GridLinesSupplier minorGridLines) {
    
    this.minorGridLines = minorGridLines;
    return this;
  }

   /**
   * Get minorGridLines
   * @return minorGridLines
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MINOR_GRID_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GridLinesSupplier getMinorGridLines() {
    return minorGridLines;
  }


  @JsonProperty(JSON_PROPERTY_MINOR_GRID_LINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinorGridLines(GridLinesSupplier minorGridLines) {
    this.minorGridLines = minorGridLines;
  }


  public ChartCategoryAxisSupplier minorTicks(AxisTicksSupplier minorTicks) {
    
    this.minorTicks = minorTicks;
    return this;
  }

   /**
   * Get minorTicks
   * @return minorTicks
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MINOR_TICKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AxisTicksSupplier getMinorTicks() {
    return minorTicks;
  }


  @JsonProperty(JSON_PROPERTY_MINOR_TICKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinorTicks(AxisTicksSupplier minorTicks) {
    this.minorTicks = minorTicks;
  }


  public ChartCategoryAxisSupplier name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The unique axis name. Used to associate a series with a category axis, which utilizes the &#x60;series.categoryAxis&#x60; option.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ChartCategoryAxisSupplier pane(String pane) {
    
    this.pane = pane;
    return this;
  }

   /**
   * The name of the pane in which the category axis has to be rendered. If not set, the axis will be rendered in the first (default) pane.
   * @return pane
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PANE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPane() {
    return pane;
  }


  @JsonProperty(JSON_PROPERTY_PANE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPane(String pane) {
    this.pane = pane;
  }


  public ChartCategoryAxisSupplier plotBands(List<PlotBandSupplier> plotBands) {
    
    this.plotBands = plotBands;
    return this;
  }

  public ChartCategoryAxisSupplier addPlotBandsItem(PlotBandSupplier plotBandsItem) {
    if (this.plotBands == null) {
      this.plotBands = new ArrayList<>();
    }
    this.plotBands.add(plotBandsItem);
    return this;
  }

   /**
   * The plot bands of the category axis.
   * @return plotBands
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLOT_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PlotBandSupplier> getPlotBands() {
    return plotBands;
  }


  @JsonProperty(JSON_PROPERTY_PLOT_BANDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlotBands(List<PlotBandSupplier> plotBands) {
    this.plotBands = plotBands;
  }


  public ChartCategoryAxisSupplier reverse(Boolean reverse) {
    
    this.reverse = reverse;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the category axis direction is reversed. By default, categories are listed from left to right and from bottom to top.
   * @return reverse
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REVERSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReverse() {
    return reverse;
  }


  @JsonProperty(JSON_PROPERTY_REVERSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReverse(Boolean reverse) {
    this.reverse = reverse;
  }


  public ChartCategoryAxisSupplier roundToBaseUnit(Boolean roundToBaseUnit) {
    
    this.roundToBaseUnit = roundToBaseUnit;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart rounds the first and last date to the nearest base unit.
   * @return roundToBaseUnit
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROUND_TO_BASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRoundToBaseUnit() {
    return roundToBaseUnit;
  }


  @JsonProperty(JSON_PROPERTY_ROUND_TO_BASE_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoundToBaseUnit(Boolean roundToBaseUnit) {
    this.roundToBaseUnit = roundToBaseUnit;
  }


  public ChartCategoryAxisSupplier startAngle(BigDecimal startAngle) {
    
    this.startAngle = startAngle;
    return this;
  }

   /**
   * The angle (degrees) of the first category on the axis. Angles increase clockwise with zero to the left. Negative values are acceptable.
   * @return startAngle
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getStartAngle() {
    return startAngle;
  }


  @JsonProperty(JSON_PROPERTY_START_ANGLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartAngle(BigDecimal startAngle) {
    this.startAngle = startAngle;
  }


  public ChartCategoryAxisSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The category axis type. The supported values are:  - &#x60;category&#x60; Discrete category axis.- &#x60;date&#x60;  Specialized axis for displaying chronological data.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ChartCategoryAxisSupplier visible(Boolean visible) {
    
    this.visible = visible;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart displays the category axis. By default, the category axis is visible.
   * @return visible
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVisible() {
    return visible;
  }


  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }


  public ChartCategoryAxisSupplier weekStartDay(WeekStartDayEnum weekStartDay) {
    
    this.weekStartDay = weekStartDay;
    return this;
  }

   /**
   * The week start day when the &#x60;baseUnit&#x60; is set to &#x60;weeks&#x60;.
   * @return weekStartDay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEEK_START_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WeekStartDayEnum getWeekStartDay() {
    return weekStartDay;
  }


  @JsonProperty(JSON_PROPERTY_WEEK_START_DAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWeekStartDay(WeekStartDayEnum weekStartDay) {
    this.weekStartDay = weekStartDay;
  }


  public ChartCategoryAxisSupplier crosshair(CategoryAxisCrosshairSupplier crosshair) {
    
    this.crosshair = crosshair;
    return this;
  }

   /**
   * Get crosshair
   * @return crosshair
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CROSSHAIR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryAxisCrosshairSupplier getCrosshair() {
    return crosshair;
  }


  @JsonProperty(JSON_PROPERTY_CROSSHAIR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCrosshair(CategoryAxisCrosshairSupplier crosshair) {
    this.crosshair = crosshair;
  }


  public ChartCategoryAxisSupplier labels(ChartCategoryAxisLabelsSupplier labels) {
    
    this.labels = labels;
    return this;
  }

   /**
   * Get labels
   * @return labels
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisLabelsSupplier getLabels() {
    return labels;
  }


  @JsonProperty(JSON_PROPERTY_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabels(ChartCategoryAxisLabelsSupplier labels) {
    this.labels = labels;
  }


  public ChartCategoryAxisSupplier notes(CategoryAxisNotesSupplier notes) {
    
    this.notes = notes;
    return this;
  }

   /**
   * Get notes
   * @return notes
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryAxisNotesSupplier getNotes() {
    return notes;
  }


  @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotes(CategoryAxisNotesSupplier notes) {
    this.notes = notes;
  }


  public ChartCategoryAxisSupplier select(CategoryAxisSelectSupplier select) {
    
    this.select = select;
    return this;
  }

   /**
   * Get select
   * @return select
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryAxisSelectSupplier getSelect() {
    return select;
  }


  @JsonProperty(JSON_PROPERTY_SELECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelect(CategoryAxisSelectSupplier select) {
    this.select = select;
  }


  public ChartCategoryAxisSupplier title(CategoryAxisTitleSupplier title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CategoryAxisTitleSupplier getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(CategoryAxisTitleSupplier title) {
    this.title = title;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChartCategoryAxisSupplier chartCategoryAxisSupplier = (ChartCategoryAxisSupplier) o;
    return Objects.equals(this.autoBaseUnitSteps, chartCategoryAxisSupplier.autoBaseUnitSteps) &&
        Objects.equals(this.axisCrossingValue, chartCategoryAxisSupplier.axisCrossingValue) &&
        Objects.equals(this.background, chartCategoryAxisSupplier.background) &&
        Objects.equals(this.baseUnit, chartCategoryAxisSupplier.baseUnit) &&
        Objects.equals(this.baseUnitStep, chartCategoryAxisSupplier.baseUnitStep) &&
        Objects.equals(this.categories, chartCategoryAxisSupplier.categories) &&
        Objects.equals(this.color, chartCategoryAxisSupplier.color) &&
        Objects.equals(this.justified, chartCategoryAxisSupplier.justified) &&
        Objects.equals(this.line, chartCategoryAxisSupplier.line) &&
        Objects.equals(this.majorGridLines, chartCategoryAxisSupplier.majorGridLines) &&
        Objects.equals(this.majorTicks, chartCategoryAxisSupplier.majorTicks) &&
        Objects.equals(this.max, chartCategoryAxisSupplier.max) &&
        Objects.equals(this.maxDateGroups, chartCategoryAxisSupplier.maxDateGroups) &&
        Objects.equals(this.maxDivisions, chartCategoryAxisSupplier.maxDivisions) &&
        Objects.equals(this.min, chartCategoryAxisSupplier.min) &&
        Objects.equals(this.minorGridLines, chartCategoryAxisSupplier.minorGridLines) &&
        Objects.equals(this.minorTicks, chartCategoryAxisSupplier.minorTicks) &&
        Objects.equals(this.name, chartCategoryAxisSupplier.name) &&
        Objects.equals(this.pane, chartCategoryAxisSupplier.pane) &&
        Objects.equals(this.plotBands, chartCategoryAxisSupplier.plotBands) &&
        Objects.equals(this.reverse, chartCategoryAxisSupplier.reverse) &&
        Objects.equals(this.roundToBaseUnit, chartCategoryAxisSupplier.roundToBaseUnit) &&
        Objects.equals(this.startAngle, chartCategoryAxisSupplier.startAngle) &&
        Objects.equals(this.type, chartCategoryAxisSupplier.type) &&
        Objects.equals(this.visible, chartCategoryAxisSupplier.visible) &&
        Objects.equals(this.weekStartDay, chartCategoryAxisSupplier.weekStartDay) &&
        Objects.equals(this.crosshair, chartCategoryAxisSupplier.crosshair) &&
        Objects.equals(this.labels, chartCategoryAxisSupplier.labels) &&
        Objects.equals(this.notes, chartCategoryAxisSupplier.notes) &&
        Objects.equals(this.select, chartCategoryAxisSupplier.select) &&
        Objects.equals(this.title, chartCategoryAxisSupplier.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoBaseUnitSteps, axisCrossingValue, background, baseUnit, baseUnitStep, categories, color, justified, line, majorGridLines, majorTicks, max, maxDateGroups, maxDivisions, min, minorGridLines, minorTicks, name, pane, plotBands, reverse, roundToBaseUnit, startAngle, type, visible, weekStartDay, crosshair, labels, notes, select, title);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChartCategoryAxisSupplier {\n");
    sb.append("    autoBaseUnitSteps: ").append(toIndentedString(autoBaseUnitSteps)).append("\n");
    sb.append("    axisCrossingValue: ").append(toIndentedString(axisCrossingValue)).append("\n");
    sb.append("    background: ").append(toIndentedString(background)).append("\n");
    sb.append("    baseUnit: ").append(toIndentedString(baseUnit)).append("\n");
    sb.append("    baseUnitStep: ").append(toIndentedString(baseUnitStep)).append("\n");
    sb.append("    categories: ").append(toIndentedString(categories)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    justified: ").append(toIndentedString(justified)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    majorGridLines: ").append(toIndentedString(majorGridLines)).append("\n");
    sb.append("    majorTicks: ").append(toIndentedString(majorTicks)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    maxDateGroups: ").append(toIndentedString(maxDateGroups)).append("\n");
    sb.append("    maxDivisions: ").append(toIndentedString(maxDivisions)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    minorGridLines: ").append(toIndentedString(minorGridLines)).append("\n");
    sb.append("    minorTicks: ").append(toIndentedString(minorTicks)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    pane: ").append(toIndentedString(pane)).append("\n");
    sb.append("    plotBands: ").append(toIndentedString(plotBands)).append("\n");
    sb.append("    reverse: ").append(toIndentedString(reverse)).append("\n");
    sb.append("    roundToBaseUnit: ").append(toIndentedString(roundToBaseUnit)).append("\n");
    sb.append("    startAngle: ").append(toIndentedString(startAngle)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("    weekStartDay: ").append(toIndentedString(weekStartDay)).append("\n");
    sb.append("    crosshair: ").append(toIndentedString(crosshair)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
    sb.append("    select: ").append(toIndentedString(select)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

