/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.extranet.model.ChartCategoryAxisSupplier;
import travel.wink.sdk.extranet.model.ChartLegendSupplier;
import travel.wink.sdk.extranet.model.ChartSeriesDefaultsSupplier;
import travel.wink.sdk.extranet.model.ChartSeriesSupplier;
import travel.wink.sdk.extranet.model.ChartTitleSupplier;
import travel.wink.sdk.extranet.model.ChartTooltipSupplier;
import travel.wink.sdk.extranet.model.ChartValueAxisSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Interesting property-level chart data overview
 */
@JsonPropertyOrder({
  LineChartSupplier.JSON_PROPERTY_IDENTIFIER,
  LineChartSupplier.JSON_PROPERTY_TITLE,
  LineChartSupplier.JSON_PROPERTY_LEGEND,
  LineChartSupplier.JSON_PROPERTY_SERIES_DEFAULTS,
  LineChartSupplier.JSON_PROPERTY_SERIES,
  LineChartSupplier.JSON_PROPERTY_VALUE_AXIS,
  LineChartSupplier.JSON_PROPERTY_CATEGORY_AXIS,
  LineChartSupplier.JSON_PROPERTY_TOOLTIP,
  LineChartSupplier.JSON_PROPERTY_RENDER_AS,
  LineChartSupplier.JSON_PROPERTY_TRANSITIONS
})
@JsonTypeName("LineChart_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class LineChartSupplier {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_TITLE = "title";
  private ChartTitleSupplier title;

  public static final String JSON_PROPERTY_LEGEND = "legend";
  private ChartLegendSupplier legend;

  public static final String JSON_PROPERTY_SERIES_DEFAULTS = "seriesDefaults";
  private ChartSeriesDefaultsSupplier seriesDefaults;

  public static final String JSON_PROPERTY_SERIES = "series";
  private List<ChartSeriesSupplier> series;

  public static final String JSON_PROPERTY_VALUE_AXIS = "valueAxis";
  private ChartValueAxisSupplier valueAxis;

  public static final String JSON_PROPERTY_CATEGORY_AXIS = "categoryAxis";
  private ChartCategoryAxisSupplier categoryAxis;

  public static final String JSON_PROPERTY_TOOLTIP = "tooltip";
  private ChartTooltipSupplier tooltip;

  public static final String JSON_PROPERTY_RENDER_AS = "renderAs";
  private String renderAs;

  public static final String JSON_PROPERTY_TRANSITIONS = "transitions";
  private Boolean transitions;

  public LineChartSupplier() {
  }

  public LineChartSupplier identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique line chart identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LineChartSupplier title(ChartTitleSupplier title) {
    
    this.title = title;
    return this;
  }

   /**
   * Get title
   * @return title
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTitleSupplier getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(ChartTitleSupplier title) {
    this.title = title;
  }


  public LineChartSupplier legend(ChartLegendSupplier legend) {
    
    this.legend = legend;
    return this;
  }

   /**
   * Get legend
   * @return legend
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartLegendSupplier getLegend() {
    return legend;
  }


  @JsonProperty(JSON_PROPERTY_LEGEND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegend(ChartLegendSupplier legend) {
    this.legend = legend;
  }


  public LineChartSupplier seriesDefaults(ChartSeriesDefaultsSupplier seriesDefaults) {
    
    this.seriesDefaults = seriesDefaults;
    return this;
  }

   /**
   * Get seriesDefaults
   * @return seriesDefaults
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartSeriesDefaultsSupplier getSeriesDefaults() {
    return seriesDefaults;
  }


  @JsonProperty(JSON_PROPERTY_SERIES_DEFAULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeriesDefaults(ChartSeriesDefaultsSupplier seriesDefaults) {
    this.seriesDefaults = seriesDefaults;
  }


  public LineChartSupplier series(List<ChartSeriesSupplier> series) {
    
    this.series = series;
    return this;
  }

  public LineChartSupplier addSeriesItem(ChartSeriesSupplier seriesItem) {
    if (this.series == null) {
      this.series = new ArrayList<>();
    }
    this.series.add(seriesItem);
    return this;
  }

   /**
   * The configuration of the chart series. The series type is determined by the value of the type field. If a type value is missing, the chart renders the type that is specified in &#x60;seriesDefaults&#x60;. Some options accept functions as arguments. These arguments are evaluated for each point which is supplied as a parameter. If no value is returned, the chart uses the &#x60;theme&#x60; or &#x60;seriesDefaults&#x60; values.
   * @return series
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ChartSeriesSupplier> getSeries() {
    return series;
  }


  @JsonProperty(JSON_PROPERTY_SERIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSeries(List<ChartSeriesSupplier> series) {
    this.series = series;
  }


  public LineChartSupplier valueAxis(ChartValueAxisSupplier valueAxis) {
    
    this.valueAxis = valueAxis;
    return this;
  }

   /**
   * Get valueAxis
   * @return valueAxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartValueAxisSupplier getValueAxis() {
    return valueAxis;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueAxis(ChartValueAxisSupplier valueAxis) {
    this.valueAxis = valueAxis;
  }


  public LineChartSupplier categoryAxis(ChartCategoryAxisSupplier categoryAxis) {
    
    this.categoryAxis = categoryAxis;
    return this;
  }

   /**
   * Get categoryAxis
   * @return categoryAxis
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartCategoryAxisSupplier getCategoryAxis() {
    return categoryAxis;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY_AXIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategoryAxis(ChartCategoryAxisSupplier categoryAxis) {
    this.categoryAxis = categoryAxis;
  }


  public LineChartSupplier tooltip(ChartTooltipSupplier tooltip) {
    
    this.tooltip = tooltip;
    return this;
  }

   /**
   * Get tooltip
   * @return tooltip
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ChartTooltipSupplier getTooltip() {
    return tooltip;
  }


  @JsonProperty(JSON_PROPERTY_TOOLTIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTooltip(ChartTooltipSupplier tooltip) {
    this.tooltip = tooltip;
  }


  public LineChartSupplier renderAs(String renderAs) {
    
    this.renderAs = renderAs;
    return this;
  }

   /**
   * Sets the preferred rendering engine. If not supported by the browser, the Chart switches to the first available mode.  The supported values are:  - svg (If available, renders the component as an inline .svg file.)- canvas (If available, renders the component as a canvas element.)
   * @return renderAs
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRenderAs() {
    return renderAs;
  }


  @JsonProperty(JSON_PROPERTY_RENDER_AS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRenderAs(String renderAs) {
    this.renderAs = renderAs;
  }


  public LineChartSupplier transitions(Boolean transitions) {
    
    this.transitions = transitions;
    return this;
  }

   /**
   * If set to &#x60;true&#x60;, the Chart plays animations when it displays the series. By default, animations are enabled.
   * @return transitions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTransitions() {
    return transitions;
  }


  @JsonProperty(JSON_PROPERTY_TRANSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransitions(Boolean transitions) {
    this.transitions = transitions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LineChartSupplier lineChartSupplier = (LineChartSupplier) o;
    return Objects.equals(this.identifier, lineChartSupplier.identifier) &&
        Objects.equals(this.title, lineChartSupplier.title) &&
        Objects.equals(this.legend, lineChartSupplier.legend) &&
        Objects.equals(this.seriesDefaults, lineChartSupplier.seriesDefaults) &&
        Objects.equals(this.series, lineChartSupplier.series) &&
        Objects.equals(this.valueAxis, lineChartSupplier.valueAxis) &&
        Objects.equals(this.categoryAxis, lineChartSupplier.categoryAxis) &&
        Objects.equals(this.tooltip, lineChartSupplier.tooltip) &&
        Objects.equals(this.renderAs, lineChartSupplier.renderAs) &&
        Objects.equals(this.transitions, lineChartSupplier.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, title, legend, seriesDefaults, series, valueAxis, categoryAxis, tooltip, renderAs, transitions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LineChartSupplier {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    legend: ").append(toIndentedString(legend)).append("\n");
    sb.append("    seriesDefaults: ").append(toIndentedString(seriesDefaults)).append("\n");
    sb.append("    series: ").append(toIndentedString(series)).append("\n");
    sb.append("    valueAxis: ").append(toIndentedString(valueAxis)).append("\n");
    sb.append("    categoryAxis: ").append(toIndentedString(categoryAxis)).append("\n");
    sb.append("    tooltip: ").append(toIndentedString(tooltip)).append("\n");
    sb.append("    renderAs: ").append(toIndentedString(renderAs)).append("\n");
    sb.append("    transitions: ").append(toIndentedString(transitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

