/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.extranet.model.PriceTierSupplier;
import travel.wink.sdk.extranet.model.RecurringSupplier;
import travel.wink.sdk.extranet.model.TransformQuantitySupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PriceSupplier
 */
@JsonPropertyOrder({
  PriceSupplier.JSON_PROPERTY_ACTIVE,
  PriceSupplier.JSON_PROPERTY_BILLING_SCHEME,
  PriceSupplier.JSON_PROPERTY_CREATED,
  PriceSupplier.JSON_PROPERTY_CURRENCY,
  PriceSupplier.JSON_PROPERTY_DELETED,
  PriceSupplier.JSON_PROPERTY_ID,
  PriceSupplier.JSON_PROPERTY_LIVEMODE,
  PriceSupplier.JSON_PROPERTY_LOOKUP_KEY,
  PriceSupplier.JSON_PROPERTY_METADATA,
  PriceSupplier.JSON_PROPERTY_NICKNAME,
  PriceSupplier.JSON_PROPERTY_OBJECT,
  PriceSupplier.JSON_PROPERTY_RECURRING,
  PriceSupplier.JSON_PROPERTY_TIERS,
  PriceSupplier.JSON_PROPERTY_TIERS_MODE,
  PriceSupplier.JSON_PROPERTY_TRANSFORM_QUANTITY,
  PriceSupplier.JSON_PROPERTY_TYPE,
  PriceSupplier.JSON_PROPERTY_UNIT_AMOUNT,
  PriceSupplier.JSON_PROPERTY_UNIT_AMOUNT_DECIMAL,
  PriceSupplier.JSON_PROPERTY_SORT,
  PriceSupplier.JSON_PROPERTY_PRICE_TYPE,
  PriceSupplier.JSON_PROPERTY_METERED
})
@JsonTypeName("Price_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class PriceSupplier {
  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_BILLING_SCHEME = "billingScheme";
  private String billingScheme;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_LOOKUP_KEY = "lookupKey";
  private String lookupKey;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NICKNAME = "nickname";
  private String nickname;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_RECURRING = "recurring";
  private RecurringSupplier recurring;

  public static final String JSON_PROPERTY_TIERS = "tiers";
  private List<PriceTierSupplier> tiers;

  public static final String JSON_PROPERTY_TIERS_MODE = "tiersMode";
  private String tiersMode;

  public static final String JSON_PROPERTY_TRANSFORM_QUANTITY = "transformQuantity";
  private TransformQuantitySupplier transformQuantity;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_UNIT_AMOUNT = "unitAmount";
  private Long unitAmount;

  public static final String JSON_PROPERTY_UNIT_AMOUNT_DECIMAL = "unitAmountDecimal";
  private BigDecimal unitAmountDecimal;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * Gets or Sets priceType
   */
  public enum PriceTypeEnum {
    STARTUP("STARTUP"),
    
    PRO("PRO"),
    
    AGENT("AGENT"),
    
    OTA("OTA");

    private String value;

    PriceTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriceTypeEnum fromValue(String value) {
      for (PriceTypeEnum b : PriceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_TYPE = "priceType";
  private PriceTypeEnum priceType;

  public static final String JSON_PROPERTY_METERED = "metered";
  private Boolean metered;

  public PriceSupplier() {
  }

  public PriceSupplier active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public PriceSupplier billingScheme(String billingScheme) {
    
    this.billingScheme = billingScheme;
    return this;
  }

   /**
   * Get billingScheme
   * @return billingScheme
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingScheme() {
    return billingScheme;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingScheme(String billingScheme) {
    this.billingScheme = billingScheme;
  }


  public PriceSupplier created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public PriceSupplier currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public PriceSupplier deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public PriceSupplier id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PriceSupplier livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public PriceSupplier lookupKey(String lookupKey) {
    
    this.lookupKey = lookupKey;
    return this;
  }

   /**
   * Get lookupKey
   * @return lookupKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLookupKey() {
    return lookupKey;
  }


  @JsonProperty(JSON_PROPERTY_LOOKUP_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLookupKey(String lookupKey) {
    this.lookupKey = lookupKey;
  }


  public PriceSupplier metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PriceSupplier putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PriceSupplier nickname(String nickname) {
    
    this.nickname = nickname;
    return this;
  }

   /**
   * Get nickname
   * @return nickname
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNickname() {
    return nickname;
  }


  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNickname(String nickname) {
    this.nickname = nickname;
  }


  public PriceSupplier _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public PriceSupplier recurring(RecurringSupplier recurring) {
    
    this.recurring = recurring;
    return this;
  }

   /**
   * Get recurring
   * @return recurring
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RecurringSupplier getRecurring() {
    return recurring;
  }


  @JsonProperty(JSON_PROPERTY_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurring(RecurringSupplier recurring) {
    this.recurring = recurring;
  }


  public PriceSupplier tiers(List<PriceTierSupplier> tiers) {
    
    this.tiers = tiers;
    return this;
  }

  public PriceSupplier addTiersItem(PriceTierSupplier tiersItem) {
    if (this.tiers == null) {
      this.tiers = new ArrayList<>();
    }
    this.tiers.add(tiersItem);
    return this;
  }

   /**
   * Get tiers
   * @return tiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PriceTierSupplier> getTiers() {
    return tiers;
  }


  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiers(List<PriceTierSupplier> tiers) {
    this.tiers = tiers;
  }


  public PriceSupplier tiersMode(String tiersMode) {
    
    this.tiersMode = tiersMode;
    return this;
  }

   /**
   * Get tiersMode
   * @return tiersMode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTiersMode() {
    return tiersMode;
  }


  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiersMode(String tiersMode) {
    this.tiersMode = tiersMode;
  }


  public PriceSupplier transformQuantity(TransformQuantitySupplier transformQuantity) {
    
    this.transformQuantity = transformQuantity;
    return this;
  }

   /**
   * Get transformQuantity
   * @return transformQuantity
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSFORM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransformQuantitySupplier getTransformQuantity() {
    return transformQuantity;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFORM_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransformQuantity(TransformQuantitySupplier transformQuantity) {
    this.transformQuantity = transformQuantity;
  }


  public PriceSupplier type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public PriceSupplier unitAmount(Long unitAmount) {
    
    this.unitAmount = unitAmount;
    return this;
  }

   /**
   * Get unitAmount
   * @return unitAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUnitAmount() {
    return unitAmount;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmount(Long unitAmount) {
    this.unitAmount = unitAmount;
  }


  public PriceSupplier unitAmountDecimal(BigDecimal unitAmountDecimal) {
    
    this.unitAmountDecimal = unitAmountDecimal;
    return this;
  }

   /**
   * Get unitAmountDecimal
   * @return unitAmountDecimal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUnitAmountDecimal() {
    return unitAmountDecimal;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
    this.unitAmountDecimal = unitAmountDecimal;
  }


  public PriceSupplier sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public PriceSupplier priceType(PriceTypeEnum priceType) {
    
    this.priceType = priceType;
    return this;
  }

   /**
   * Get priceType
   * @return priceType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriceTypeEnum getPriceType() {
    return priceType;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceType(PriceTypeEnum priceType) {
    this.priceType = priceType;
  }


  public PriceSupplier metered(Boolean metered) {
    
    this.metered = metered;
    return this;
  }

   /**
   * Get metered
   * @return metered
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMetered() {
    return metered;
  }


  @JsonProperty(JSON_PROPERTY_METERED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetered(Boolean metered) {
    this.metered = metered;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PriceSupplier priceSupplier = (PriceSupplier) o;
    return Objects.equals(this.active, priceSupplier.active) &&
        Objects.equals(this.billingScheme, priceSupplier.billingScheme) &&
        Objects.equals(this.created, priceSupplier.created) &&
        Objects.equals(this.currency, priceSupplier.currency) &&
        Objects.equals(this.deleted, priceSupplier.deleted) &&
        Objects.equals(this.id, priceSupplier.id) &&
        Objects.equals(this.livemode, priceSupplier.livemode) &&
        Objects.equals(this.lookupKey, priceSupplier.lookupKey) &&
        Objects.equals(this.metadata, priceSupplier.metadata) &&
        Objects.equals(this.nickname, priceSupplier.nickname) &&
        Objects.equals(this._object, priceSupplier._object) &&
        Objects.equals(this.recurring, priceSupplier.recurring) &&
        Objects.equals(this.tiers, priceSupplier.tiers) &&
        Objects.equals(this.tiersMode, priceSupplier.tiersMode) &&
        Objects.equals(this.transformQuantity, priceSupplier.transformQuantity) &&
        Objects.equals(this.type, priceSupplier.type) &&
        Objects.equals(this.unitAmount, priceSupplier.unitAmount) &&
        Objects.equals(this.unitAmountDecimal, priceSupplier.unitAmountDecimal) &&
        Objects.equals(this.sort, priceSupplier.sort) &&
        Objects.equals(this.priceType, priceSupplier.priceType) &&
        Objects.equals(this.metered, priceSupplier.metered);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, billingScheme, created, currency, deleted, id, livemode, lookupKey, metadata, nickname, _object, recurring, tiers, tiersMode, transformQuantity, type, unitAmount, unitAmountDecimal, sort, priceType, metered);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PriceSupplier {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    billingScheme: ").append(toIndentedString(billingScheme)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    lookupKey: ").append(toIndentedString(lookupKey)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    nickname: ").append(toIndentedString(nickname)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    recurring: ").append(toIndentedString(recurring)).append("\n");
    sb.append("    tiers: ").append(toIndentedString(tiers)).append("\n");
    sb.append("    tiersMode: ").append(toIndentedString(tiersMode)).append("\n");
    sb.append("    transformQuantity: ").append(toIndentedString(transformQuantity)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unitAmount: ").append(toIndentedString(unitAmount)).append("\n");
    sb.append("    unitAmountDecimal: ").append(toIndentedString(unitAmountDecimal)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    priceType: ").append(toIndentedString(priceType)).append("\n");
    sb.append("    metered: ").append(toIndentedString(metered)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

