/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Displays rate accounting details
 */
@JsonPropertyOrder({
  ReportingDailyRateSupplier.JSON_PROPERTY_DATE,
  ReportingDailyRateSupplier.JSON_PROPERTY_BASE_AMOUNT,
  ReportingDailyRateSupplier.JSON_PROPERTY_GROSS_AMOUNT,
  ReportingDailyRateSupplier.JSON_PROPERTY_NET_AMOUNT,
  ReportingDailyRateSupplier.JSON_PROPERTY_NET_AMOUNT_WITH_REFUND,
  ReportingDailyRateSupplier.JSON_PROPERTY_CURRENCY
})
@JsonTypeName("ReportingDailyRate_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class ReportingDailyRateSupplier {
  public static final String JSON_PROPERTY_DATE = "date";
  private LocalDate date;

  public static final String JSON_PROPERTY_BASE_AMOUNT = "baseAmount";
  private BigDecimal baseAmount;

  public static final String JSON_PROPERTY_GROSS_AMOUNT = "grossAmount";
  private BigDecimal grossAmount;

  public static final String JSON_PROPERTY_NET_AMOUNT = "netAmount";
  private BigDecimal netAmount;

  public static final String JSON_PROPERTY_NET_AMOUNT_WITH_REFUND = "netAmountWithRefund";
  private BigDecimal netAmountWithRefund;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public ReportingDailyRateSupplier() {
  }

  public ReportingDailyRateSupplier date(LocalDate date) {
    
    this.date = date;
    return this;
  }

   /**
   * The rate date.
   * @return date
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(LocalDate date) {
    this.date = date;
  }


  public ReportingDailyRateSupplier baseAmount(BigDecimal baseAmount) {
    
    this.baseAmount = baseAmount;
    return this;
  }

   /**
   * The rate given to us by channel manager / CRS / PMS.
   * @return baseAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getBaseAmount() {
    return baseAmount;
  }


  @JsonProperty(JSON_PROPERTY_BASE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBaseAmount(BigDecimal baseAmount) {
    this.baseAmount = baseAmount;
  }


  public ReportingDailyRateSupplier grossAmount(BigDecimal grossAmount) {
    
    this.grossAmount = grossAmount;
    return this;
  }

   /**
   * The derived amount based on promotions, member discounts etc within our platform.
   * @return grossAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GROSS_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getGrossAmount() {
    return grossAmount;
  }


  @JsonProperty(JSON_PROPERTY_GROSS_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrossAmount(BigDecimal grossAmount) {
    this.grossAmount = grossAmount;
  }


  public ReportingDailyRateSupplier netAmount(BigDecimal netAmount) {
    
    this.netAmount = netAmount;
    return this;
  }

   /**
   * The gross amount minus fees and commissions.
   * @return netAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetAmount() {
    return netAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public ReportingDailyRateSupplier netAmountWithRefund(BigDecimal netAmountWithRefund) {
    
    this.netAmountWithRefund = netAmountWithRefund;
    return this;
  }

   /**
   * The net amount minus potential refund. Null if booking contains no refund.
   * @return netAmountWithRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_AMOUNT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetAmountWithRefund() {
    return netAmountWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_NET_AMOUNT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAmountWithRefund(BigDecimal netAmountWithRefund) {
    this.netAmountWithRefund = netAmountWithRefund;
  }


  public ReportingDailyRateSupplier currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency for these amounts.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReportingDailyRateSupplier reportingDailyRateSupplier = (ReportingDailyRateSupplier) o;
    return Objects.equals(this.date, reportingDailyRateSupplier.date) &&
        Objects.equals(this.baseAmount, reportingDailyRateSupplier.baseAmount) &&
        Objects.equals(this.grossAmount, reportingDailyRateSupplier.grossAmount) &&
        Objects.equals(this.netAmount, reportingDailyRateSupplier.netAmount) &&
        Objects.equals(this.netAmountWithRefund, reportingDailyRateSupplier.netAmountWithRefund) &&
        Objects.equals(this.currency, reportingDailyRateSupplier.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(date, baseAmount, grossAmount, netAmount, netAmountWithRefund, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReportingDailyRateSupplier {\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    baseAmount: ").append(toIndentedString(baseAmount)).append("\n");
    sb.append("    grossAmount: ").append(toIndentedString(grossAmount)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    netAmountWithRefund: ").append(toIndentedString(netAmountWithRefund)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

