/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import travel.wink.sdk.extranet.model.VariableChargeSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Values to update this rate
 */
@JsonPropertyOrder({
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_QUANTITY,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_DELTA_QUANTITY,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_MASTER,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_CLOSED_ON_ARRIVAL,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_CLOSED_ON_DEPARTURE,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_MIN_LENGTH_OF_STAY,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_MAX_LENGTH_OF_STAY,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_RATE,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_CURRENCY_CODE,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_MIN_OCCUPANCY,
  UpsertIndividualRateRequestSupplier.JSON_PROPERTY_MAX_OCCUPANCY
})
@JsonTypeName("UpsertIndividualRateRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:16:28.530240732+07:00[Asia/Bangkok]")
public class UpsertIndividualRateRequestSupplier {
  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity;

  public static final String JSON_PROPERTY_DELTA_QUANTITY = "deltaQuantity";
  private Integer deltaQuantity;

  public static final String JSON_PROPERTY_MASTER = "master";
  private Boolean master;

  public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
  private Boolean closedOnArrival;

  public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
  private Boolean closedOnDeparture;

  public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
  private Integer minLengthOfStay;

  public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
  private Integer maxLengthOfStay;

  public static final String JSON_PROPERTY_RATE = "rate";
  private BigDecimal rate;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode;

  public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
  private VariableChargeSupplier extraPaxRateModifier;

  public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
  private VariableChargeSupplier extraChildRateModifier;

  public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
  private VariableChargeSupplier singleOccupancyRateModifier;

  public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
  private Integer minOccupancy;

  public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
  private Integer maxOccupancy;

  public UpsertIndividualRateRequestSupplier() {
  }

  public UpsertIndividualRateRequestSupplier quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public UpsertIndividualRateRequestSupplier deltaQuantity(Integer deltaQuantity) {
    
    this.deltaQuantity = deltaQuantity;
    return this;
  }

   /**
   * Get deltaQuantity
   * @return deltaQuantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELTA_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDeltaQuantity() {
    return deltaQuantity;
  }


  @JsonProperty(JSON_PROPERTY_DELTA_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeltaQuantity(Integer deltaQuantity) {
    this.deltaQuantity = deltaQuantity;
  }


  public UpsertIndividualRateRequestSupplier master(Boolean master) {
    
    this.master = master;
    return this;
  }

   /**
   * Get master
   * @return master
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMaster() {
    return master;
  }


  @JsonProperty(JSON_PROPERTY_MASTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaster(Boolean master) {
    this.master = master;
  }


  public UpsertIndividualRateRequestSupplier closedOnArrival(Boolean closedOnArrival) {
    
    this.closedOnArrival = closedOnArrival;
    return this;
  }

   /**
   * Get closedOnArrival
   * @return closedOnArrival
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnArrival() {
    return closedOnArrival;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_ARRIVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnArrival(Boolean closedOnArrival) {
    this.closedOnArrival = closedOnArrival;
  }


  public UpsertIndividualRateRequestSupplier closedOnDeparture(Boolean closedOnDeparture) {
    
    this.closedOnDeparture = closedOnDeparture;
    return this;
  }

   /**
   * Get closedOnDeparture
   * @return closedOnDeparture
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getClosedOnDeparture() {
    return closedOnDeparture;
  }


  @JsonProperty(JSON_PROPERTY_CLOSED_ON_DEPARTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClosedOnDeparture(Boolean closedOnDeparture) {
    this.closedOnDeparture = closedOnDeparture;
  }


  public UpsertIndividualRateRequestSupplier minLengthOfStay(Integer minLengthOfStay) {
    
    this.minLengthOfStay = minLengthOfStay;
    return this;
  }

   /**
   * Get minLengthOfStay
   * @return minLengthOfStay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLengthOfStay() {
    return minLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MIN_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLengthOfStay(Integer minLengthOfStay) {
    this.minLengthOfStay = minLengthOfStay;
  }


  public UpsertIndividualRateRequestSupplier maxLengthOfStay(Integer maxLengthOfStay) {
    
    this.maxLengthOfStay = maxLengthOfStay;
    return this;
  }

   /**
   * Get maxLengthOfStay
   * @return maxLengthOfStay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLengthOfStay() {
    return maxLengthOfStay;
  }


  @JsonProperty(JSON_PROPERTY_MAX_LENGTH_OF_STAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLengthOfStay(Integer maxLengthOfStay) {
    this.maxLengthOfStay = maxLengthOfStay;
  }


  public UpsertIndividualRateRequestSupplier rate(BigDecimal rate) {
    
    this.rate = rate;
    return this;
  }

   /**
   * Get rate
   * @return rate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getRate() {
    return rate;
  }


  @JsonProperty(JSON_PROPERTY_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRate(BigDecimal rate) {
    this.rate = rate;
  }


  public UpsertIndividualRateRequestSupplier currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Get currencyCode
   * @return currencyCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public UpsertIndividualRateRequestSupplier extraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
    
    this.extraPaxRateModifier = extraPaxRateModifier;
    return this;
  }

   /**
   * Get extraPaxRateModifier
   * @return extraPaxRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getExtraPaxRateModifier() {
    return extraPaxRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraPaxRateModifier(VariableChargeSupplier extraPaxRateModifier) {
    this.extraPaxRateModifier = extraPaxRateModifier;
  }


  public UpsertIndividualRateRequestSupplier extraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
    
    this.extraChildRateModifier = extraChildRateModifier;
    return this;
  }

   /**
   * Get extraChildRateModifier
   * @return extraChildRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getExtraChildRateModifier() {
    return extraChildRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraChildRateModifier(VariableChargeSupplier extraChildRateModifier) {
    this.extraChildRateModifier = extraChildRateModifier;
  }


  public UpsertIndividualRateRequestSupplier singleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
    
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    return this;
  }

   /**
   * Get singleOccupancyRateModifier
   * @return singleOccupancyRateModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public VariableChargeSupplier getSingleOccupancyRateModifier() {
    return singleOccupancyRateModifier;
  }


  @JsonProperty(JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSingleOccupancyRateModifier(VariableChargeSupplier singleOccupancyRateModifier) {
    this.singleOccupancyRateModifier = singleOccupancyRateModifier;
  }


  public UpsertIndividualRateRequestSupplier minOccupancy(Integer minOccupancy) {
    
    this.minOccupancy = minOccupancy;
    return this;
  }

   /**
   * Get minOccupancy
   * @return minOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinOccupancy() {
    return minOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinOccupancy(Integer minOccupancy) {
    this.minOccupancy = minOccupancy;
  }


  public UpsertIndividualRateRequestSupplier maxOccupancy(Integer maxOccupancy) {
    
    this.maxOccupancy = maxOccupancy;
    return this;
  }

   /**
   * Get maxOccupancy
   * @return maxOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxOccupancy() {
    return maxOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxOccupancy(Integer maxOccupancy) {
    this.maxOccupancy = maxOccupancy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertIndividualRateRequestSupplier upsertIndividualRateRequestSupplier = (UpsertIndividualRateRequestSupplier) o;
    return Objects.equals(this.quantity, upsertIndividualRateRequestSupplier.quantity) &&
        Objects.equals(this.deltaQuantity, upsertIndividualRateRequestSupplier.deltaQuantity) &&
        Objects.equals(this.master, upsertIndividualRateRequestSupplier.master) &&
        Objects.equals(this.closedOnArrival, upsertIndividualRateRequestSupplier.closedOnArrival) &&
        Objects.equals(this.closedOnDeparture, upsertIndividualRateRequestSupplier.closedOnDeparture) &&
        Objects.equals(this.minLengthOfStay, upsertIndividualRateRequestSupplier.minLengthOfStay) &&
        Objects.equals(this.maxLengthOfStay, upsertIndividualRateRequestSupplier.maxLengthOfStay) &&
        Objects.equals(this.rate, upsertIndividualRateRequestSupplier.rate) &&
        Objects.equals(this.currencyCode, upsertIndividualRateRequestSupplier.currencyCode) &&
        Objects.equals(this.extraPaxRateModifier, upsertIndividualRateRequestSupplier.extraPaxRateModifier) &&
        Objects.equals(this.extraChildRateModifier, upsertIndividualRateRequestSupplier.extraChildRateModifier) &&
        Objects.equals(this.singleOccupancyRateModifier, upsertIndividualRateRequestSupplier.singleOccupancyRateModifier) &&
        Objects.equals(this.minOccupancy, upsertIndividualRateRequestSupplier.minOccupancy) &&
        Objects.equals(this.maxOccupancy, upsertIndividualRateRequestSupplier.maxOccupancy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(quantity, deltaQuantity, master, closedOnArrival, closedOnDeparture, minLengthOfStay, maxLengthOfStay, rate, currencyCode, extraPaxRateModifier, extraChildRateModifier, singleOccupancyRateModifier, minOccupancy, maxOccupancy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertIndividualRateRequestSupplier {\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    deltaQuantity: ").append(toIndentedString(deltaQuantity)).append("\n");
    sb.append("    master: ").append(toIndentedString(master)).append("\n");
    sb.append("    closedOnArrival: ").append(toIndentedString(closedOnArrival)).append("\n");
    sb.append("    closedOnDeparture: ").append(toIndentedString(closedOnDeparture)).append("\n");
    sb.append("    minLengthOfStay: ").append(toIndentedString(minLengthOfStay)).append("\n");
    sb.append("    maxLengthOfStay: ").append(toIndentedString(maxLengthOfStay)).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    extraPaxRateModifier: ").append(toIndentedString(extraPaxRateModifier)).append("\n");
    sb.append("    extraChildRateModifier: ").append(toIndentedString(extraChildRateModifier)).append("\n");
    sb.append("    singleOccupancyRateModifier: ").append(toIndentedString(singleOccupancyRateModifier)).append("\n");
    sb.append("    minOccupancy: ").append(toIndentedString(minOccupancy)).append("\n");
    sb.append("    maxOccupancy: ").append(toIndentedString(maxOccupancy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

