/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CompanyDetailsBookingSalesMetricsSupplier;
import travel.wink.sdk.extranet.model.KeyValuePairSupplier;
import travel.wink.sdk.extranet.model.PageDisplayCompanyWithSalesMetricsSupplier;
import travel.wink.sdk.extranet.model.StateSupplier;

public class AffiliateApi {
    private ApiClient apiClient;

    public AffiliateApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseAffiliatesRequestCreation(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        StateSupplier postBody = stateSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling browseAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateSupplier' when calling browseAffiliates", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageDisplayCompanyWithSalesMetricsSupplier> browseAffiliates(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier>(this){};
        return this.browseAffiliatesRequestCreation(hotelIdentifier, stateSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageDisplayCompanyWithSalesMetricsSupplier>> browseAffiliatesWithHttpInfo(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<PageDisplayCompanyWithSalesMetricsSupplier>(this){};
        return this.browseAffiliatesRequestCreation(hotelIdentifier, stateSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec browseAffiliatesWithResponseSpec(String hotelIdentifier, StateSupplier stateSupplier, String winkVersion) throws WebClientResponseException {
        return this.browseAffiliatesRequestCreation(hotelIdentifier, stateSupplier, winkVersion);
    }

    private WebClient.ResponseSpec showAffiliateRequestCreation(String hotelIdentifier, String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAffiliate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showAffiliate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyDetailsBookingSalesMetricsSupplier> showAffiliate(String hotelIdentifier, String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier>(this){};
        return this.showAffiliateRequestCreation(hotelIdentifier, companyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyDetailsBookingSalesMetricsSupplier>> showAffiliateWithHttpInfo(String hotelIdentifier, String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier> localVarReturnType = new ParameterizedTypeReference<CompanyDetailsBookingSalesMetricsSupplier>(this){};
        return this.showAffiliateRequestCreation(hotelIdentifier, companyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAffiliateWithResponseSpec(String hotelIdentifier, String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAffiliateRequestCreation(hotelIdentifier, companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showUniqueCityListRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showUniqueCityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showUniqueCityList(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showUniqueCityListRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showUniqueCityListWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showUniqueCityListRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCityListWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showUniqueCityListRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showUniqueCountryListRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showUniqueCountryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/sales/affiliate/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairSupplier> showUniqueCountryList(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showUniqueCountryListRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairSupplier>>> showUniqueCountryListWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairSupplier> localVarReturnType = new ParameterizedTypeReference<KeyValuePairSupplier>(this){};
        return this.showUniqueCountryListRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCountryListWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showUniqueCountryListRequestCreation(hotelIdentifier, winkVersion, accept);
    }
}

