/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.CancellationPolicyRemovableResponseSupplier;
import travel.wink.sdk.extranet.model.CancellationPolicyViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.UpsertCancellationPolicyRequestSupplier;

public class CancellationPolicyApi {
    private ApiClient apiClient;

    public CancellationPolicyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CancellationPolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCancellationPolicyRequestCreation(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertCancellationPolicyRequestSupplier postBody = upsertCancellationPolicyRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling createCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyViewSupplier> createCancellationPolicy(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> createCancellationPolicyWithHttpInfo(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCancellationPolicyWithResponseSpec(String hotelIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createCancellationPolicyRequestCreation(hotelIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec isCancellationPolicyRemovableRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling isCancellationPolicyRemovable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}/removable", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyRemovableResponseSupplier> isCancellationPolicyRemovable(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>(this){};
        return this.isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyRemovableResponseSupplier>> isCancellationPolicyRemovableWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyRemovableResponseSupplier>(this){};
        return this.isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isCancellationPolicyRemovableWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.isCancellationPolicyRemovableRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling removeCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling showCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyViewSupplier> showCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> showCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCancellationPolicyListRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showCancellationPolicyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CancellationPolicyViewSupplier> showCancellationPolicyList(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CancellationPolicyViewSupplier>>> showCancellationPolicyListWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCancellationPolicyListWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCancellationPolicyListRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCancellationPolicyRequestCreation(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertCancellationPolicyRequestSupplier postBody = upsertCancellationPolicyRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationPolicyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationPolicyIdentifier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCancellationPolicyRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCancellationPolicyRequestSupplier' when calling updateCancellationPolicy", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("cancellationPolicyIdentifier", cancellationPolicyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/cancellationpolicy/{cancellationPolicyIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CancellationPolicyViewSupplier> updateCancellationPolicy(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CancellationPolicyViewSupplier>> updateCancellationPolicyWithHttpInfo(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CancellationPolicyViewSupplier> localVarReturnType = new ParameterizedTypeReference<CancellationPolicyViewSupplier>(this){};
        return this.updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCancellationPolicyWithResponseSpec(String hotelIdentifier, String cancellationPolicyIdentifier, UpsertCancellationPolicyRequestSupplier upsertCancellationPolicyRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateCancellationPolicyRequestCreation(hotelIdentifier, cancellationPolicyIdentifier, upsertCancellationPolicyRequestSupplier, winkVersion);
    }
}

