/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.InvoiceCollectionSupplier;

public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showInvoicesForCustomerRequestCreation(String hotelIdentifier, String customerIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (customerIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customerIdentifier' when calling showInvoicesForCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("customerIdentifier", customerIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/{customerIdentifier}/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollectionSupplier> showInvoicesForCustomer(String hotelIdentifier, String customerIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollectionSupplier>> showInvoicesForCustomerWithHttpInfo(String hotelIdentifier, String customerIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInvoicesForCustomerWithResponseSpec(String hotelIdentifier, String customerIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInvoicesForCustomerRequestCreation(hotelIdentifier, customerIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInvoicesForHotelRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InvoiceCollectionSupplier> showInvoicesForHotel(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForHotelRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InvoiceCollectionSupplier>>> showInvoicesForHotelWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForHotelRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInvoicesForHotelWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInvoicesForHotelRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInvoicesForHotelCustomerRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForHotelCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollectionSupplier> showInvoicesForHotelCustomer(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollectionSupplier>> showInvoicesForHotelCustomerWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInvoicesForHotelCustomerWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInvoicesForHotelCustomerRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInvoicesForSubscriptionRequestCreation(String hotelIdentifier, String subscriptionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (subscriptionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'subscriptionIdentifier' when calling showInvoicesForSubscription", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("subscriptionIdentifier", subscriptionIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/marketplace/subscription/{subscriptionIdentifier}/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollectionSupplier> showInvoicesForSubscription(String hotelIdentifier, String subscriptionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollectionSupplier>> showInvoicesForSubscriptionWithHttpInfo(String hotelIdentifier, String subscriptionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionSupplier> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionSupplier>(this){};
        return this.showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInvoicesForSubscriptionWithResponseSpec(String hotelIdentifier, String subscriptionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInvoicesForSubscriptionRequestCreation(hotelIdentifier, subscriptionIdentifier, winkVersion, accept);
    }
}

