/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.extranet.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.extranet.invoker.ApiClient;
import travel.wink.sdk.extranet.model.RateModifierBundleViewSupplier;
import travel.wink.sdk.extranet.model.RemoveEntryResponseSupplier;
import travel.wink.sdk.extranet.model.UpsertRateModifierBundleRequestSupplier;

public class PromotionBundleApi {
    private ApiClient apiClient;

    public PromotionBundleApi() {
        this(new ApiClient());
    }

    @Autowired
    public PromotionBundleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createRateModifierBundleRequestCreation(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierBundleRequestSupplier postBody = upsertRateModifierBundleRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling createRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleViewSupplier> createRateModifierBundle(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> createRateModifierBundleWithHttpInfo(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createRateModifierBundleWithResponseSpec(String hotelIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.createRateModifierBundleRequestCreation(hotelIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }

    private WebClient.ResponseSpec removeRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling removeRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseSupplier> removeRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseSupplier>> removeRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseSupplier> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseSupplier>(this){};
        return this.removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling showRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleViewSupplier> showRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> showRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showRateModifierBundlesRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showRateModifierBundles", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<RateModifierBundleViewSupplier> showRateModifierBundles(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<RateModifierBundleViewSupplier>>> showRateModifierBundlesWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showRateModifierBundlesWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showRateModifierBundlesRequestCreation(hotelIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateRateModifierBundleRequestCreation(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        UpsertRateModifierBundleRequestSupplier postBody = upsertRateModifierBundleRequestSupplier;
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (promotionBundleIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'promotionBundleIdentifier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertRateModifierBundleRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertRateModifierBundleRequestSupplier' when calling updateRateModifierBundle", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("promotionBundleIdentifier", promotionBundleIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/promotion/bundle/{promotionBundleIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RateModifierBundleViewSupplier> updateRateModifierBundle(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RateModifierBundleViewSupplier>> updateRateModifierBundleWithHttpInfo(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RateModifierBundleViewSupplier> localVarReturnType = new ParameterizedTypeReference<RateModifierBundleViewSupplier>(this){};
        return this.updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateRateModifierBundleWithResponseSpec(String hotelIdentifier, String promotionBundleIdentifier, UpsertRateModifierBundleRequestSupplier upsertRateModifierBundleRequestSupplier, String winkVersion) throws WebClientResponseException {
        return this.updateRateModifierBundleRequestCreation(hotelIdentifier, promotionBundleIdentifier, upsertRateModifierBundleRequestSupplier, winkVersion);
    }
}

