package travel.wink.sdk.extranet.api;

import travel.wink.sdk.extranet.invoker.ApiClient;

import travel.wink.sdk.extranet.model.AttractionView;
import java.io.File;
import travel.wink.sdk.extranet.model.GenericErrorMessage;
import travel.wink.sdk.extranet.model.KeyValuePair;
import travel.wink.sdk.extranet.model.RemoveEntryResponse;
import travel.wink.sdk.extranet.model.ShowPropertyPolicy400Response;
import travel.wink.sdk.extranet.model.UpsertAttractionRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:41:24.797077847+07:00[Asia/Bangkok]")
public class AttractionApi {
    private ApiClient apiClient;

    public AttractionApi() {
        this(new ApiClient());
    }

    @Autowired
    public AttractionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Attraction
     * Create a new attraction
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist attraction owned by this hotel identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createAttractionRequestCreation(String hotelIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAttractionRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling createAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAttractionRequest' is set
        if (upsertAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAttractionRequest' when calling createAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Attraction
     * Create a new attraction
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist attraction owned by this hotel identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AttractionView> createAttraction(String hotelIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return createAttractionRequestCreation(hotelIdentifier, upsertAttractionRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Attraction
     * Create a new attraction
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist attraction owned by this hotel identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AttractionView>> createAttractionWithHttpInfo(String hotelIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return createAttractionRequestCreation(hotelIdentifier, upsertAttractionRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Attraction
     * Create a new attraction
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>201</b> - Created
     * @param hotelIdentifier Persist attraction owned by this hotel identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createAttractionWithResponseSpec(String hotelIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        return createAttractionRequestCreation(hotelIdentifier, upsertAttractionRequest, winkVersion);
    }
    /**
     * Delete attraction
     * Delete an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Delete attraction owned by this hotel identifier
     * @param attractionIdentifier Delete attraction identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeAttractionRequestCreation(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling removeAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'attractionIdentifier' is set
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling removeAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/{attractionIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete attraction
     * Delete an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Delete attraction owned by this hotel identifier
     * @param attractionIdentifier Delete attraction identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponse> removeAttraction(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete attraction
     * Delete an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Delete attraction owned by this hotel identifier
     * @param attractionIdentifier Delete attraction identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponse>> removeAttractionWithHttpInfo(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>() {};
        return removeAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete attraction
     * Delete an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Delete attraction owned by this hotel identifier
     * @param attractionIdentifier Delete attraction identified by this identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeAttractionWithResponseSpec(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept);
    }
    /**
     * Show Attraction
     * Retrieve an attraction by identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction owned by this hotel identifier
     * @param attractionIdentifier Show attraction for identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAttractionRequestCreation(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'attractionIdentifier' is set
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling showAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/{attractionIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction
     * Retrieve an attraction by identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction owned by this hotel identifier
     * @param attractionIdentifier Show attraction for identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AttractionView> showAttraction(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return showAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Attraction
     * Retrieve an attraction by identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction owned by this hotel identifier
     * @param attractionIdentifier Show attraction for identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AttractionView>> showAttractionWithHttpInfo(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return showAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Attraction
     * Retrieve an attraction by identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction owned by this hotel identifier
     * @param attractionIdentifier Show attraction for identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAttractionWithResponseSpec(String hotelIdentifier, String attractionIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAttractionRequestCreation(hotelIdentifier, attractionIdentifier, winkVersion, accept);
    }
    /**
     * Show Attractions as Pairs
     * Retrieve list of key value pairs (identifier, name)
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAttractionPairsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAttractionPairs", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/list/pair", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attractions as Pairs
     * Retrieve list of key value pairs (identifier, name)
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePair&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePair> showAttractionPairs(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAttractionPairsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Attractions as Pairs
     * Retrieve list of key value pairs (identifier, name)
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePair&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePair>>> showAttractionPairsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePair> localVarReturnType = new ParameterizedTypeReference<KeyValuePair>() {};
        return showAttractionPairsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Attractions as Pairs
     * Retrieve list of key value pairs (identifier, name)
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attraction key/value pairs associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAttractionPairsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAttractionPairsRequestCreation(hotelIdentifier, winkVersion, accept);
    }
    /**
     * Show Attractions
     * Retrieve list of attractions
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attractions associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showAttractionsRequestCreation(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling showAttractions", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attractions
     * Retrieve list of attractions
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attractions associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<AttractionView> showAttractions(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return showAttractionsRequestCreation(hotelIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Attractions
     * Retrieve list of attractions
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attractions associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;AttractionView&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<AttractionView>>> showAttractionsWithHttpInfo(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return showAttractionsRequestCreation(hotelIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Attractions
     * Retrieve list of attractions
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Show attractions associated with this hotel identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showAttractionsWithResponseSpec(String hotelIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showAttractionsRequestCreation(hotelIdentifier, winkVersion, accept);
    }
    /**
     * Update Attraction
     * Update an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing attraction record owned by this hotel identifier
     * @param attractionIdentifier Update attraction record with this identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAttractionRequestCreation(String hotelIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAttractionRequest;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'attractionIdentifier' is set
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAttractionRequest' is set
        if (upsertAttractionRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAttractionRequest' when calling updateAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/{attractionIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Attraction
     * Update an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing attraction record owned by this hotel identifier
     * @param attractionIdentifier Update attraction record with this identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AttractionView> updateAttraction(String hotelIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return updateAttractionRequestCreation(hotelIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Attraction
     * Update an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing attraction record owned by this hotel identifier
     * @param attractionIdentifier Update attraction record with this identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AttractionView>> updateAttractionWithHttpInfo(String hotelIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return updateAttractionRequestCreation(hotelIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Attraction
     * Update an attraction by its identifier
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param hotelIdentifier Update existing attraction record owned by this hotel identifier
     * @param attractionIdentifier Update attraction record with this identifier
     * @param upsertAttractionRequest The upsertAttractionRequest parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAttractionWithResponseSpec(String hotelIdentifier, String attractionIdentifier, UpsertAttractionRequest upsertAttractionRequest, String winkVersion) throws WebClientResponseException {
        return updateAttractionRequestCreation(hotelIdentifier, attractionIdentifier, upsertAttractionRequest, winkVersion);
    }
    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to an attraction identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for attraction owned by this hotel identifier
     * @param attractionIdentifier Associate multipart media with attraction identified by this identifier
     * @param files The files parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec uploadAttractionMediaRequestCreation(String hotelIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'hotelIdentifier' is set
        if (hotelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelIdentifier' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'attractionIdentifier' is set
        if (attractionIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'attractionIdentifier' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'files' is set
        if (files == null) {
            throw new WebClientResponseException("Missing the required parameter 'files' when calling uploadAttractionMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("hotelIdentifier", hotelIdentifier);
        pathParams.put("attractionIdentifier", attractionIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (files != null)
            formParams.addAll("files", files.stream().map(FileSystemResource::new).collect(Collectors.toList()));

        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return apiClient.invokeAPI("/api/hotel/{hotelIdentifier}/inventory/attraction/{attractionIdentifier}/multimedia", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to an attraction identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for attraction owned by this hotel identifier
     * @param attractionIdentifier Associate multipart media with attraction identified by this identifier
     * @param files The files parameter
     * @return AttractionView
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<AttractionView> uploadAttractionMedia(String hotelIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return uploadAttractionMediaRequestCreation(hotelIdentifier, attractionIdentifier, files).bodyToMono(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to an attraction identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for attraction owned by this hotel identifier
     * @param attractionIdentifier Associate multipart media with attraction identified by this identifier
     * @param files The files parameter
     * @return ResponseEntity&lt;AttractionView&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<AttractionView>> uploadAttractionMediaWithHttpInfo(String hotelIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        ParameterizedTypeReference<AttractionView> localVarReturnType = new ParameterizedTypeReference<AttractionView>() {};
        return uploadAttractionMediaRequestCreation(hotelIdentifier, attractionIdentifier, files).toEntity(localVarReturnType);
    }

    /**
     * Upload Binary Multimedia
     * Upload binary videos and/or images to an attraction identified by its identifier. Valid file types: .gif, .jpg, .jpeg, .png, .bmp, .tif, .tiff, .avi, .mpeg, .mov, .mp4, .mkv.
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>207</b> - Multi-Status
     * @param hotelIdentifier Upload multipart media for attraction owned by this hotel identifier
     * @param attractionIdentifier Associate multipart media with attraction identified by this identifier
     * @param files The files parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec uploadAttractionMediaWithResponseSpec(String hotelIdentifier, String attractionIdentifier, List<File> files) throws WebClientResponseException {
        return uploadAttractionMediaRequestCreation(hotelIdentifier, attractionIdentifier, files);
    }
}
