/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Extranet API Welcome to the Extranet API - A programmer-friendly way to manage your travel inventory on the wink payment. This API offers a superset of the features you can find at [https://extranet.wink.travel](https://extranet.wink.travel) and gives you all the tools you need to ready your properties and inventory for sale across 10000s of our unique sales channels. What differentiates us from existing Extranets is 1. we make it available for everyone to use and 2. the care we take in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Content creators have the ability to make their inventory look great and be searchable in a wide variety of ways. You won't find properties with generic inventory, low resolution pictures and little ancillary content that can easily be found everywhere else on the internet.  # Integrations We have already integrated with the most well-known channel managers so you don't have to. Once your properties are set up, you can finish the setup by mapping your property to wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API. - Allotz - CloudBeds / MyAllocator - Comanche - d-edge - FastBooking - HotelLink - HoteliersGuru - Omnibees - RateGain - Rate Tiger - ResAvenue - Siteminder - Sabre SynXis - Travelclick - Yieldplanet  # Intended Audience Programmers are [most likely] a requirement to start integrating with wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible. - Hotel chains - Hotel brands - Travel tech companies - Destination sites - Integrators - Aggregators - Destination management companies - Travel agencies - OTAs  
 *
 * The version of the OpenAPI document: 30.2.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.extranet.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateScheduleItemRequestSupplier
 */
@JsonPropertyOrder({
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_START,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_END,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_START_TIMEZONE,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_END_TIMEZONE,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_IS_ALL_DAY,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_RECURRENCE_RULE,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_RECURRENCE_ID,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_RECURRENCE_EXCEPTION,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_BOOKING_IDENTIFIER,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_TYPE,
  CreateScheduleItemRequestSupplier.JSON_PROPERTY_ATTENDEES
})
@JsonTypeName("CreateScheduleItemRequest_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:41:24.797077847+07:00[Asia/Bangkok]")
public class CreateScheduleItemRequestSupplier {
  public static final String JSON_PROPERTY_START = "start";
  private java.time.LocalDateTime start;

  public static final String JSON_PROPERTY_END = "end";
  private java.time.LocalDateTime end;

  public static final String JSON_PROPERTY_START_TIMEZONE = "startTimezone";
  private String startTimezone;

  public static final String JSON_PROPERTY_END_TIMEZONE = "endTimezone";
  private String endTimezone;

  public static final String JSON_PROPERTY_IS_ALL_DAY = "isAllDay";
  private Boolean isAllDay = false;

  public static final String JSON_PROPERTY_RECURRENCE_RULE = "recurrenceRule";
  private String recurrenceRule;

  public static final String JSON_PROPERTY_RECURRENCE_ID = "recurrenceId";
  private String recurrenceId;

  public static final String JSON_PROPERTY_RECURRENCE_EXCEPTION = "recurrenceException";
  private List<java.time.LocalDateTime> recurrenceException;

  public static final String JSON_PROPERTY_BOOKING_IDENTIFIER = "bookingIdentifier";
  private UUID bookingIdentifier;

  /**
   * The type of travel inventory.
   */
  public enum TypeEnum {
    ROOM_TYPE_ANCILLARY("ROOM_TYPE_ANCILLARY"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    SPA("SPA"),
    
    RESTAURANT("RESTAURANT"),
    
    ACTIVITY("ACTIVITY"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_ATTENDEES = "attendees";
  private Integer attendees = 1;

  public CreateScheduleItemRequestSupplier() {
  }

  public CreateScheduleItemRequestSupplier start(java.time.LocalDateTime start) {
    
    this.start = start;
    return this;
  }

   /**
   * Start date time of scheduled event
   * @return start
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getStart() {
    return start;
  }


  @JsonProperty(JSON_PROPERTY_START)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStart(java.time.LocalDateTime start) {
    this.start = start;
  }


  public CreateScheduleItemRequestSupplier end(java.time.LocalDateTime end) {
    
    this.end = end;
    return this;
  }

   /**
   * End date time of scheduled event
   * @return end
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.time.LocalDateTime getEnd() {
    return end;
  }


  @JsonProperty(JSON_PROPERTY_END)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnd(java.time.LocalDateTime end) {
    this.end = end;
  }


  public CreateScheduleItemRequestSupplier startTimezone(String startTimezone) {
    
    this.startTimezone = startTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return startTimezone
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStartTimezone() {
    return startTimezone;
  }


  @JsonProperty(JSON_PROPERTY_START_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartTimezone(String startTimezone) {
    this.startTimezone = startTimezone;
  }


  public CreateScheduleItemRequestSupplier endTimezone(String endTimezone) {
    
    this.endTimezone = endTimezone;
    return this;
  }

   /**
   * Schedule timezone
   * @return endTimezone
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEndTimezone() {
    return endTimezone;
  }


  @JsonProperty(JSON_PROPERTY_END_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndTimezone(String endTimezone) {
    this.endTimezone = endTimezone;
  }


  public CreateScheduleItemRequestSupplier isAllDay(Boolean isAllDay) {
    
    this.isAllDay = isAllDay;
    return this;
  }

   /**
   * Flag indicating whether this is an all day event.
   * @return isAllDay
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIsAllDay() {
    return isAllDay;
  }


  @JsonProperty(JSON_PROPERTY_IS_ALL_DAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIsAllDay(Boolean isAllDay) {
    this.isAllDay = isAllDay;
  }


  public CreateScheduleItemRequestSupplier recurrenceRule(String recurrenceRule) {
    
    this.recurrenceRule = recurrenceRule;
    return this;
  }

   /**
   * If rule is present, indicates that scheduled event is a recurring event. For more details go to the [iCalendar website](https://icalendar.org/)
   * @return recurrenceRule
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceRule() {
    return recurrenceRule;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceRule(String recurrenceRule) {
    this.recurrenceRule = recurrenceRule;
  }


  public CreateScheduleItemRequestSupplier recurrenceId(String recurrenceId) {
    
    this.recurrenceId = recurrenceId;
    return this;
  }

   /**
   * The parent ID of the recurring event.
   * @return recurrenceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecurrenceId() {
    return recurrenceId;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceId(String recurrenceId) {
    this.recurrenceId = recurrenceId;
  }


  public CreateScheduleItemRequestSupplier recurrenceException(List<java.time.LocalDateTime> recurrenceException) {
    
    this.recurrenceException = recurrenceException;
    return this;
  }

  public CreateScheduleItemRequestSupplier addRecurrenceExceptionItem(java.time.LocalDateTime recurrenceExceptionItem) {
    if (this.recurrenceException == null) {
      this.recurrenceException = new ArrayList<>();
    }
    this.recurrenceException.add(recurrenceExceptionItem);
    return this;
  }

   /**
   * Exceptions to the recurrence rule.
   * @return recurrenceException
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<java.time.LocalDateTime> getRecurrenceException() {
    return recurrenceException;
  }


  @JsonProperty(JSON_PROPERTY_RECURRENCE_EXCEPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecurrenceException(List<java.time.LocalDateTime> recurrenceException) {
    this.recurrenceException = recurrenceException;
  }


  public CreateScheduleItemRequestSupplier bookingIdentifier(UUID bookingIdentifier) {
    
    this.bookingIdentifier = bookingIdentifier;
    return this;
  }

   /**
   * Booking identifier this scheduled event was created as part of.
   * @return bookingIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getBookingIdentifier() {
    return bookingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookingIdentifier(UUID bookingIdentifier) {
    this.bookingIdentifier = bookingIdentifier;
  }


  public CreateScheduleItemRequestSupplier type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of travel inventory.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CreateScheduleItemRequestSupplier attendees(Integer attendees) {
    
    this.attendees = attendees;
    return this;
  }

   /**
   * Number of guests attending this event.
   * minimum: 1
   * @return attendees
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAttendees() {
    return attendees;
  }


  @JsonProperty(JSON_PROPERTY_ATTENDEES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAttendees(Integer attendees) {
    this.attendees = attendees;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateScheduleItemRequestSupplier createScheduleItemRequestSupplier = (CreateScheduleItemRequestSupplier) o;
    return Objects.equals(this.start, createScheduleItemRequestSupplier.start) &&
        Objects.equals(this.end, createScheduleItemRequestSupplier.end) &&
        Objects.equals(this.startTimezone, createScheduleItemRequestSupplier.startTimezone) &&
        Objects.equals(this.endTimezone, createScheduleItemRequestSupplier.endTimezone) &&
        Objects.equals(this.isAllDay, createScheduleItemRequestSupplier.isAllDay) &&
        Objects.equals(this.recurrenceRule, createScheduleItemRequestSupplier.recurrenceRule) &&
        Objects.equals(this.recurrenceId, createScheduleItemRequestSupplier.recurrenceId) &&
        Objects.equals(this.recurrenceException, createScheduleItemRequestSupplier.recurrenceException) &&
        Objects.equals(this.bookingIdentifier, createScheduleItemRequestSupplier.bookingIdentifier) &&
        Objects.equals(this.type, createScheduleItemRequestSupplier.type) &&
        Objects.equals(this.attendees, createScheduleItemRequestSupplier.attendees);
  }

  @Override
  public int hashCode() {
    return Objects.hash(start, end, startTimezone, endTimezone, isAllDay, recurrenceRule, recurrenceId, recurrenceException, bookingIdentifier, type, attendees);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateScheduleItemRequestSupplier {\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    startTimezone: ").append(toIndentedString(startTimezone)).append("\n");
    sb.append("    endTimezone: ").append(toIndentedString(endTimezone)).append("\n");
    sb.append("    isAllDay: ").append(toIndentedString(isAllDay)).append("\n");
    sb.append("    recurrenceRule: ").append(toIndentedString(recurrenceRule)).append("\n");
    sb.append("    recurrenceId: ").append(toIndentedString(recurrenceId)).append("\n");
    sb.append("    recurrenceException: ").append(toIndentedString(recurrenceException)).append("\n");
    sb.append("    bookingIdentifier: ").append(toIndentedString(bookingIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    attendees: ").append(toIndentedString(attendees)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

